c     include 'genasc'
c         to test  scvp0
c        character*70 ttl
c        character*16 capx, capy
c        open(13, file='c2s5001.#gd.data')
c        capx='depth'
c        capy='ne'
c        do 10 i=1, 3
c            e0=10.**i  *3.16
c            el=log10(e0)
c            write(ttl, '(''ep='',g13.3,''tev'')') e0
c            write(13) ttl
c            write(13) capx, capy
c            call scvp0(el, a, b, c, d, tm, toff)
c            do 20 dep=-600,1200., 10.
c                call avscv0(a, b, c, d, tm, toff, dep, ane)
c                write(13) dep, ane
c  20       continue
c            write(13) 1.e50, 1.e50
c  10   continue
c      end
c        **************************************************************
c        *
c        * scvp0:  get coeff. for <ne> transition curve in air
c        *         (cog normalized ) ( <> is geometrical one)
c        *
c        **************************************************************
c
c      transition curve is f(t)=a* t**c exp(  b(1-t) + d(1-t**2) )
c      where  d=(c-b)/2.  depth t is the normalzied one as t'/tm.
c      if curve is shifted by dt, use f( (t'-dt)/tm ).
c      where t' is actual depth
c
        subroutine scvp0(el, a, b, c, d, tm, toff)
c
c        el : input.   log10(eg/tev)
c    a,b,c,d: output.  d=(c-b)/2. for shower curve coefficients
c         tm: output.  max depth (cog normalized) - toff
c       toff: output.  offset value to be used as t(cog normalzied)-toff
c                      when computing shower curve.
c                t1   :  1/10*max point
c                t2   :  1/100*max point
           if(el .lt. 2.) then
               t2= 85.*el + 475.
           elseif(el .lt. 4.) then
               t2=40.*el + 565.
           else
               t2=22.5*el + 635.
           endif
           if(el .lt. 4.) then
               t1=-28.33*el - 311.6
           else
               t1=-12.5*el -375.
           endif
           tm=-50.
c
           toff=-414.6- 85.4*el
           t1=t1-toff
           t2=t2-toff
           tm=tm-toff
c
           call scvbc(t1, tm, t2, b, c)
           d=(c-b)/2
           if(el .lt. 2.) then
              a=514.*10.**(1.067*el)
           elseif(el .lt. 4.) then
              a=662.*10.**(1.012*el)
           else
              a=876.*10.**(.9816*el)
           endif
        end
