c     include 'genasc'
c         to test  scvg0
c        character*70 ttl
c        character*16 capx, capy
c        open(13, file='c2s5001.#gd.data')
c        capx='depth'
c        capy='ne'
c        do 10 i=1, 3
c            e0=10.**i
c            el=log10(e0)
c            write(ttl, '(''e0='',g13.3,''tev'')') e0
c            write(13) ttl
c            write(13) capx, capy
c            call scvg0(el, a, b, c, d, tm, toff)
c            do 20 dep=-600,1200., 10.
c                call avscv0(a, b, c, d, tm, toff, dep, ane)
c                write(13) dep, ane
c   20       continue
c            write(13) 1.e50, 1.e50
c  10   continue
c      end
c        **************************************************************
c        *
c        * scvg0:  get coeff. for <ne> transition curve in air
c        *         (cog normalized ) ( <> is geometrical one)
c        *
c        **************************************************************
c
c      transition curve is f(t)=a* t**c exp(  b(1-t) + d(1-t**2) )
c      where  d=(c-b)/2.  depth t is the normalzied one as t'/tm.
c      if curve is shifted by dt, use f( (t'-dt)/tm ).
c      where t' is actual depth
c
        subroutine scvg0(el, a, b, c, d, tm, toff)
c
c        el : input.   log10(eg/tev)
c    a,b,c,d: output.  d=(c-b)/2. for shower curve coefficients
c         tm: output.  max depth (cog normalized) - toff
c       toff: output.  offset value to be used as t(cog normalzied)-toff
c                      when computing shower curve.
c                t1   :  1/10*max point
c                t2   :  1/100*max point
c          if(el .lt. 2.) then
c                 direct simulation at low energy shows this is not
c                 needed.
c              t2=100.*el + 385.
c          else
               t2=41.25*el + 502.5
c          endif
           t1=-31.25*el - 257.5
           tm=-50.
c
           toff=-414.6- 85.4*el
           t1=t1-toff
           t2=t2-toff
           tm=tm-toff
c
           call scvbc(t1, tm, t2, b, c)
c          a=1.197e3* e0**0.983 =
           a=1.197e3* 10.**( .983*el)
           d=(c-b)/2
        end
