c     *****************************************************************
c     *                                                               *
c     *  ksinn:   sample interacting nucleon number                   *
c     *                                                               *
c     *****************************************************************
c
c      /usage/     call ksinn(e0, ihg, nn, nnint)
c  e0: total energy of a heavy projectile
c ihg: heavy group index of the projectile
c  nn: # of nucelons appearing from projectile in heavy-air collision.
c      (input).
c  nnint: output. # of interacting nucleons among them
c
                  subroutine ksinn(e0, ihg,  nn, nnint)
      include 'zheavy'
c
c        projectile mass
      mno= ihtom(ihg)
c                get average no. of interacting nucleons
      call kanin(e0, mno, avintn)
c                average no. of nucleons in fragments
      avfn=afptbl(ihg,1)
c       sample interacting nucleon number by binormial distribution
c       with prob. avintn/avfn
      call kbinom( avintn/avfn, nn, nnint)
      end
