c       ***********************************************************
c       *
c       * p   p inelastic cross-section
c       *
c       ****************** tested 88.08.11 *****************k.k ***
c
c   el: input. log10(  e kinetic energy/tev )
c              for e<300 mev xs=1.e-5
c              for e>100 gev xs at e=100gev is given
c
c   xs:output. inelastic cross-section in mb
c
        subroutine kppxs(el, xs)
        dimension ea(21), xsa(21)
c           ea in gev
      data (ea    (i),i=   1,  21)/
     1 0.301, 0.350, 0.400, 0.450, 0.500, 0.550, 0.600, 0.650, 0.700,
     2 0.800, 0.900, 1.000, 1.500, 2.000, 5.000, 7.000,10.000,20.000,
     340.000,50.000, 100. /
      data (xsa   (i),i=   1,  21)/
     1 0.000, 0.500, 1.000, 2.500, 5.000, 7.350,11.000,15.000,18.500,
     222.000,23.000,23.500,25.000,25.500,28.000,29.000,29.500,30.000,
     330.000,29.500,30.000/
        e=10.**el
        if(e .lt. .301e-3) then
           xs=1.e-5
        else
           ee=min(100.e-3, e)*1000.
           call kfrge(ea, 1, 21, ee, l, icon)
           xs=(xsa(l)-xsa(l-1))/(ea(l)-ea(l-1))*(ee-ea(l-1)) +
     *         xsa(l-1)
        endif
      end
