c     ***************************
c          convert xp inelastic x-section into x-a inelastic
        subroutine kpptpa(a, xspp, xspa)
c
c    a:   input.  mass # of the target
c   xspp: input.  x-section of xp   (mb)
c   xspa: output. x-section of xa   (mb)
c
        if(xspp .ge. 30.)then
            b=.462
        else
            b=.693
        endif
        e=xspp/30. -1.
        if(abs(e) .lt. .2) then
            xspa=253. * (1. + b*e + b*(b-1.)*e/2)
        else
            xspa=253. * (xspp/30.)**b
        endif
        if(a .ne. 14.5) then
            alfa=.725*(xspp/30.)**(-.153)
            xspa=xspa* (a/14.5)**alfa
        endif
      end
