c        ***************************************************
c        *
c        * knrml: to get integral of lateral for kdig, kdigb, kdip
c        *        kdipb
c        * lateral for gamma or proton shower as generated
c        *     by pb.5fe.1sc3.5 (kdigb, kdipb) or
c        *     by fe.1sc3.5 (kdig, kdip)
c        *
c        *
c        ***************************************************
c
         subroutine knrml(e0, zob, cosz, s, de, kcfx, kidx, sum)
c
c          kcfx: subroutine name.
c                  kcfg for kdig (lateral for gamma with fe.1sc3.5)
c                  kcfp for kdip (//          proton //)
c                  kcfgb for kdigb (//    for gamma with pb.5fe.1sc3.5)
c                  kcfpb for kdipb (//    for proton with pb.5fe.1sc3.5)
c          kidx: subroutine name
c                  kide for kdig, kdip
c                  kideb for kdigb, kdipb
              sum=0.
              sumuni=0.
              call kmolu(zob, cosz, rmu)
              if(s .gt. .65) then
                 r2=1.e-4
                 dr=.1
                 imx= 57
                 jmod=2
              else
                 r2=3.e-5
                 dr=.05
                 imx=100
                 jmod=4
              endif
              dr10=10.**dr
              do 100 i=1, imx
                  r1=r2
                  r2=r1*dr10
                  rr=(r1+r2)/2
c                   get ne density
                  call klee(s,rr, rhone)
c                   get correction factor  rho'/rho
                  call kcfx(e0, cosz, s, rr, cf)
c                   get  fraction of particles at rr with >de.
c                     r should be in m
                  if(de .eq. 0.) then
                     fr=1.
                  else
c                         fr changes slowly with r.
                     if(mod(i-1,jmod) .eq. 0) then
                        call kidx(e0, zob, s, cosz, 0,  rr*rmu, de, fr)
                     endif
                  endif
                  tmp=rhone*cf
                  sumuni=sumuni+ tmp*(r2-r1)*(r1+r2)
                  rhou=tmp*fr
                  sum=sum + rhou*(r2-r1)*(r1+r2)
  100         continue
c             sumuni=sumuni*3.1415
c                sumuni should be 1. but not, so renormalize
c             sum=sum*3.1415/sumuni
              sum=sum/sumuni
         end
