c     *****************************************************************
c     *                                                               *
c     *  kmfptb:  makes fragmentation parameter table for heavy ptcl  *
c     *           frgmentation sampling                               *
c     *                                                               *
c     *****************************************************************
c
c      /usage/     call kmfptb
c
c  -- input --
c              afptbl:  fragmentation matrix
c
c  -- process --
c        afptbl(i,j) is assumed to have <no. of heavy of group j> when
c        heavy of group i fragments.  for each group i, afptbl is
c        normalized so that the sum of them becomes 1 and then made to
c        be cumulative table such that   cfptbl(i,j) <= cfptbl(i,j+).
c
c
c  -- ouput --
c            cfptbl
c
c *** note *** this should be called only once in initialization
c
c
      subroutine kmfptb
      include 'zheavy'
c              block data name
         external  hvyfrg
c          do below for nucleus group 1 to maxhg
c
      do 100 i=1, maxhg
c              afptbl(i,j) containes <no. of nucleus of group j> when
c              nucleus of group i fragments  (j<=i)
c              get sum of them when group i fragments.
          call ksumr(afptbl(i,1), maxhg, i, sum)
c                normalize the table
          do 10 j=1, i
              cfptbl(i,j)=afptbl(i,j)/sum
   10     continue
c                make cumulative table
          do 50 j=1,i-1
             cfptbl(i,j+1)=cfptbl(i,j+1)+cfptbl(i,j)
   50     continue
c             for safety
          cfptbl(i,i)=1.
  100 continue
      end
