c>>>>>>>>>>>>>>>>>>>>>>>>>>>> kklibg >>>>>>>>>>>>>>>>>>>>>>>>>>>>
c    ----- klee test (lateral of electrons by e primary 1.e14-15ev) ---
c         character*20 ttl
c         character*16 capx, capy
c         real*4 sa(5)/.54, .80, 1.075, 1.28, 1.45/
c         open(13,file='c2s5001.#gd.data')
c         capx='r(m.u 2 r.l a)'
c         capy='2pir*rho'
c         do 100 s=.4, 1.8, .2
c             s=sa(is)
c             write(ttl,'(''s='',f5.2 )') s
c             write(13) ttl
c             write(13) capx, capy
c             r=1.e-4
c             do 50 ir=1,60
c                 call klee(s, r, rho)
c                 write(13) r, 2*3.1415*rho*r
c                 r=r*10.**.1
c  50         continue
c             write(13) 1.e50, 1.e50
c 100     continue
c         end
          subroutine klee(s, r, rho)
c            normalized electron lateral distribution for electron
c            primary in the atmsopere.
c            normalization is within 3 % accuracy.
c    s: input. age as determined by 1 dimensional cascade
c              .2 < s < 1.9
c    r: input. distance from the core in moliere unit (
c              m.u should be 2 r.l above
c              the depth ).
c              r>5.e-5
c    rho: output. electron density. integral of 2pi*r* rho(r) dr from
c            5.e-5 to inf = 1.
c
            parameter (p2=.15, p3=.6, pi=3.1415, tpi=2*pi)
c
               p1=10.**(  (((-0.75222*s+4.4412)*s-10.447)*s +11.531)*s
     *                     -3.8637 )
               p4= (.49803*s-2.4992)*s+1.8372
               p5=2.4235 - 0.37908*s
               if(r .gt. 0.) then
                  rho= p1 * r**(-p4) * (1.+ r/p2)**(-p3*log10(r)-p5)
     *              /tpi/r
               else
                  rho=0.
               endif
          end
