c     ********************************************************
c     *
c     * kierf:  inverse of the error function
c     *
c     ********************************************************
c
c      /usage/  call kierf(x, y, icon)
c      x:  input. see below
c      y: output. see below
c   icon: output. 0---> o.k
c                 1---> x is out of range (!x!>=1.0)
c                       y=1.e75(x>0) or -1.e75 (x<0)  is put
c   *** this is  the same as facom "ierf" in ssl2.
c        let erf=2/sqrt(pi) * intgral(0 to inf; exp(-t**2)dt)
c       this gives y such that  x=erf(y).
c
      subroutine kierf(x, y, icon)
c          inverse of error function
      real*8   eps, xn,xc,s,vs,w,p0,p1,q0,q1,p,q,cnst
      data cnst/2.5066282d0/, sqrt2/1.41421356/, eps/1.d-5/
c
      xn=(1.-x)/2
      ss=xn
      if(xn.le.0.) then
          icon=1
c         --> y=1.e75 => y=1.e38  by n.hotta (18 dec 1993)
          y=1.e38
      elseif(xn.gt.1.0)then
          icon=1
c         --> y=-1.e75 => y=-1.e38  by n.hotta (18 dec 1993)
          y=-1.e38
      else
         icon=0
         if(xn .gt. 0.5d0) then
             xn=1.d0-xn
         endif
         if(xn.ge.0.01) then
            xn=cnst*(0.5-xn)
            s=1.5d0*xn
            k=1
c              ..... do until ....
   40       continue
                w=s*s
                p=s
                q=s
                i=1
c                  ..... do until ....
   30           continue
                    q=q*w/(2*i+1)
                    p=p+q
                    i=i+1
                if(.not.
     *                      (i .gt. 15 .or. abs(q) .le. eps)
     *          ) goto 30
c                   ... end until ...
                xc=p-xn*dexp(0.5d0*w)
                s=s-xc
                k=k+1
            if(.not.
     *                 (k .gt. 10 .or. abs(xc) .le. eps)
     *      ) goto 40
c               ... end until ...
         else
            xn=cnst*xn
            xc=3.d0
            s=sqrt(-log(xc*xn)*2)
            xc=s+1.d0/s
            s=sqrt(-log(xc*xn)*2)
            k=1
c              ..... do until ....
   20       continue
               vs=s
               if(vs.lt.7.5d0) then
                   in=27.d0/(vs-1.d0)
               else
                   in=4
               endif
               w=s*s
               p0=0.
               p1=1.d0
               q0=1.d0
               q1=s
               do 10 i=1,in
                   xc=i
                   p=s*p1+xc*p0
                   q=s*q1+xc*q0
                   p0=p1
                   q0=q1
                   p1=p
                   q1=q
   10          continue
               xc=p/q-xn*dexp(0.5d0*w)
               s=s+xc
            if(.not.
     *                  (k .gt. 10 .or. abs(xc) .le. eps)
     *      ) goto 20
c               ... end until ...
         endif
         if(ss .gt.  0.5) then
             s=-s
         endif
         y=s/sqrt2
      endif
      end
