c     ****************************************************************
c     *                                                              *
c     *   kgauss: generates 2 independent gaussian random variables  *
c     *                                                              *
c     ****************************************************************
c
c  /usage/
c                call kgauss(av, s, x1, x2)
c
c     av:  average of gaussian distribution
c      s:  standard deviation //
c  x1,x2:  obtained 2 independent gaussian random variables
c
c
c   method:
c             generate following two:
c             sqrt(-log(u)) * cos(p) and  sqrt(-log(u)) * sin(p)
c             then, they are independent gaussian radom variables
c             with mean 0 and variance 1.  here, u is uniform random
c             number in (0,1), and p in (0,2pi)
c        *** note ***  establish condition for rndc usage, if want to
c                      select one of rnd or rnd2.
c
c
      subroutine kgauss(av,s,x1,x2)
c
c
c           ..... do until ....
   20    continue
             call rndc(u1)
             call rndc(u2)
c              generate cos(p) and sin(p)
             u1=u1+u1-1.
             u1s=u1*u1
             u2s=u2*u2
             tmp=u1s+u2s
         if(.not.
     *               (tmp .lt. 1.)
     *   ) goto 20
c            ... end until ...
         call rndc(u3)
         al=alog(u3)
         al=sqrt(-al-al)
         cs=(u1s-u2s)/tmp
         sn=u1*u2/tmp
         sn=sn+sn
         x1=al*cs*s+av
         x2=al*sn*s+av
      end
