c          test kese0g, kese0p
c      character*70 txt
c      character*16 capx, capy
c      open(13, file='c2s5001.#gd.data')
c      capx='ne(b)'
c      capy='e0(tev)'
c      do 100 s=.3, 1.8, .1
c          write(txt,'(''proton: s='',f5.2)') s
c          write(13) txt
c          write(13) capx, capy
c          an=20.
c          do 20 i=1, 75
c             call kese0p(s, an, e0)
c             write(13) an, e0
c             an=an*10.**.1
c  20      continue
c          write(13) 1.e50, 1.e50
c 100  continue
c      end
c     ***************************************************************
c     *
c     * kese0g: get 1ry energy from age and ne(b-approx)
c     *         (as gamma 1ry shower)
c     * kese0p: get 1ry energy from age and ne(b-approx)
c     *         (as proton 1ry shower)
c     *
c     ***************************************************************
c
c   call kese0g(s, anb, e0)
c   call kese0p(s, anb, e0)
c
c    s:  input.  age as determined from lateral distribution fitting
c  anb:  input.  # of electrons (>1mev) corresponding to b-approx.
c
c   e0:  output.  estimated energy in tev.
c
c        standard shower feature is assumed.  e0=e0(s)* (ne/1.e5)**pw(s)
c        is used where  e0(s) is 1ry energy as a function of s at ne(b)=
c        1.e5, pw(s) the power dependence of e0 vs ne(b).
c
c               for gamma  shower
       subroutine kese0g(s, anb, e0)
c            log10(e0(s))
          e0s(x)=((( 12.798*x-52.448)*x +85.386)*x-64.611)*x+20.841
          pw(x)=(( 1.2682*x-2.9225)*x+1.9854)*x+0.6741
c
          ex=10.**(e0s(s))
          e0= ex*(anb/1.e5)**pw(s)
       end
