c         ***********************************************************
c         *
c         * kefgb: enfancement factor for gamma showers
c         *        ne'/ne for pb.5fe.1sc3.5 case.  ne=# of electrons
c         *        with > 1mev.
c         *        ne' is the # of particles giving de>0 in
c         *        the scinti.
c         * kefpb: the same as above for proton shower
c         *
c         *       note that this is obtained by emin(g)=2mev.  since
c         *       single ptcl de=7 mev,  we need lower emin(g) if the
c         *       threshold should be less than .2 ptcl level.
c         *       to have emin(g)=1 mev case, we need to increase the
c         *       ef by  factor 1.1
c         *       (lateral is affected also slightly)
c         *       kidegb must be modified also.
c         ***********************************************************
c
c    call kefgb(cosz, s, ef)
c  cosz:input.  cos of zenith angle
c     s:input.  age of the shower
c    ef:output. enfancement factor.
c
          subroutine kefgb(cosz, s, ef)
c               for cosz=1.
              r=( .383*s -0.1389)*s + 1.79
c                cosz correction ( verified uptp cos=0.7)
              ef=1. - (1.-cosz)* 0.575 + (r-1.)/cosz
          end
