c         ***********************************************************
c         *
c         * kefg: enfancement factor for gamma showers
c         *        ne'/ne for     fe.1sc3.5 case.  ne=# of electrons
c         *        with > 1mev.
c         *        ne' is the # of particles giving de>0 in
c         *        the scinti.
c         * kefp: the same as above for proton shower
c         *
c         *       note that this is obtained by emin(g)=2mev.  since
c         *       single ptcl de=7 mev,  we need lower emin(g) if the
c         *       threshold should be less than .2 ptcl level.
c         *       to have emin(g)=1 mev case, we need to increase the
c         *       ef by  factor .125(s-1.)+1.15
c         *       (lateral is affected also slightly)
c         *       kideg must be modified also.
c         *
c         ***********************************************************
c
c    call kefg(cosz, s, ef)
c  cosz:input.  cos of zenith angle
c     s:input.  age of the shower
c    ef:output. enfancement factor.
c
          subroutine kefg(cosz, s, ef)
c               for cosz=1.
              r= 1.012 + .4645*s
c                cosz correction (verified upto cos=.7)
c                for s< 1. should be examined.)
              ef=1. + (r-1.)/cosz
          end
