c        to test kdtff:
c     following include must be invoked.
c     include 'kdt'
c     include 'kdt1'
c     include 'stzss'
c     include 'cogg'
c     include 'ndtsg'
c      real*8 dist
c      open(13,file='c2s5001.#gd.data')
c      dist=10.d3
c      zob=610.
c      s=1.
c      cosz=1.0
c      de=7.
c      r=100.
c      do 100 i=1, 1000
c          call kdtff(dist, zob, cosz, s, i-1, de, r, dt)
c          write(13) dt
c 100  continue
c      end
c      ********************************************************
c      *
c      * kdtff: samples delay time from flat front of a.s
c      *        for detectors with 0.1cmfe + 3.5cmscinti
c      *
c      ********************************************************
c
c  call kdtff(dist, zob, cosz, s, j1, de, r, dt)
c
c dist: input.  real*8.  distance (in m) from zob to the first
c               interaction point  (slant length)
c               this can be obtained by
c               dist=dstair(cosz, z0, zob/cosz)/100.d0
c  zob: input.   observation depth (vertical) (g/cm**2)
c cosz: input.   cos of the zenith angle
c    s: input.   age of the shower at zob. as determined by getage
c   j1: input.   0---> if some or all of the above parameters are
c                      diff. from the prevous call.
c               ^=0--> all of the above parameters are the same as
c                      the previous ones.
c   de: input.   energy deposit in scintillator (mev)
c    r: input.   distance from the core in m (should be measured
c                perpendicular to the a.s axis.
c
c   dt: output.  delay time from the hypothetical flat front. (ns)
c
c      *** note ***
c        to get relative delay time for each detector,
c        (distance to the flant front from the detector)/c must be
c         added. (this latter one may be negative depending on the
c         position of assumed front).
c
        subroutine kdtff(dist, zob, cosz, s, j1, de, r, dt)
      include 'zascns'
            real*8 dist
c                 sample delay time from the geometrical front
            call kdt(zob, cosz, s, j1, de, r, dtg)
c                 add delay time of the geometrical front
            if(r*30.  .lt. dist) then
                dt0=r**2/2/dist/vlight
            else
                dt0=(sqrt(dist**2+r**2)-dist)/vlight
            endif
            dt=dtg+dt0
        end
