c        test kdtb1:
c     program a:  to generate r,dt,de in #gd2.dat
c                 following must be activated
c  *include kdegb1
c  *include degbb
c
c     program b:  to extract data of r and dt for certain de
c                 after this, autoopx.data(satb) may be used for
c                 display (data is put to #gd.data)
c
c ------------------------ program a -------------------------
c      character*70 ttl
c      character*16 capx, capy, capz
c      open(13, file='c2s5001.#gd2.data')
c      ttl='test dt vs r'
c      capx='r(m)'
c      capy='dt(nsec)'
c      capz='de(mev)'
c      write(13) ttl
c      write(13) capx, capy, capz
c
c      do 1000 i=1,400000
c           call rndc(v)
c           call rndc(u)
c           if(u .lt. .5) then
c              r=-20.*log(v)
c           elseif(u .lt. .9) then
c              r=-100.*log(v)
c           else
c              r=-800.*log(v)
c           endif
c          call kdegb1(r, de)
c          call kdtb1(r, de, 1., dt)
c          write(13) r, dt, de
c1000  continue
c      end
c
c              --------------------- program b --------------------
c
c
c        parameter (nq=3, ih=220)
c        character*1  aa(256)
c        character*16 cap(nq)
c        character*256  txt
c        character*300  ttl
c        equivalence (aa(1), txt)
c        dimension h(ih,4)
c        logical eof/.false./
c             input
c        open(10, file='c2s5001.#gd2.data', action='read',
c    *   status='shr')
c             output
c        open(11, file='c2s5001.#gd.data',
c    *   action='write',status='shr')
c
c              neglect error for data record length <255
c          call errset(213, 256, -1, 0, 0, 213)
c          nput=0
c          nread=0
c          write(*,*) ' enter de min and max in mev'
c          demin=0.
c          demax=0.
c          read(*,*) demin, demax
c          write(*,*) ' de min=',demin, ' mev, max=',demax, ' mev'
c          read(10, end=100) aa
c          read(10, end=100) (cap(i),i=1,nq)
c          call kfsc(txt,')', -1, ll)
c          write(*,*) ' ll=',ll
c              write(ttl,'(''sapling test:de=('',f4.1,'','',f4.1,'')'',
c    *         '' mev'')')
c    *         demin, demax
c          l=klena(ttl)
c          write(11) ttl(1:l)
c             write(11)     cap(1), cap(2)
c          do 50 until (eof)
c              read(10, end=40) r, t, de
c              nread=nread+1
c              if(r .le.1.e36 .and. de .gt. demin  .and. de .le. demax)
c    *         then
c                      write(11) r,t
c                      nput=nput+1
c              endif
c              goto 50
c  40          continue
c              eof=.true.
c  50       continue
c           goto 120
c 100       write(*,*) ' strange'
c 120       continue
c           write(*,*) ' nread=', nread, ' nput=', nput
c           close(10)
c           close(11)
c        end
c      ****************************************************************
c      *
c      * kdtb1: sample arrival time of particles (gamma + electron)
c      *        as a function of r, de, age
c      *        time 0 is from geometrical front.
c      *        it is assumed that partilces are observed
c      *        by scintillator of 3.5 cm
c      *        thick above which 0.5 cm pb and .1 cm fe is placed.
c      *        this is based on m.c showers at 600 g/cm**2 initiated
c      *        100 tev elecrons.
c      *        for vertical showers
c      ****************************************************************
c
c /usage/ call kdtb1(r, de, s,    dt)
c
c     r: input.  distance from the a.s center (in m)
c                r should be measured perpendicular to the axis.
c    de: input.  energy deposit in mev in the scintllator.
c     s: input.  age of the shower
c
c    dt: output. delay time of the particle in nsec.  time 0 is
c                the time when a gamma ray directly comes to the
c                given r from the 1st interaction point of the 1ry.
c
       subroutine kdtb1(rr, dein, s,    dt)
c              standard shower age
      include 'zascns'
c
c          if(rr .lt. 30.) then
c                effective r at small r region.
c              r=rr*(s/ssage)**(3.14*exp(-rr/7.))
c          else
               r=rr
c          endif
           if(r .lt. 100.) then
               call kdtba(r, dein, dt)
           else
               call kdtbb(r, dein, dt)
           endif
       end
