c        test kdtb:
c     program a:  to generate r,dt,de in #gd2.dat
c                 following must be activated
c     include 'kdegb'
c     include 'kdtb1'
c     include 'kdegb1'
c     include 'degbb'
c     include 'kdegb2'
c     include 'kdegb3'
c     include 'degb2b'
c     include 'kmolu'
c     include 'stzss'
c     include 'cogg'
c     include 'ndtsg'
c
c     program b:  to extract data of r and dt for certain de
c                 after this, autoopx.data(satb) may be used for
c                 display (data is put to #gd.data)
c
c ------------------------ program a -------------------------
c      character*70 ttl
c      character*16 capx, capy, capz
c      open(13, file='c2s5001.#gd2.data')
c      ttl='test dt vs r'
c      capx='r(m)'
c      capy='dt(nsec)'
c      capz='de(mev)'
c      write(13) ttl
c      write(13) capx, capy, capz
c      e0=100.
c      zob= 738.
c      s=1.10
c      cosz=1.00
c--
c      do 100 i=1,130000
c           call rndc(v)
c           call rndc(u)
c           if(u .lt. .5) then
c              r=-20.*log(v)
c           elseif(u .lt. .9) then
c              r=-100.*log(v)
c           else
c              r=-800.*log(v)
c           endif
c           call kdegb(e0, zob, s,  cosz, i-1,  r, de)
c           call kdtb(zob, cosz, s, i-1,  de, r, dt)
c           write(13) r, dt, de
c 100  continue
c      end
c
c              --------------------- program b --------------------
c
c
c        parameter (nq=3, ih=220)
c        character*1  aa(256)
c        character*16 cap(nq)
c        character*256  txt
c        character*300  ttl
c        equivalence (aa(1), txt)
c        dimension h(ih,4)
c        logical eof/.false./
c---          input
c        open(10, file='c2s5001.#gd2.data', action='read',
c    *   status='shr')
c---          output
c        open(11, file='c2s5001.#gd.data',
c    *   action='write',status='shr')
c----
c----          neglect error for data record length <255
c          call errset(213, 256, -1, 0, 0, 213)
c          nput=0
c          nread=0
c          write(*,*) ' enter de min and max in mev'
c          demin=0.
c          demax=0.
c          read(*,*) demin, demax
c          write(*,*) ' de min=',demin, ' mev, max=',demax, ' mev'
c          read(10, end=100) aa
c          read(10, end=100) (cap(i),i=1,nq)
c          call kfsc(txt,')', -1, ll)
c          write(*,*) ' ll=',ll
c              write(ttl,'(''sapling test:de=('',f4.1,'','',f4.1,'')'',
c    *         '' mev'')')
c    *         demin, demax
c          l=klena(ttl)
c          write(11) ttl(1:l)
c             write(11)     cap(1), cap(2)
c          do 50 until (eof)
c              read(10, end=40) r, t, de
c              nread=nread+1
c              if(r .le.1.e36 .and. de .gt. demin  .and. de .le. demax)
c    *         then
c                      write(11) r,t
c                      nput=nput+1
c              endif
c              goto 50
c  40          continue
c              eof=.true.
c  50       continue
c           goto 120
c 100       write(*,*) ' strange'
c 120       continue
c           write(*,*) ' nread=', nread, ' nput=', nput
c           close(10)
c           close(11)
c        end
c     ******************************************************************
c     *
c     * kdtb: samples delay time of a shower particle (e or g)
c     *      which gives an  energy deposit = a given value in
c     *      scinti. of 3.5 cm thick placed under 0.5cm pb + .1 cm fe.
c     *
c     ******************************************************************
c
c     since explicit dependence on 1ry energy and 1ry type (g or p)
c     is not observed, it is not considered.
c
c  call kdtb(zob, cosz, s, j1,   de, r, dt)
c  zob: input. observation depth (g/cm**2) (vertical depth)
c cosz: input. cos of the zenith angle.
c    s: input. age of the shower at zob.  as given by getage
c   j1: input. 0--> above parameters may be different from the
c                   those in the previous call.
c              ^=0--> all the parameters are the same as previous
c                   one.
c   de: input. energy deposit in the scintillator of the particle.
c    r: input. distance from the axis of the shower (in m. measured
c              perpendicular to the axis.
c   dt: output. delay time in nsec of the particle.  note this is
c              the delay time measured from the geometrical front (
c              i.e.,  delay time from the time that a straight  light
c              from the starting point of the shower spent.
c
        subroutine kdtb(zob, cosz, s,   j1,  de, r, dt)
c
      include 'zascns'
c          data ssave/5./
c          if(j1 .eq. 0) then
c              if(abs(s/ssave-1.) .gt. smarg) then
c                  ssave=s
c                  call stzss(s, z)
c                  write(*,*) ' z=',z
c                  rf=sqrt(zob/z)
c                    at 1000 g/cm**2 s=0.55 --> z=200 g/cm**2 and rf=.5
c                     .3495=log10(rf)
c                  cf=log10(rf)*0.5/.3495
c              endif
c          endif
           if(r .eq. 0.) then
              dt=0.
           else
               if(de .lt. eqvo2) then
                   dee=de
               elseif(de .gt. eqvo2/cosz) then
                   dee=de*cosz
               else
                   dee=eqvo2
               endif
c                below 1ptcl, de dependece neglected
c              dee=max(dee, eqvo2)
c
c              call rndc(u)
c              rr=r*rf
               rr=r
               call kdtb1(rr, dee, s, dt)
c                   for rf=sqrt(5).
c              dt= dt * (1. - 0.5*dt/( 4.+dt))
c                   for rf=sqrt(3.)
c              dt= dt * (1. - 0.3417*dt/( 4.+dt))
c              dt= dt * (1. - cf*dt/( 4.+dt))
czzzzzzzzzzz
               dt=dt
czzzzzzzzzzz
           endif
        end
