c       ************************************************************
c       *
c       *  hv1ry
c       *
c       *
c                test kdhin
c
c     dimension znuc(56)
c     call  kmfptb
c     e0=50.
c     ihg=3
c     call kdhin(e0, ihg, zfirst, znuc, nucc)
c     write(*,*) ' zfirst=',zfirst
c     write(*,*) ' nucc=',nucc, ' znuc=', znuc
c     call kdhin(e0, ihg, zfirst, znuc, nucc)
c     write(*,*) ' zfirst=',zfirst
c     write(*,*) ' nucc=',nucc, ' znuc=', znuc
c     call kdhin(e0, ihg, zfirst, znuc, nucc)
c     write(*,*) ' zfirst=',zfirst
c     write(*,*) ' nucc=',nucc, ' znuc=', znuc
c     call kdhin(e0, ihg, zfirst, znuc, nucc)
c     write(*,*) ' zfirst=',zfirst
c     write(*,*) ' nucc=',nucc, ' znuc=', znuc
c     end
c
c ***********************************************************
c      kdhin:  decompose heavy into interacting nucleons
c ***********************************************************
c
c    call kdhin(e0, ihg, zfirst, znuc, nucc)
c   e0:input.  projectile heavy total energy in tev
c  ihg:input.  its heavy group index
c zfirst:output. first collision depth (slant) of the heavy
c               (g/cm**2)
c znuc: output. array to get the slant depth of the interaction
c               point of each interacting nucleon. (g/cm**2)
c nucc: output. # of interacting nucleons in znuc.
c  **note**
c        a heavy 1ry is made to collide in the atomsphere and
c        fragmenting projectile heavies,  non-interacting and
c        interacting nucleons are sampled.  interacting nucleons
c        are memorized their interaction depths in znuc.
c        for the non-interacting nucleons, their collision points
c        are sampled and also meorized in znuc.  heavy fragments
c        are further sampled to collide until all are decomposed
c        into nucleons and stored in znuc.  all nucleons are
c        assumed to have the same energy, e0/nucc
c
        subroutine kdhin(e0, ihg, zfirst, znuc, nucc)
      include 'zheavy'
c
         dimension  znuc(*)
c
c          local:  to store heavy fragments
c                 depth       mass        index
c       dimension zfrag(14), mfrag(14), ifrag(14)
c
c       14 => 30 change by  n.hotta (18 dec 1993)
        dimension zfrag(30), mfrag(30), ifrag(30)
c
c               sample 1st collision point
         mass=ihtom(ihg)
         call mfphv(e0, mass, fp)
         call rndc(u)
         zfirst=-log(u)*fp
c          store heavy in stack
         zfrag(1)=zfirst
         ifrag(1)=ihg
         mfrag(1)=mass
c            # of heavy in stack
         nhf=1
c            next heavy pos in stack
         lc=1
c            # of nucleon already collided
         nucc=0
         e0pn=e0/mass
         elog=log10(e0pn)
         zint=zfirst
c           ..... do until ....
  100    continue
c                  do until no heavy fragment appears
c                     sample and set fragmentation ptcls
               call ksfrag(e0pn*mfrag(lc), ifrag(lc),  ifrag(nhf+1),
     *         mfrag(nhf+1),  nhfc,  nnn, nin)
czzzzzzzzzzzzzzzzzzzz
c              write(*,*) ' heavy produced=', (ifrag(nhf+j),j=1,nhfc)
czzzzzzzzzzzzzzzzzzzzz
c                   store interacting nucleon
               do 120 i=1, nin
                    nucc=nucc+1
                    znuc(nucc)=zint
  120          continue
c                   store non interacting nucleon
c                   fix the collistion point
               do 130 i=1, nnn
                    call mfpp(elog, fp)
                    call rndc(u)
                    dz=-fp*log(u)
                    nucc=nucc+1
                    znuc(nucc)=zint+dz
  130          continue
               if(nhfc .gt. 0) then
c                   heavy fragment exists
                   do 140 i=1, nhfc
c                         set collision point
                       zfrag(i+nhf)=zint
  140              continue
               endif
c                  # of heavy in stack
               nhf=nhf+nhfc
c                   next heavy to be processed
               lc=lc+1
               if(lc .le. nhf)then
c                      next heavy collision point
                   call mfphv(e0pn*mfrag(lc), mfrag(lc), fp)
                   call rndc(u)
                   dz=-log(u)*fp
                   zint=zfrag(lc)+dz
               endif
           if(.not.
     *                (lc .gt. nhf)
     *     ) goto 100
c              ... end until ...
      end
