c        to test kdeg:  following must be activated
c            use rvsde command.
c     include 'kdeg1'
c     include 'degb'
c     include 'kdeg2'
c     include 'deg2b'
c     include 'kdeg3'
c     include 'deg3b'
c     include 'kmolu'
c     include 'stzss'
c     include 'cogg'
c     include 'ndtsg'
c       character*70 txt
c       character*16 capx, capy
c       open(13, file='c2s5001.#gd.data')
c       e0=100.
c       cosz=.75
c       zob=600.
c       s=0.6
c       write(txt,'('' zob='',f5.0,'' s='',f4.2, '' e0='',f6.2,''tev'',
c    *  '' cosz='',f4.2)') zob, s, e0, cosz
c       write(13) txt
c       capx='r(m)'
c       capy='de(gev)'
c       write(13) capx, capy
c
c       do 1000 i=1,   80000
c           call rndc(v)
c           call rndc(u)
c           if(u .lt. .5) then
c              r=-20.*log(v)
c           elseif(u .lt. .9) then
c              r=-100.*log(v)
c           else
c              r=-500.*log(v)
c           endif
c           call kdeg(e0, zob, s, cosz, i-1,  r, de)
c           write(13) r, de/1000.
c1000   continue
c     end
c           *****************************************************
c           *
c           * kdeg: sample energy deposit for gamma showers
c           *
c           *****************************************************
c    samples energy loss in scintillator of 3.5cm thick placed
c    horizontally under 0.1cm fe.  an air shower initiated
c    by 1ry energy e0 hits the detector at r from the axis.
c
c  call kdeg(e0, zob, s, cosz, j1,   r, de)
c    e0: input.   1ry energy in tev
c   zob: input.   observation depth (g/cm**2) (vertical)
c     s: input.   age of the shower as obtained by getage.
c  cosz: input.   cosine of the 1ry zenith angle.
c    j1: input.   0--> e0, zob, s, cosz are not equal to those in
c                      the previous call.
c                 ^0-->all e0, zob, s, and cosz are equal to those in
c                      the previous call.
c     r: input.   distance from the shower axis (in m. measured
c                 perpendicular to the axis).
c
c    de: output.  sampled energy loss in scinti. in mev.
c
        subroutine kdeg(e0, zob, s, cosz, j1,  rr, de)
c
      include 'zascns'
            data ssave/5./
            save ssave
c
            if(j1 .eq. 0) then
                if(abs(s/ssave-1.) .gt. smarg) then
                    ssave=s
c                   new parameters
c                     um1=m.u (2 r.l above the observation depht,
c                     along the 1ry direction) (in m)
                   call kmolu(zob, cosz, um1)
c                    um2=m.u  (same as above) for the dpeth where
c                    the standard shower takes the same age (=s) as the
c                    currently considered shower.
                   call stzss(s, z)
                   call kmolu(z, cosz, um2)
                   rcnv= sqrt( ssmu * um2)/um1
                endif
            endif
c               effective r
            r=rr*rcnv
            if(e0 .lt. .1) then
                r=r+10.
            endif
            if(cosz .gt. .9) then
c                  use vertical one
                call kdeg1(r, deo)
                de=deo/cosz
            elseif(cosz .gt. .75) then
c                  use cos=0.8
                call kdeg2(r, deo)
                de=deo*0.8/cosz
            else
c                  use cos=.7
                call kdeg3(r, deo)
                de=deo*.7/cosz
            endif
        end
