c     to test kcfpb:
c      character*70 txt
c      character*16 capx, capy
c      open(13,file='c2s5001.#gd.data')
c      cosz=1.
c      e0=100.
c      do 100 s=.4, 1.8, .1
c          write(txt,'(''s='',f4.2)') s
c          capx='r(m.u)'
c          capy='(fe.1sc3.5)/rho'
c          write(13) txt
c          write(13) capx, capy
c          r=1.e-4
c          do 20 i=1, 58
c             call kcfpb(e0, cosz, s, r, cf)
c             write(13) r, cf
c             r=r*10.**.1
c  20      continue
c          write(13) 1.e50, 1.e50
c 100  continue
c      end
c     *************************************************************
c     *
c     *  kcfpb: correction factor for lateral distribtuion when
c     *        proton showers are observed with pb.5fe.1sc3.5
c     *
c     *************************************************************
      subroutine kcfpb(e0, cosz, s, r, cf)
c       e0: input. 1ry energy in tev.
c                  at present not used.
c     cosz: input. cos of zenith
c        s: input. age of the proton shower
c                  for s<.4 or >1.7 not accurate.
c        r: input. distance measured in moliere unit.
c                  moliere unit should be at 2r.l above the observation
c                  depth (along 1ry direction).
c       cf: output. correction factor.
c           cf*rho(s,r) gives normalized lateral distribution
c           for particles giving de>0 in scinti.
c           rho is the output from klee.
      dimension rat(35, 13)
      dimension dty1(35), dty2(35), dty3(35), dty4(35), dty5(35)
      dimension dty6(35), dty7(35), dty8(35), dty9(35), dty10(35)
      dimension dty11(35), dty12(35), dty13(35)
      equivalence (rat(1,1), dty1(1))
      equivalence (rat(1,2), dty2(1))
      equivalence (rat(1,3), dty3(1))
      equivalence (rat(1,4), dty4(1))
      equivalence (rat(1,5), dty5(1))
      equivalence (rat(1,6), dty6(1))
      equivalence (rat(1,7), dty7(1))
      equivalence (rat(1,8), dty8(1))
      equivalence (rat(1,9), dty9(1))
      equivalence (rat(1,10), dty10(1))
      equivalence (rat(1,11), dty11(1))
      equivalence (rat(1,12), dty12(1))
      equivalence (rat(1,13), dty13(1))
c       rho*/rho=cf:  log10(cf) for log10(r)=-3.84 to 1.6 step .16
c    proton 10**14 ev rho(pb.5fe.1sc3.5)/lee s=0.4
      data (dty1  (i),i=   1,  35)/
     1 -1.398, -1.320, -1.176, -1.020, -0.905, -0.761, -0.641, -0.545,
     2 -0.461, -0.383, -0.335, -0.275, -0.221, -0.173, -0.107, -0.065,
     3 -0.023,  0.014,  0.074,  0.224,  0.368,  0.542,  0.734,  0.884,
     4  1.071,  1.245,  1.401,  1.635,  1.809,  1.947,  2.068,  2.116,
     5  2.152,  2.152,  2.158/
c    s=0.5
      data (dty2  (i),i=   1,  35)/
     1 -1.002, -0.857, -0.725, -0.647, -0.575, -0.515, -0.461, -0.407,
     2 -0.359, -0.317, -0.263, -0.215, -0.149, -0.095, -0.047, -0.017,
     3 -0.011, -0.005,  0.026,  0.116,  0.212,  0.368,  0.512,  0.668,
     4  0.818,  0.992,  1.155,  1.323,  1.491,  1.611,  1.725,  1.809,
     5  1.839,  1.857,  1.863/
c    s=0.6
      data (dty3  (i),i=   1,  35)/
     1 -0.899, -0.779, -0.677, -0.575, -0.473, -0.395, -0.329, -0.287,
     2 -0.227, -0.185, -0.131, -0.107, -0.077, -0.047, -0.029, -0.023,
     3 -0.017, -0.011,  0.008,  0.044,  0.074,  0.128,  0.230,  0.350,
     4  0.500,  0.686,  0.872,  1.047,  1.209,  1.341,  1.449,  1.551,
     5  1.629,  1.659,  1.665/
c    s=0.7
      data (dty4  (i),i=   1,  35)/
     1 -0.917, -0.743, -0.617, -0.503, -0.389, -0.293, -0.209, -0.149,
     2 -0.089, -0.053, -0.035, -0.023, -0.035, -0.041, -0.047, -0.065,
     3 -0.065, -0.053, -0.041, -0.017,  0.020,  0.080,  0.164,  0.296,
     4  0.422,  0.578,  0.728,  0.878,  1.059,  1.197,  1.323,  1.425,
     5  1.509,  1.551,  1.551/
c    s=0.8
      data (dty5  (i),i=   1,  35)/
     1 -0.881, -0.749, -0.623, -0.503, -0.395, -0.311, -0.233, -0.167,
     2 -0.119, -0.089, -0.065, -0.059, -0.059, -0.065, -0.065, -0.077,
     3 -0.083, -0.107, -0.107, -0.089, -0.041,  0.038,  0.092,  0.176,
     4  0.266,  0.386,  0.518,  0.644,  0.806,  0.998,  1.137,  1.263,
     5  1.341,  1.353,  1.365/
c    s=.9
      data (dty6  (i),i=   1,  35)/
     1 -1.194, -1.008, -0.833, -0.647, -0.497, -0.365, -0.269, -0.191,
     2 -0.125, -0.083, -0.053, -0.053, -0.047, -0.059, -0.077, -0.083,
     3 -0.077, -0.077, -0.089, -0.107, -0.095, -0.053,  0.008,  0.098,
     4  0.182,  0.284,  0.386,  0.500,  0.602,  0.716,  0.830,  0.920,
     5  1.005,  1.059,  1.065/
c    s=1.0
      data (dty7  (i),i=   1,  35)/
     1 -1.386, -1.218, -1.014, -0.827, -0.641, -0.485, -0.359, -0.251,
     2 -0.173, -0.107, -0.071, -0.041, -0.047, -0.047, -0.065, -0.071,
     3 -0.077, -0.089, -0.101, -0.113, -0.107, -0.083, -0.035,  0.026,
     4  0.116,  0.212,  0.338,  0.458,  0.542,  0.608,  0.656,  0.698,
     5  0.728,  0.752,  0.758/
c    s=1.1
      data (dty8  (i),i=   1,  35)/
     1 -1.386, -1.188, -1.020, -0.821, -0.635, -0.491, -0.371, -0.269,
     2 -0.197, -0.137, -0.095, -0.065, -0.047, -0.053, -0.065, -0.077,
     3 -0.095, -0.107, -0.113, -0.125, -0.113, -0.089, -0.053,  0.002,
     4  0.074,  0.176,  0.272,  0.362,  0.458,  0.518,  0.554,  0.566,
     5  0.554,  0.500,  0.410/
c    s=1.2
      data (dty9  (i),i=   1,  35)/
     1 -1.404, -1.284, -1.152, -0.977, -0.797, -0.635, -0.473, -0.365,
     2 -0.263, -0.185, -0.125, -0.095, -0.071, -0.065, -0.077, -0.089,
     3 -0.095, -0.101, -0.107, -0.119, -0.119, -0.107, -0.083, -0.029,
     4  0.038,  0.098,  0.188,  0.284,  0.362,  0.434,  0.458,  0.446,
     5  0.416,  0.326,  0.194/
c    s=1.3
      data (dty10 (i),i=   1,  35)/
     1 -1.398, -1.344, -1.295, -1.163, -0.953, -0.744, -0.581, -0.425,
     2 -0.317, -0.233, -0.173, -0.143, -0.125, -0.112, -0.118, -0.118,
     3 -0.117, -0.123, -0.135, -0.140, -0.140, -0.128, -0.115, -0.067,
     4 -0.007,  0.065,  0.143,  0.216,  0.294,  0.348,  0.360,  0.325,
     5  0.253,  0.158,  0.026/
c    s=1.4
      data (dty11 (i),i=   1,  35)/
     1 -1.470, -1.391, -1.307, -1.205, -1.031, -0.863, -0.713, -0.557,
     2 -0.413, -0.305, -0.215, -0.161, -0.125, -0.106, -0.094, -0.100,
     3 -0.105, -0.111, -0.117, -0.140, -0.128, -0.110, -0.097, -0.079,
     4 -0.013,  0.035,  0.107,  0.192,  0.270,  0.294,  0.288,  0.253,
     5  0.181,  0.050, -0.082/
c    s=1.5
      data (dty12 (i),i=   1,  35)/
     1 -1.446, -1.355, -1.295, -1.247, -1.163, -1.073, -0.875, -0.659,
     2 -0.485, -0.347, -0.257, -0.191, -0.142, -0.112, -0.112, -0.106,
     3 -0.111, -0.117, -0.135, -0.140, -0.134, -0.128, -0.103, -0.067,
     4 -0.019,  0.017,  0.066,  0.168,  0.216,  0.246,  0.234,  0.181,
     5  0.091, -0.058, -0.201/
c    s=1.6
      data (dty13 (i),i=   1,  35)/
     1 -1.559, -1.499, -1.445, -1.403, -1.307, -1.217, -1.084, -0.749,
     2 -0.533, -0.395, -0.305, -0.227, -0.184, -0.154, -0.142, -0.160,
     3 -0.153, -0.165, -0.165, -0.158, -0.158, -0.152, -0.127, -0.097,
     4 -0.055, -0.001,  0.060,  0.108,  0.162,  0.210,  0.205,  0.151,
     5  0.050, -0.106, -0.297/
c         effective s
       rs=1. - 1./(1. + exp(r-8.))
       si=s*( -0.0285 *log10(e0/100.)*rs + 1.)
       if(si .lt. .3) then
         si=.3
       elseif(si .gt. 1.7) then
         si=1.7
       endif
       if(r .lt. 1.e-4) then
          ri=1.e-4
       elseif(r .gt. 70.) then
          ri=70.
       else
          ri=r
       endif
       if(ri .gt. 8.) then
           c=-3.5*(cosz-1.) + 1.
           ri=(ri-8.)*c   + 8.
       endif
       ri=log10(ri)
c
       call
     * k4ptdi(rat, 35, 13, 35, -3.80, 0.4, .158, .1, ri, si,    ans)
       cf=10.**(ans)
       end
