c     to text kcfp:
c      character*70 txt
c      character*16 capx, capy
c      open(13,file='c2s5001.#gd.data')
c      cosz=1.
c      e0=100.
c      do 100 s=.4, 1.8, .1
c          write(txt,'(''s='',f4.2)') s
c          capx='r(m.u)'
c          capy='(fe.1sc3.5)/rho'
c          write(13) txt
c          write(13) capx, capy
c          r=1.e-4
c          do 20 i=1, 58
c             call kcfp(e0, cosz, s, r, cf)
c             write(13) r, cf
c             r=r*10.**.1
c  20      continue
c          write(13) 1.e50, 1.e50
c 100  continue
c      end
c     *************************************************************
c     *
c     *  kcfp: correction factor for lateral distribtuion when
c     *        proton showers are observed with fe.1sc3.5
c     *
c     *************************************************************
      subroutine kcfp(e0, cosz, s, r, cf)
c       e0: input. 1ry energy in tev.
c     cosz: input. cos of zenith
c        s: input. age of the proton shower
c                  for s<.5 or >1.6 not accurate.
c        r: input. distance measured in moliere unit.
c                  moliere unit should be at 2r.l above the observation
c                  depth (along 1ry direction).
c       cf: output. correction factor.
c           cf*rho(s,r) gives normalized lateral distribution
c           for particles giving de>0 in scinti.
c           rho is the output from klee.
      dimension rat(35, 12)
      dimension dty1(35), dty2(35), dty3(35), dty4(35), dty5(35)
      dimension dty6(35), dty7(35), dty8(35), dty9(35), dty10(35)
      dimension dty11(35), dty12(35)
      equivalence (rat(1,1), dty1(1))
      equivalence (rat(1,2), dty2(1))
      equivalence (rat(1,3), dty3(1))
      equivalence (rat(1,4), dty4(1))
      equivalence (rat(1,5), dty5(1))
      equivalence (rat(1,6), dty6(1))
      equivalence (rat(1,7), dty7(1))
      equivalence (rat(1,8), dty8(1))
      equivalence (rat(1,9), dty9(1))
      equivalence (rat(1,10), dty10(1))
      equivalence (rat(1,11), dty11(1))
      equivalence (rat(1,12), dty12(1))
c    proton fe.1sc3.5/lee s=.5
c       rho*/rho=cf:  log10(cf) for log10(r)=-3.84 to 1.6 step .16
c
      data (dty1  (i),i=   1,  35)/
c    1-1.3165,-1.2388,-1.1379,-1.0447,-0.8819,-0.6881,-0.5408,-0.3935,
     1-1.3565,-1.2388,-1.0579,-0.9047,-0.7819,-0.6481,-0.5108,-0.3935,
     2-0.3003,-0.2303,-0.1758,-0.1213,-0.0899,-0.0508,-0.0117, 0.0118,
c    3 0.0509, 0.0978, 0.1523, 0.2145, 0.2923, 0.4241, 0.5559, 0.7419,
     3 0.0509, 0.0978, 0.1523, 0.2145, 0.2923, 0.4241, 0.5559, 0.7119,
c    4 0.9279, 1.1680, 1.3772, 1.6096, 1.8574, 2.1130, 2.2139, 2.2530,
     4 0.9079, 1.0680, 1.2772, 1.5096, 1.7574, 2.0130, 2.1139, 2.1530,
c    5 2.2612, 2.2539, 2.2620/
     5 2.2012, 2.2239, 2.2320/
c      s=.6
      data (dty2  (i),i=   1,  35)/
     1  -1.10,  -0.98,  -0.82,  -0.70,  -0.60,  -0.49,  -0.39,  -0.32,
     2  -0.24,  -0.20,  -0.15,  -0.11,  -0.08,  -0.06,  -0.05,  -0.04,
     3  -0.02,   0.00,   0.03,   0.09,   0.17,   0.28,   0.36,   0.46,
     4   0.58,   0.72,   0.87,   1.03,   1.25,   1.48,   1.66,   1.90,
     5   2.08,   2.12,   2.12/
c    s=.7
      data (dty3  (i),i=   1,  35)/
     1  -1.05,  -0.90,  -0.78,  -0.67,  -0.55,  -0.46,  -0.38,  -0.30,
     2  -0.25,  -0.21,  -0.19,  -0.16,  -0.14,  -0.12,  -0.10,  -0.10,
     3  -0.07,  -0.04,   0.01,   0.07,   0.12,   0.21,   0.29,   0.39,
     4   0.48,   0.60,   0.71,   0.84,   1.01,   1.18,   1.32,   1.48,
     5   1.58,   1.62,   1.64/
c    s=0.8
      data (dty4  (i),i=   1,  35)/
     1  -1.28,  -1.20,  -1.10,  -0.94,  -0.78,  -0.61,  -0.46,  -0.36,
     2  -0.28,  -0.24,  -0.20,  -0.17,  -0.14,  -0.14,  -0.12,  -0.12,
     3  -0.13,  -0.09,  -0.05,   0.00,   0.05,   0.12,   0.21,   0.29,
     4   0.38,   0.47,   0.57,   0.69,   0.81,   0.95,   1.06,   1.19,
     5   1.29,   1.37,   1.39/
c    s=0.9
      data (dty5  (i),i=   1,  35)/
     1  -1.28,  -1.14,  -1.08,  -0.95,  -0.80,  -0.63,  -0.50,  -0.40,
     2  -0.32,  -0.26,  -0.24,  -0.21,  -0.20,  -0.20,  -0.19,  -0.18,
     3  -0.16,  -0.14,  -0.10,  -0.05,   0.00,   0.06,   0.11,   0.18,
     4   0.26,   0.35,   0.45,   0.55,   0.67,   0.82,   0.90,   0.98,
     5   1.03,   1.07,   1.07/
c    s=1.0
      data (dty6  (i),i=   1,  35)/
     1 -1.392, -1.260, -1.105, -0.926, -0.771, -0.616, -0.491, -0.398,
     2 -0.320, -0.272, -0.248, -0.216, -0.207, -0.191, -0.182, -0.181,
     3 -0.165, -0.156, -0.140, -0.108, -0.068,  0.002,  0.057,  0.120,
     4  0.198,  0.292,  0.377,  0.479,  0.596,  0.689,  0.752,  0.791,
     5  0.815,  0.793,  0.740/
c    s=1.1
      data (dty7  (i),i=   1,  35)/
     1  -1.26,  -1.21,  -1.11,  -0.94,  -0.80,  -0.62,  -0.51,  -0.41,
     2  -0.30,  -0.24,  -0.20,  -0.17,  -0.15,  -0.13,  -0.11,  -0.11,
     3  -0.10,  -0.11,  -0.10,  -0.11,  -0.09,  -0.04,   0.01,   0.07,
     4   0.14,   0.23,   0.33,   0.42,   0.53,   0.60,   0.64,   0.62,
     5   0.59,   0.54,   0.45/
c    s=1.2
      data (dty8  (i),i=   1,  35)/
     1 -1.476, -1.391, -1.282, -1.073, -1.010, -0.816, -0.653, -0.506,
     2 -0.412, -0.326, -0.271, -0.216, -0.192, -0.176, -0.159, -0.151,
     3 -0.126, -0.125, -0.117, -0.100, -0.084, -0.060, -0.020,  0.043,
     4  0.105,  0.199,  0.277,  0.371,  0.441,  0.512,  0.544,  0.537,
     5  0.476,  0.369,  0.262/
c    s=1.3
      data (dty9  (i),i=   1,  35)/
     1 -1.507, -1.414, -1.351, -1.296, -1.126, -1.001, -0.877, -0.691,
     2 -0.536, -0.396, -0.310, -0.239, -0.177, -0.137, -0.098, -0.096,
     3 -0.103, -0.118, -0.124, -0.131, -0.099, -0.075, -0.035,  0.012,
     4  0.075,  0.160,  0.254,  0.332,  0.380,  0.442,  0.459,  0.413,
     5  0.322,  0.207,  0.116/
c    s=1.4
      data (dty10 (i),i=   1,  35)/
     1  -1.46,  -1.38,  -1.33,  -1.30,  -1.27,  -1.17,  -0.96,  -0.83,
     2  -0.66,  -0.52,  -0.41,  -0.31,  -0.24,  -0.20,  -0.15,  -0.15,
     3  -0.13,  -0.13,  -0.14,  -0.13,  -0.15,  -0.12,  -0.09,  -0.04,
     4   0.02,   0.08,   0.17,   0.23,   0.29,   0.33,   0.32,   0.28,
     5   0.19,   0.07,  -0.02/
c    s=1.5
      data (dty11 (i),i=   1,  35)/
     1  -1.63,    -1.49,  -1.44,  -1.40,  -1.38,  -1.30,
     2  -1.21,  -0.99,  -0.83,  -0.69,  -0.53,  -0.40,  -0.29,  -0.23,
     3  -0.17,  -0.14,  -0.14,  -0.13,  -0.16,  -0.19,  -0.19,  -0.18,
     4  -0.15,  -0.11,  -0.06,  -0.01,   0.05,   0.12,   0.18,   0.23,
     5   0.21,   0.16,   0.06,  -0.05,  -0.13/
c    s=1.6
      data (dty12 (i),i=   1,  35)/
     1  -1.46,  -1.45,  -1.43,  -1.43,  -1.40,  -1.34,  -1.27,  -1.19,
     2  -1.02,  -0.85,  -0.68,  -0.54,  -0.40,  -0.29,  -0.23,  -0.18,
     3  -0.16,  -0.16,  -0.17,  -0.19,  -0.20,  -0.18,  -0.16,  -0.14,
     4  -0.11,  -0.06,   0.02,   0.07,   0.11,   0.12,   0.10,   0.03,
     5  -0.07,  -0.14,  -0.20/
c
c         effective s
       rs=1. - 1./(1. + exp(r-8.))
       si=s*( -0.0285 *log10(e0/100.)*rs + 1.)
       if(si .lt. .4) then
         si=.4
       elseif(si .gt. 1.7) then
         si=1.7
       endif
       if(r .lt. 1.e-4) then
          ri=1.e-4
       elseif(r .gt. 70.) then
          ri=70.
       else
          ri=r
       endif
       if(ri .gt. 8.) then
           c=-3.5*(cosz-1.) + 1.
           ri=(ri-8.)*c   + 8.
       endif
       ri=log10(ri)
c
       call
     * k4ptdi(rat, 35, 12, 35, -3.84, 0.5, .16, .1, ri, si,    ans)
       cf=10.**(ans)
       end
