c     to text kcfgb:
c      character*70 txt
c      character*16 capx, capy
c      open(13,file='c2s5001.#gd.data')
c      cosz=1.
c      e0=100.
c      do 100 s=.5, 1.8, .1
c          write(txt,'(''s='',f4.2)') s
c          capx='r(m.u)'
c          capy='(fe.1sc3.5)/rho'
c          write(13) txt
c          write(13) capx, capy
c          r=1.e-4
c          do 20 i=1, 58
c             call kcfgb(e0, cosz, s, r, cf)
c             write(13) r, cf
c             r=r*10.**.1
c  20      continue
c          write(13) 1.e50, 1.e50
c 100  continue
c      end
c     *************************************************************
c     *
c     *  kcfgb: correction factor for lateral distribtuion when
c     *        gamma showers are observed with pb.5fe.1sc3.5
c     *
c     *************************************************************
      subroutine kcfgb(e0, cosz, s, r, cf)
c       e0: input. 1ry energy in tev.
c                  at present not used.
c     cosz: input. cos of zenith
c        s: input. age of the gamma shower
c                  for s<.4 or >1.7 not accurate.
c        r: input. distance measured in moliere unit.
c                  moliere unit should be at 2r.l above the observation
c                  depth (along 1ry direction).
c       cf: output. correction factor.
c           cf*rho(s,r) gives normalized lateral distribution
c           for particles giving de>0 in scinti.
c           rho is the output from klee.
      dimension rat(35, 14)
      dimension dty1(35), dty2(35), dty3(35), dty4(35), dty5(35)
      dimension dty6(35), dty7(35), dty8(35), dty9(35), dty10(35)
      dimension dty11(35), dty12(35), dty13(35), dty14(35)
      equivalence (rat(1,1), dty1(1))
      equivalence (rat(1,2), dty2(1))
      equivalence (rat(1,3), dty3(1))
      equivalence (rat(1,4), dty4(1))
      equivalence (rat(1,5), dty5(1))
      equivalence (rat(1,6), dty6(1))
      equivalence (rat(1,7), dty7(1))
      equivalence (rat(1,8), dty8(1))
      equivalence (rat(1,9), dty9(1))
      equivalence (rat(1,10), dty10(1))
      equivalence (rat(1,11), dty11(1))
      equivalence (rat(1,12), dty12(1))
      equivalence (rat(1,13), dty13(1))
      equivalence (rat(1,14), dty14(1))
c    rho(pb.5fe.1sc3.5)/lee for 10**14 e-; s=0.4
      data (dty1  (i),i=   1,  35)/
     1  0.148,  0.155,  0.162,  0.151,  0.146,  0.129,  0.106,  0.089,
     2  0.060,  0.013, -0.028, -0.087, -0.140, -0.176, -0.199, -0.210,
     3 -0.209, -0.202, -0.195, -0.188, -0.169, -0.156, -0.125, -0.082,
     4 -0.033,  0.010,  0.047,  0.072,  0.097,  0.110,  0.087,  0.052,
     5 -0.013, -0.126, -0.264/
c    s=.5
      data (dty2  (i),i=   1,  35)/
     1  0.115,  0.128,  0.141,  0.154,  0.149,  0.144,  0.150,  0.121,
     2  0.110,  0.068,  0.033, -0.020, -0.068, -0.115, -0.144, -0.162,
     3 -0.173, -0.184, -0.195, -0.177, -0.170, -0.115, -0.078, -0.041,
     4  0.002,  0.051,  0.094,  0.143,  0.174,  0.199,  0.206,  0.140,
     5  0.057, -0.027, -0.267/
c    s=0.6
      data (dty3  (i),i=   1,  35)/
     1  0.063,  0.079,  0.103,  0.112,  0.113,  0.114,  0.100,  0.101,
     2  0.071,  0.034,  0.004, -0.026, -0.056, -0.085, -0.107, -0.122,
     3 -0.167, -0.181, -0.203, -0.195, -0.178, -0.146, -0.099, -0.006,
     4  0.087,  0.196,  0.305,  0.406,  0.491,  0.546,  0.547,  0.479,
     5  0.326,  0.020, -0.279/
c    s=0.7
      data (dty4  (i),i=   1,  35)/
     1 -0.002,  0.017,  0.036,  0.043,  0.043,  0.044,  0.033,  0.022,
     2  0.016,  0.005, -0.012, -0.035, -0.065, -0.088, -0.124, -0.153,
     3 -0.170, -0.176, -0.175, -0.168, -0.161, -0.100, -0.033,  0.041,
     4  0.144,  0.229,  0.339,  0.467,  0.564,  0.650,  0.693,  0.651,
     5  0.531,  0.145, -0.265/
c    s=0.8
      data (dty5  (i),i=   1,  35)/
     1 -0.047, -0.035, -0.022, -0.009, -0.009, -0.008, -0.013, -0.007,
c    2 -0.018, -0.017, -0.029, -0.034, -0.058, -0.075, -0.081, -0.086,
     2 -0.018, -0.017, -0.029, -0.046, -0.070, -0.086, -0.113, -0.130,
c    3 -0.097, -0.091, -0.090, -0.083, -0.071, -0.022,  0.045,  0.124,
     3 -0.155, -0.155, -0.149, -0.142, -0.108, -0.070, -0.005,  0.084,
     4  0.203,  0.306,  0.415,  0.554,  0.633,  0.700,  0.731,  0.719,
     5  0.636,  0.395, -0.158/
c    s=0.9
      data (dty6  (i),i=   1,  35)/
     1 -0.037, -0.021,  0.003,  0.012,  0.013,  0.022,  0.030,  0.031,
     2  0.033, -0.028, -0.019, -0.026, -0.033, -0.039, -0.069, -0.091,
     3 -0.113, -0.135, -0.150, -0.141, -0.155, -0.139, -0.084, -0.014,
     4  0.064,  0.158,  0.259,  0.367,  0.468,  0.523,  0.532,  0.448,
     5  0.296,  0.027, -0.325/
c    s=1.0
      data (dty7  (i),i=   1,  35)/
     1 -0.023, -0.004,  0.015,  0.021,  0.034,  0.035,  0.036,  0.042,
     2  0.043,  0.044,  0.039,  0.028,  0.016, -0.007, -0.042, -0.077,
     3 -0.100, -0.123, -0.128, -0.134, -0.115, -0.102, -0.071,  0.001,
     4  0.074,  0.171,  0.255,  0.352,  0.436,  0.467,  0.486,  0.421,
     5  0.308,  0.015, -0.295/
c    s=1.1
      data (dty8  (i),i=   1,  35)/
     1  0.017,  0.027,  0.036,  0.045,  0.047,  0.057,  0.058,  0.067,
     2  0.069,  0.063,  0.065,  0.051,  0.037,  0.008, -0.029, -0.058,
     3 -0.087, -0.093, -0.099, -0.105, -0.119, -0.102, -0.085, -0.037,
     4  0.034,  0.120,  0.229,  0.323,  0.409,  0.457,  0.466,  0.422,
     5  0.324,  0.094, -0.296/
c    s=1.2
      data (dty9  (i),i=   1,  35)/
     1  0.110,  0.135,  0.144,  0.145,  0.147,  0.149,  0.143,  0.136,
     2  0.123,  0.101,  0.088,  0.066,  0.045,  0.008, -0.021, -0.050,
     3 -0.087, -0.101, -0.115, -0.121, -0.119, -0.117, -0.093, -0.037,
     4  0.026,  0.112,  0.214,  0.308,  0.386,  0.419,  0.405,  0.368,
     5  0.254,  0.064, -0.312/
c    s=1.3
      data (dty10 (i),i=   1,  35)/
     1  0.240,  0.250,  0.244,  0.245,  0.232,  0.233,  0.235,  0.221,
     2  0.200,  0.178,  0.157,  0.120,  0.091,  0.046,  0.002, -0.035,
     3 -0.072, -0.093, -0.115, -0.121, -0.127, -0.118, -0.101, -0.053,
     4  0.018,  0.081,  0.175,  0.262,  0.340,  0.388,  0.397,  0.353,
     5  0.239,  0.041, -0.258/
c    s=1.4
      data (dty11 (i),i=   1,  35)/
     1  0.140,  0.181,  0.190,  0.215,  0.224,  0.218,  0.220,  0.213,
     2  0.200,  0.171,  0.134,  0.097,  0.045,  0.008, -0.029, -0.066,
     3 -0.087, -0.109, -0.115, -0.128, -0.127, -0.117, -0.093, -0.045,
     4 -0.036,  0.051,  0.129,  0.215,  0.302,  0.334,  0.343,  0.291,
     5  0.216, -0.013, -0.319/
c    s=1.5
      data (dty12 (i),i=   1,  35)/
     1  0.171,  0.196,  0.198,  0.215,  0.216,  0.210,  0.204,  0.198,
     2  0.169,  0.148,  0.118,  0.082,  0.045,  0.008, -0.021, -0.050,
     3 -0.095, -0.108, -0.130, -0.144, -0.150, -0.133, -0.124, -0.091,
     4 -0.043,  0.035,  0.083,  0.169,  0.248,  0.288,  0.289,  0.245,
     5  0.170,  0.018, -0.311/
c    s=1.6
      data (dty13 (i),i=   1,  35)/
     1  0.117,  0.150,  0.159,  0.161,  0.170,  0.164,  0.158,  0.152,
     2  0.131,  0.101,  0.072,  0.058,  0.037,  0.008, -0.029, -0.058,
     3 -0.095, -0.124, -0.145, -0.175, -0.173, -0.163, -0.139, -0.099,
     4 -0.059, -0.011,  0.060,  0.138,  0.194,  0.234,  0.236,  0.176,
     5  0.085, -0.075, -0.304/
c    s=1.7
      data (dty14 (i),i=   1,  35)/
     1  0.056,  0.073,  0.082,  0.076,  0.086,  0.079,  0.081,  0.075,
     2  0.069,  0.063,  0.041,  0.012,  0.006, -0.030, -0.037, -0.073,
     3 -0.110, -0.124, -0.137, -0.152, -0.150, -0.141, -0.116, -0.068,
     4 -0.028, -0.011,  0.037,  0.077,  0.125,  0.157,  0.166,  0.130,
     5  0.039, -0.090, -0.304/
c         effective s
       rs=1. - 1./(1. + exp(r-8.))
       si=s*( -0.0285 *log10(e0/100.)*rs + 1.)
       if(si .lt. .3) then
         si=.4
       elseif(si .gt. 1.8) then
         si=1.7
       endif
       if(r .lt. 1.e-4) then
          ri=1.e-4
       elseif(r .gt. 70.) then
          ri=70.
       else
          ri=r
       endif
       if(ri .gt. 8.) then
           c=-3.5*(cosz-1.) + 1.
           ri=(ri-8.)*c   + 8.
       endif
       ri=log10(ri)
c
       call
     * k4ptdi(rat, 35, 14, 35, -3.80, 0.4, .158, .1, ri, si,    ans)
       cf=10.**(ans)
       end
