c     to text kcfg:
c      character*70 txt
c      character*16 capx, capy
c      open(13,file='c2s5001.#gd.data')
c      cosz=1.
c      e0=100.
c      do 100 s=.4, 1.8, .1
c          write(txt,'(''s='',f4.2)') s
c          capx='r(m.u)'
c          capy='(fe.1sc3.5)/rho'
c          write(13) txt
c          write(13) capx, capy
c          r=1.e-4
c          do 20 i=1, 58
c             call kcfg(e0, cosz, s, r, cf)
c             write(13) r, cf
c             r=r*10.**.1
c  20      continue
c          write(13) 1.e50, 1.e50
c 100  continue
c      end
c     *************************************************************
c     *
c     *  kcfg: correction factor for lateral distribtuion when
c     *        gamma showers are observed with fe.1sc3.5
c     *
c     *************************************************************
      subroutine kcfg(e0, cosz, s, r, cf)
c       e0: input. 1ry energy in tev.
c                  at present not used.
c     cosz: input. cos of zenith
c        s: input. age of the gamma shower
c                  for s<.4 or >1.6 not accurate.
c        r: input. distance measured in moliere unit.
c                  moliere unit should be at 2r.l above the observation
c                  depth (along 1ry direction).
c       cf: output. correction factor.
c           cf*rho(s,r) gives normalized lateral distribution
c           for particles giving de>0 in scinti.
c           rho is the output from klee.
      dimension rat(35, 11)
      dimension dty1(35), dty2(35), dty3(35), dty4(35), dty5(35)
      dimension dty6(35), dty7(35), dty8(35), dty9(35), dty10(35)
      dimension dty11(35)
      equivalence (rat(1,1), dty1(1))
      equivalence (rat(1,2), dty2(1))
      equivalence (rat(1,3), dty3(1))
      equivalence (rat(1,4), dty4(1))
      equivalence (rat(1,5), dty5(1))
      equivalence (rat(1,6), dty6(1))
      equivalence (rat(1,7), dty7(1))
      equivalence (rat(1,8), dty8(1))
      equivalence (rat(1,9), dty9(1))
      equivalence (rat(1,10), dty10(1))
      equivalence (rat(1,11), dty11(1))
c    gamma  fe.1sc3.5/lee s=.5
c       rho*/rho=cf:  log10(cf) for log10(r)=-3.815 to 1.6 step .160
c    s=0.5
      data (dty1  (i),i=   1,  35)/
     1 -0.114, -0.052, -0.003,  0.015,  0.040,  0.053,  0.060,  0.061,
     2  0.056,  0.056,  0.045,  0.028, -0.001, -0.043, -0.066, -0.077,
     3 -0.076, -0.076, -0.081, -0.074, -0.055, -0.024,  0.031,  0.092,
     4  0.183,  0.304,  0.461,  0.667,  0.818,  0.928,  0.995,  1.050,
     5  1.081,  1.088,  1.082/
c    s=0.6
      data (dty2  (i),i=   1,  35)/
     1 -0.138, -0.095, -0.070, -0.045, -0.014, -0.007,  0.000, -0.012,
     2 -0.011, -0.010, -0.015, -0.008, -0.026, -0.043, -0.066, -0.077,
     3 -0.083, -0.082, -0.087, -0.080, -0.067, -0.048, -0.018,  0.037,
     4  0.110,  0.178,  0.275,  0.420,  0.566,  0.729,  0.862,  0.923,
     5  0.942,  0.943,  0.908/
c    s=0.7
      data (dty3  (i),i=   1,  35)/
     1 -0.240, -0.179, -0.136, -0.105, -0.080, -0.055, -0.048, -0.048,
     2 -0.041, -0.040, -0.039, -0.038, -0.050, -0.055, -0.060, -0.071,
     3 -0.089, -0.100, -0.093, -0.086, -0.067, -0.055, -0.011,  0.049,
     4  0.123,  0.196,  0.299,  0.414,  0.559,  0.675,  0.742,  0.767,
     5  0.737,  0.672,  0.588/
c    s=0.8
      data (dty4  (i),i=   1,  35)/
     1 -0.336, -0.257, -0.202, -0.159, -0.122, -0.091, -0.079, -0.066,
     2 -0.047, -0.046, -0.039, -0.044, -0.050, -0.061, -0.060, -0.071,
     3 -0.089, -0.076, -0.093, -0.092, -0.073, -0.048, -0.023,  0.037,
     4  0.105,  0.184,  0.287,  0.402,  0.517,  0.608,  0.658,  0.628,
     5  0.563,  0.449,  0.347/
c    s=0.9
      data (dty5  (i),i=   1,  35)/
     1 -0.421, -0.330, -0.269, -0.214, -0.158, -0.121, -0.097, -0.072,
     2 -0.065, -0.058, -0.051, -0.056, -0.062, -0.079, -0.084, -0.089,
     3 -0.101, -0.082, -0.087, -0.086, -0.079, -0.054, -0.024,  0.019,
     4  0.074,  0.153,  0.245,  0.348,  0.469,  0.524,  0.489,  0.393,
     5  0.298,  0.208,  0.125/
c    sw=1.0
      data (dty6  (i),i=   1,  34)/
     1 -0.487, -0.402, -0.323, -0.262, -0.201, -0.164, -0.127, -0.108,
     2 -0.089, -0.070, -0.069, -0.063, -0.068, -0.067, -0.078, -0.089,
     3 -0.107, -0.105, -0.104, -0.085, -0.061, -0.036,  0.001,  0.056,
     4  0.117,  0.203,  0.312,  0.397,  0.464,  0.435,  0.351,  0.268,
     5  0.184,  0.125/
c    s=1.1
      data (dty7  (i),i=   1,  35)/
     1 -0.638, -0.540, -0.449, -0.364, -0.297, -0.236, -0.181, -0.138,
     2 -0.113, -0.094, -0.069, -0.069, -0.062, -0.055, -0.066, -0.095,
     3 -0.101, -0.100, -0.093, -0.080, -0.079, -0.061, -0.030,  0.001,
     4  0.050,  0.123,  0.184,  0.282,  0.367,  0.428,  0.392,  0.297,
     5  0.219,  0.154,  0.106/
c    s=1.2
      data (dty8 (i),i=   1,  35)/
     1 -0.740, -0.631, -0.516, -0.424, -0.339, -0.266, -0.211, -0.162,
     2 -0.125, -0.094, -0.075, -0.062, -0.068, -0.073, -0.078, -0.089,
     3 -0.101, -0.112, -0.111, -0.098, -0.085, -0.061, -0.030,  0.007,
     4  0.050,  0.117,  0.178,  0.240,  0.337,  0.380,  0.362,  0.297,
     5  0.219,  0.154,  0.076/
c    s=1.3
      data (dty9 (i),i=   1,  35)/
     1 -0.836, -0.685, -0.564, -0.460, -0.369, -0.302, -0.253, -0.192,
     2 -0.155, -0.118, -0.093, -0.069, -0.074, -0.067, -0.078, -0.095,
     3 -0.113, -0.118, -0.117, -0.122, -0.110, -0.091, -0.066, -0.035,
     4  0.002,  0.069,  0.142,  0.209,  0.294,  0.350,  0.326,  0.285,
     5  0.219,  0.148,  0.088/
c    s=1.4
      data (dty10 (i),i=   1,  35)/
     1 -0.897, -0.763, -0.624, -0.466, -0.339, -0.260, -0.205, -0.144,
     2 -0.107, -0.064, -0.057, -0.044, -0.062, -0.061, -0.072, -0.095,
     3 -0.113, -0.142, -0.153, -0.146, -0.134, -0.109, -0.084, -0.047,
     4 -0.004,  0.051,  0.130,  0.209,  0.252,  0.313,  0.320,  0.267,
     5  0.189,  0.100,  0.052/
c    s=1.5
      data (dty11 (i),i=   1,  35)/
     1 -0.993, -0.878, -0.732, -0.581, -0.442, -0.314, -0.211, -0.138,
     2 -0.083, -0.058, -0.063, -0.062, -0.062, -0.073, -0.084, -0.107,
     3 -0.125, -0.148, -0.165, -0.171, -0.164, -0.163, -0.138, -0.101,
     4 -0.052,  0.009,  0.094,  0.185,  0.258,  0.301,  0.290,  0.243,
     5  0.165,  0.088,  0.046/
c
c         effective s
       rs=1. - 1./(1. + exp(r-8.))
       si=s*( -0.0285 *log10(e0/100.)*rs + 1.)
       if(si .lt. .4) then
         si=.4
       elseif(si .gt. 1.6) then
         si=1.6
       endif
       if(r .lt. 1.e-4) then
          ri=1.e-4
       elseif(r .gt. 70.) then
          ri=70.
       else
          ri=r
       endif
       if(ri .gt. 8.) then
           c=-3.5*(cosz-1.) + 1.
           ri=(ri-8.)*c   + 8.
       endif
       ri=log10(ri)
c
       call
     * k4ptdi(rat, 35, 11, 35, -3.82, 0.5, .16, .1, ri, si,    ans)
       cf=10.**(ans)
       end
