c         test kadeb:
c      character ttl*70, capx*16, capy*16
c      capx='r'
c      capy='<de>(mev)'
c      open(13, file='c2s5001.#gd.data')
c      e=10000.
c      zob=750.
c      do 100 cosz=.95,.65, -.1
c          do 30 s=.45, 1.61, .2
c              write(ttl,'('' s='',f5.2,'' cosz='', f5.2)')
c    *         s, cosz
c              write(13) ttl
c              write(13) capx, capy
c              rr=1.
c              do 40 i=1, 35
c                  call kadeb(e0, zob, s, cosz, rr, avde)
c                  write(13) rr, avde
c                  rr=rr*10.**0.1
c  40          continue
c              write(13) 1.e50, 1.e50
c  30      continue
c 100  continue
c      end
c      *********************************************************
c      *
c      * kadeb: get average energy deposit
c      *       in scintillater
c      ***************************************************
c        scinti : 3.5 cm thick under  .1 cm fe + .5cm pb
c        this can be used for gamma and proton 1ry
c        for very low e0, future modification needed.
c
       subroutine kadeb(e0, zob, s, cosz,  rr, avde)
c        e0: input.  1ry energy of gamma in tev
c       zob: input.  observation depth (g/cm**2) (vetical)
c         s: input.  age of the shower
c      cosz: input.  cos of the zenith angle of the shower
c       rr: input.   distance from the core in m
c                    (perpendicular to the axis)
c     avde: output.  average energy deposit in mev
c
        dummy=e0
        if(rr .le. 0.) then
           rl=0.
        else
           rl=log10(rr)
        endif
        if(zob .lt. 700.) then
           if(cosz .gt. .9) then
               call kadeb1(s, rl, avde1)
               call kadeb2(s, rl, avde2)
               x=1.
           elseif(cosz .gt. .80) then
               call kadeb2(s, rl, avde1)
               call kadeb3(s, rl, avde2)
               x=0.9
           else
               call kadeb3(s, rl, avde1)
               call kadeb4(s, rl, avde2)
               x=0.8
           endif
        elseif(zob .lt. 900.) then
           if(cosz .gt. .9) then
               call kadeb5(s, rl, avde1)
               call kadeb6(s, rl, avde2)
               x=1.
           elseif(cosz .gt. .8) then
               call kadeb6(s, rl, avde1)
               call kadeb7(s, rl, avde2)
               x=.9
           else
               call kadeb7(s, rl, avde1)
               call kadeb8(s, rl, avde2)
               x=.8
           endif
        else
           if(cosz .gt. .9) then
               call kadeb9(s, rl, avde1)
               call kadeba(s, rl, avde2)
               x=1.
           elseif(cosz .gt. .8) then
               call kadeba(s, rl, avde1)
               call kadebb(s, rl, avde2)
               x=.9
           else
               call kadebb(s, rl, avde1)
               call kadebc(s, rl, avde2)
               x=.8
           endif
        endif
        avde=10.*(avde1-avde2) *(cosz-x ) + avde1
       end
