c         test kade:
c      character ttl*70, capx*16, capy*16
c      capx='r'
c      capy='<de>(mev)'
c      open(13, file='c2s5001.#gd.data')
c      e=10000.
c      zob=750.
c      do 100 cosz=.95,.65, -.1
c          do 30 s=.45, 1.61, .2
c              write(ttl,'('' s='',f5.2,'' cosz='', f5.2)')
c    *         s, cosz
c              write(13) ttl
c              write(13) capx, capy
c              rr=1.
c              do 40 i=1, 35
c                  call kade(e0, zob, s, cosz, rr, avde)
c                  write(13) rr, avde
c                  rr=rr*10.**0.1
c  40          continue
c              write(13) 1.e50, 1.e50
c  30      continue
c 100  continue
c      end
c      *********************************************************
c      *
c      * kade: get average energy deposit
c      *       in scintillater
c      ***************************************************
c        scinti : 3.5 cm thick under  .1 cm fe
c        this can be used for gamma and proton 1ry
c        for very low e0, future modification needed.
c
       subroutine kade(e0, zob, s, cosz,   rr, avde)
c        e0: input.  1ry energy of gamma in tev
c       zob: input.  observation depth (g/cm**2) (vetical)
c         s: input.  age of the shower
c      cosz: input.  cos of the zenith angle of the shower
c       rr: input.   distance from the core in m
c                    (perpendicular to the axis)
c     avde: output.  average energy deposit in mev
c
        dummy=e0
        if(rr .le. 0.) then
           rl=0.
        else
           rl=log10(rr)
        endif
        if(zob .lt. 700.) then
           if(cosz .gt. .9) then
               call kade1(s, rl, avde1)
               call kade2(s, rl, avde2)
               x=1.
           elseif(cosz .gt. .80) then
               call kade2(s, rl, avde1)
               call kade3(s, rl, avde2)
               x=0.9
           else
               call kade3(s, rl, avde1)
               call kade4(s, rl, avde2)
               x=0.8
           endif
        elseif(zob .lt. 900.) then
           if(cosz .gt. .9) then
               call kade5(s, rl, avde1)
               call kade6(s, rl, avde2)
               x=1.
           elseif(cosz .gt. .8) then
               call kade6(s, rl, avde1)
               call kade7(s, rl, avde2)
               x=.9
           else
               call kade7(s, rl, avde1)
               call kade8(s, rl, avde2)
               x=.8
           endif
        else
           if(cosz .gt. .9) then
               call kade9(s, rl, avde1)
               call kade10(s, rl, avde2)
               x=1.
           elseif(cosz .gt. .8) then
               call kade10(s, rl, avde1)
               call kade11(s, rl, avde2)
               x=.9
           else
               call kade11(s, rl, avde1)
               call kade12(s, rl, avde2)
               x=.8
           endif
        endif
        avde=10.*(avde1-avde2) *(cosz-x ) + avde1
       end
