c     -----------------------------------------------------------------
c     !                dstair, denair, hair,
c     !                shair,  zair,   szair,
c     -----------------------------------------------------------------
c     ****************************************************************
c     *                                                              *
c     * dstair:  gives distance between two atmospheric depths       *
c     * denair:  gives density of atmospher as a function of depth   *
c     *   hair:  gives height from see level //                      *
c     *  shair:  gives scale height at a given vertical depth        *
c     *   zair:  gives depth at a given height                       *
c     *  szair:  gives slant depth at given distance from a given    *
c     *          slant depth                                         *
c     *                                                              *
c     *          us standard atmosper is used                        *
c     *                                                              *
c     ************************ tested 82.06.18 ***********************
c     ***********zair, szair added and tested 82.07.02 ***************
c     modified by least square fit 86.07.05
c
c
c  /usage/     dist=dstair(cosz, z1, z2)
c              den=denair(z)
c              h=hair(z)
c              sh=shair(z)
c              zv=zair(h)
c              z=szair(cosz, z1, path)
c
c  -- input --
c   *dstair*
c      cosz:  cos of incident ptcl direction to the vertical line
c        z1:  upper atmospheric depth measured along incident direction
c        z2:  lower //
c
c   *denair*, *hair* and *shair*
c         z:  vertical atmospheric depth
c
c   *zair*
c         h:  vertical height in cm
c
c   *szair*
c      cosz:  same as in dstair
c        z1:  depth measured along incident direction
c      path:  distance from the depth z1 along the incident direction
c             (in cm)
c
c
c    *** note ***
c             depth is in unit of g/cm**2:  length is in cm
c
c  -- process --
c       dstair:  converts the depths given to vertical ones, and
c         computes vertical height defference which is in tern converted
c         to give distance along incident direction.
c
c       denair:
c          approximate formula is used to give density (in g/cm**3)
c          as a function of vertical depth.  it is made by fitting
c          'density at z' = '- dz/df(z)' wher height=f(z) for given z.
c
c         hair:
c          approximate formula for us atmosper are used.
c
c        shair:
c          given depth is divided by the density there
c
c         zair:
c          for h>11km, hair1 is solved to give z.  for h<=11km, hair2
c          is solved by polynomial of order 3 to give z.
c
c        szair:
c          slant depth z1 is converted to vertical one to give vertical
c          height.  path is converted to vertical one and the vertical
c          height at the path end is computed which in tern converted
c          to the vertical depth.  finally, vertical depth is converted
c          to the slant depth.
c
c  -- output --
c       these are function programs.
c
c          dist:  distance between 'z1' and 'z2' measured along 'cosz'
c                 direction.  unit is cm
c           den:  density of air at vertical depth z.  in g/cm**3
c             h:  vertical height at vertical depth z.  in cm
c            sh:  scale height to approximate the atmospher by
c                 z=z0 * exp(-h/sh) there.   in cm
c            zv:  vertical depth at vertical height h.  in g/cm**2
c             z:  slant depth at path end.   in g/cm**2
c
c
c
c                              =   =   =   =
c
                       function dstair(cosz, z1, z2)
c
      implicit real*8 (a-h, o-z)
      real*4  cosz, z1, z2, h, z, ztmp
c
c
c   below heigh1 and heigh2 are so made that they coincide at
c   z=230
c
c
c                 original function coeff.
c     data  ha/44.342e5/, hl/11.865e5/,  hm/0.19/
c     data hb/ 45.450e5 /,  hn/ 6.33e5 /
c
c      coef. to have continuous values for h=h(z) and its derivative
c        about z=z0
      parameter(  ha=4512224.7572830657d0, hb=4541933.9782793734d0,
     *     hl=1244541.6061892177d0, hm=.1854893358365053d0,
     *     hn=6.3300000000746224d5, z0=230.0000458235099d0,
     *     hmi=1.d0/hm, omhm=1.d0-hm,
     *     hlhmi=1.d0/hl/hm)
c        height at z0
      data hc/10.996296495761545d5/
c
c               for z<230
      heigh1(zz) = hb - log(zz) * hn
c               for  zz > z0 least square fit to ha-hl*zz**hm
c                                   by 4-th polynom.
c     heigh2(zz) = (((.11044e-5*zz - .38551e-2)*zz + 5.4354)*zz -
c    1                4565.3)*zz + .19051e7
      heigh2(zz)= ha - hl * zz**hm
c
c               density at zz>z0
c
c     rhoair( zz) = (-.16989e-9 * zz + .12857e-5 ) * zz + .78927e-4
      rhoair(zz)= zz**omhm*hlhmi
c
c                        h (vertical) ---> z (vertical)
c               for h>hc
      zair1(hh) = exp( (hb-hh)/hn)
c               for hh<hc
c     zair2(hh) = ( (-.107107e-15*hh + .564248e-9)*hh - .121961e-2)*hh
c    *             + 1031.40
c
      zair2(hh)= ((ha-hh)/hl)**hmi
c                               -   -   -
c
c
      zc=z2
      za=z1
      if(cosz .ne. 1.) then
c             convert to vertical depths
            zc=zc*cosz
            za=za*cosz
      endif
c
c
      if( zc .lt. z0 ) then
c              za < zc < z0       heigh1(za) - heigh1(zc) is:
            dstair = log(zc/za) * hn
      else
            if(za .gt. z0) then
c                      zc > za > z0
                 dstair = heigh2(za) -heigh2(zc)
            else
c                      za < z0 < zc
                 dstair =  heigh1(za) - heigh2(zc)
            endif
c
      endif
c
      if(cosz .ne. 1.) then
c            convert to dist along incident
          dstair = dstair/cosz
      endif
c
      return
c
c             give air density at z
c     ************
      entry denair(z)
c     ************
c
c
      za=z
      if(za .lt. z0) then
           dstair=  za/hn
      else
           dstair= rhoair(za)
      endif
      return
c
c             give hight for density at z
c     ************
      entry   hair(z)
c     ************
c
c
      za=z
      if(za .lt. z0) then
          dstair=heigh1(za)
      else
          dstair=heigh2(za)
      endif
      return
c
c             gives scale height at z
c     ************
      entry   shair(z)
c     ************
c
c
      za=z
      if(za .lt. z0) then
          dstair=  hn
      else
          dstair= za/ rhoair( za  )
      endif
      return
c
c             gives depth from height
c     ************
      entry    zair(h)
c     ************
c
c
      hr=h
      if(hr .gt. hc) then
          dstair=  zair1(hr)
      else
          dstair=  zair2(hr)
      endif
      return
c
c             gives slant depth at distance path (cm) from z1
c             (g/cm**2) along cosz (both path and z1).
c     ************
      entry   szair(cosz, z1, path)
c     ************
c
c
c        convert z1 to vertical one
      zv=z1*cosz
c        height at zv
      if( zv .lt. z0) then
          h1=heigh1(zv)
      else
          h1=heigh2(zv)
      endif
c        convert path to vertical
      pathv=path * cosz
c        height at path end
      h2= h1 - pathv
c        depth at h2
      if( h2 .gt. hc ) then
        ztmp=zair1(h2)
      else
        ztmp=zair2(h2)
      endif
c        convert ztmp to slant one
      dstair=ztmp/cosz
      return
      end
