#!/bin/bash
if [ $# -lt 2 ]; then
 cat << "EOF"
    Usage: ./ForManyMedia.sh dir list
  where 
     dir-- is a directory where the sampling table files are to
            be stored.
            dir/param_0.1-0.05/ etc will be created and 
            the table is stored there.
     list-- is a list of  media names in $EPICSTOP/Data/BaseM/
      such as Pb PWO ...

    E.G  ./ForManyMedia.sh /tmp  W PWO BGO Air

    To specify all the  media in  $EPICSTOP/Data/BaseM/,
      ./ForManyMedia.sh /tmp  `(cd $EPICSTOP/Data/BaseM/; ls)`
     would work

   Data for  "param_0.1-0.05"  etc  is obtained by reading
   paramdata shown belwo:
    0.1 comes form the first term
    0.05 ffrom the 2nd term 
  All lines are proccesd  until blank line comes.
   paramdata would look line

0.1  0.05    f /
0.3  0.05    f /
0.6  0.05    f /
1.0  0.05    f /
1.5  0.05    f /
1.9  0.05    f /
                        <- blank line
EOF
exit
fi

dir=$1
shift
for n in `seq 1 20`;do
    dir2=`awk 'NF>0 && NR==L {print "param_"$1"-"$2}' L=$n paramdata`
    #   dir2 is now like  param_0.7-0.05
    if [ x$dir2 == "x" ]; then
	break
    else
	awk 'NF>0 && NR==L {print $1, $2, $3}' L=$n paramdata > Opfile$$
	##
	
	echo Opfile$$
	
	# now  file pfile$$ contains "0.7 0.05 f"
	
	mkdir -p $dir/$dir2

	echo  ' dir is ' $dir
	echo  ' dir2 is ' $dir2	
	echo  ' directory is '  $dir/$dir2
	
	for f in $*; do
	    cp Opfile$$ pfile$$
	    echo $f >> pfile$$
	    echo ' media is ' $f
            echo '>>>> cat pfile'
	    cat pfile$$
	    echo '>>>> cat pfile'
	    # now 2nd line of pfile$$ is, e.g,  PWO
	    
	    ./mkSampMCStab0.sh  pfile$$  $dir/$dir2/$f 
	done
    fi    
done
rm -f Opfile$$
rm -f pfile$$


