      subroutine epGetEffZA(media)
      implicit none
#include  "Zglobalc.h"
#include  "ZbasicCnst.h"
#include  "Zmedia.h"

       type(epmedia):: media  ! input.  should contain basic media info. 
                           ! output. other info is computed here.

      integer i, nc, j
      real*8 sum, Lrad, Lradp, f, cs
!
!     &&&&&&&&&&&&&&&&&&&&&&&&&&         
!       some trial to get Zeff so that it (as a sigle virtual atom)
!       gives the same r.l obtained for complex material.
!       This gives almost the same Zeff as obtained in this prog.
!       (normally within 1 %).
!&      record /media/mediax
!&      common /Zmedia/ mediax
!&      real*8 newz
!&      integer icon
!&      real*8 epsolverl
!&      external epsolverl
!     &&&&&&&&&&&&&&&&&&&&&&&&&&&

      nc = media%noOfElem
      sum = 0.
      do i = 1, nc
         sum = sum + media%No(i)
         media%OrigNo(i) = media%No(i)
      enddo
      media%sumNo = sum
! &&&&&&&&&& from  v7.0 we use normalized No(i).  and this leads to  the 
!      change of the  cross-section (in mb) (new one  is  old one / sum(old No)).
!      and also change of mbto* constant.  However, there is no change
!      in the sampling table and actual simulations.
!
      do i = 1, nc
         media%No(i) = media%No(i)/sum
      enddo
      sum = 0.
      media%A = 0.
      media%Z = 0.
      media%Z2 = 0.
      media%ZZ1 = 0.
      media%MoliereExpb = 0.
      media%Z1_3rd =0.
      media%Z2_3rd =0.

      do i = 1, nc
         media%A = media%A + media%No(i)* media%elem(i)%A
         media%Z = media%Z + media%No(i)* media%elem(i)%Z
         media%Z2 = media%Z2 + media%No(i)* media%elem(i)%Z**2
         media%ZZ1 = media%ZZ1 + 
     *     media%No(i)* media%elem(i)%Z*(media%elem(i)%Z + 1.)
!            for beta=1 and z=1; Moliere's  exp(b) = MoliereExb*t
         media%MoliereExpb = media%MoliereExpb +
     *       media%No(i)*media%elem(i)%Z**0.333333 *
     *        (media%elem(i)%Z+1.d0)/
     *              (1.0d0 + 3.327d0*(media%elem(i)%Z/137.d0)**2)
         media%Z1_3rd =  media%Z1_3rd 
     *          +  media%No(i)* media%elem(i)%Z**(1./3.)
         media%Z2_3rd =  media%Z2_3rd 
     *          +  media%No(i)* media%elem(i)%Z**(2./3.)
      enddo
!                only for e+/e- 
      media%MoliereForXc2 =0.6011 * media%ZZ1/media%A

      media%MoliereExpb = 6702. * media%MoliereExpb/media%A
!        we simply deinfe  Z^(2/3) by <Z>^(2/3) (not <Z^2/3>
!        also  Z^(1/3)
!      media.Z1_3rd = media.Z**(1./3.)
!      media.Z2_3rd = media.Z**(2./3.)

      do i = 1, nc
         media%w(i) = media%No(i)* media%elem(i)%A/media%A
         media%npercm3(i) =N0/media%elem(i)%A *media%w(i)*media%rho
      enddo

      sum = 0.
!
!         Since many of cross-sections depend primarily on
!         Z**2/A, we take effective Z**2/A first and  
!         multiply it by Aeff to get effective Z**2 and
!         further get effective Z by sqrt(Zeff**2)
!         For the cross-sections which depend on Z/A,
!         we use effective Z/A directly.
      sum = 0.
      do i =1, nc
         sum = sum + media%w(i)*media%elem(i)%A
      enddo
      media%Aeff = sum    ! not to be used alone

!         get effective Z**2/A
      sum = 0
      do i = 1, nc
         sum = sum + media%w(i)*media%elem(i)%Z**2/
     *         media%elem(i)%A
      enddo
      media%Z2byAeff = sum   ! OK  = sum(niZi^2)/sum(niAi)

      media%Z2eff = media%Z2byAeff * media%Aeff  ! not to be used alone
      media%Zeff = sqrt(media%Z2eff)         ! not to be used  

!  &&&&&&&&&&&&&&&
!      write(*,*) ' meida.No', ( media.No(i), i=1,nc )
!      write(*,*) ' meida.w ', ( media.w(i), i=1,nc )
!      write(*,*) ' A,Z, Aeff, Zeff=', media.A, media.Z, media.Aeff,
!     *   media.Zeff
! &&&&&&&&&&&&&&&&
      media%LogZ = log(media%Zeff)  ! not used anywhere
      media%Zeff3 = media%Zeff**(1.d0/3.d0)   ! not to be used

      sum = 0.
      do i = 1,nc
         sum  =  sum +
     *             media%w(i)*media%elem(i)%Z/media%elem(i)%A
      enddo
!         =  sum(niZi)/sum(niAi)  OK
      if( media%format .eq. 2 .and. media%ZbyAeff .ne. -100.) then
         if(abs(sum-media%ZbyAeff)/media%ZbyAeff .gt. 0.01 ) then
            write(0,*) "weighted <Z/A> inp=",media%ZbyAeff,
     *      " computed inside =", sum
            write(0,*) "former will be used"
         endif
      else
         media%ZbyAeff = sum
      endif
!            for photo electric effect
      sum = 0.
      do i = 1, nc
         sum = sum + 
     *        media%w(i)*media%elem(i)%Z**5/media%elem(i)%A
      enddo
      media%Z5byAeff = sum   ! ok


!         compute radiation length X0g(g/cm2) and  X0 (cm)
      call epX0(media)
!         g/cm^2 to cm
      media%gtocm = media%X0/media%X0g

!           this may be used when summing each
!           element contribution
      media%mbtoPgrm = 1.d-27 *N0/media%A
      media%mbtoPcm =  media%mbtoPgrm * media%rho
      media%mbtoPX0 =  media%mbtoPgrm *media%X0g

!         <Z/A> must be used explicitly for crosssections with Z
      media%basearea = pir02 * media%ZbyAeff * N0*1.d-27 * media%X0g
!
!           this may be used when we approximate
!      a compound or molecule as one element
!        wrong: ! not used anywhere
!
      media%mbtoPgrm2 = 1.d-27*N0/media%Aeff   
      media%mbtoPcm2 =  media%mbtoPgrm2 * media%rho
      media%mbtoPX02 =  media%mbtoPgrm2 * media%X0g
!  &&&&&&&&&&&&&&&&&&&&&&&&
!        get Zeff for compound/molecule so that Zeff and Aeff as a
!        single atom gives  the same X0 as above.
!&      mediax = media
!&      write(*,*) ' X0=', media.X0, ' X0g=',media.X0g
!&      write(*,*) ' Zeff=',media.Zeff, ' Aeff=',media.Aeff
!&      call kbchop(epsolverl, 1.d0,  140.d0, 0.001d0, newz, icon)
!&       write(*,*) ' newz=',newz
!  &&&&&&&&&&&&&&&&&&&&&&&
!       ------------LPM -----------;
!        these are not atom base. but media base.
!      media.s1 = (media.Zeff**(1.d0/3.d0)/183.0d0)**2
      media%s1 = (media%Z1_3rd/183.0d0)**2
      media%logs1 = log(media%s1)
!       -----------complete screening cross-sec. coeff.

!        const used in the complete screening cross-sec.
!      f(y)dy ~dy (4/3(1-y)/y + y)C1 + (1-y)/y C2
!
      media%cScrC1 = 0.
      media%cScrC2 = 0.
!

      do i = 1, media%noOfElem
         call epGetLrad(media%elem(i)%Z, Lrad, Lradp, f)
         media%cScrC1 =  media%cScrC1  + 
     *     ( media%elem(i)%Z**2 *(Lrad-f) +
     *            media%elem(i)%Z*Lradp) * media%No(i)
         media%cScrC2 = media%cScrC2  + 
     *      (media%elem(i)%Z**2  + media%elem(i)%Z)/9.d0
     *       * media%No(i)
      enddo
!       f(y) ~ (4/3C1+ C2)(1-y)/y + yC1; main term
      media%cScrMain = 4.*media%cScrC1/3.d0 + media%cScrC2
!          plasma energy in GeV
      media%wp = 28.816d-9 *sqrt(media%rho*media%Z/media%A)
!        no. of ingredient /cm^3
      media%nd = media%rho*N0/media%A
!
!           make cross-section table: for 10 mb to 100 mb
!
      media%ndensity = 1.d-27*media%rho*N0/media%A
      end
!   &&&&&&&&&&&&&&&&&&&&&&&&&
!&      real*8 function epsolverl(z)
!&      implicit none
!&#include  "Zmedia.h"
!&       real*8 z
!&       record /epmedia/ mediax
!&       common /Zmedia/ mediax
!&
!&       real*8 x0g
!&       call epX01(z, mediax.Aeff, x0g)
!&
!&       epsolverl = x0g/mediax.X0g -1.d0
!&       end
!  &&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&

       
