      subroutine epPrLSampP(xmedia, Eg, prob)
      implicit none
!     #include "Zmedia.h"
#include "ZepTrackv.h"
      type(epmedia):: xmedia
      logical,save::first(Maxmedia)=.true.
      real*8 Eg
      real*8 prob  ! output probability of Pair / X0
!     real*8,allocatable::logtbl(mxPrTXL,:) ! log table  not used now  2018/Dec/7
      real*8,allocatable::logtbl(:,:) ! log table 
      real*8 ale
      integer i
      save  logtbl
      logical,save::onlyonce=.true.

      if( onlyonce ) then
         allocate( logtbl(mxPrTXL, NoOfMedia)) ! log table
         onlyonce =.false.
      endif
      if( first(MediaNo))  then
!          take log of the total crross-section
         do i = 1, xmedia%cnst%PairTXTL
            logtbl(i,MediaNo)=log( xmedia%tbl%PrTXL(i) )
         enddo
         first(MediaNo) = .false.
      endif
      
      if(Eg .lt. xmedia%cnst%PairEgmin) then
         prob= 1.d-40
      else
         ale=log10(Eg)
!     without using log table, accuracy is OK.
!     but for very small Eg, prob < 10^-8 and sometimes it becomes
!     ~  -10^-4 and leads to boundary error. This error can be
!     aovided with ElowerBndPair = 1.2 MeV in epics file.
!     This version is bit slower than the no-log version by few % or so
!     but can be used ElowerBndPair = 1.022 MeV . if this is 1.2MeV
!     the value becomes ~2% (fluctutaion is large, even 1000 events
!     so this %tage is not sure). 
!     !     call kintp3(logtbl,   call kintp3(media.tbl.PrTXL,
!     call kintp3(logtbl,   call kintp3(media.tbl.PrTXL,
         call kintp3(logtbl(1,MediaNo),
!         call kintp3( media%tbl%PrTXL,
     *      1, xmedia%cnst%PairTXTL, xmedia%cnst%PairLEgmin,
     *      xmedia%cnst%PairdETXL, ale, prob) 
         prob = exp(prob)
!!!!!!!!
!         write(*,*) '#test ', MediaNo, Eg, prob
!!!!!!!!!!
      endif
      end
!     ************
      subroutine epPrLSampE(media, Eg, Ee)
!     ************
!          samples higher energy pair electron
      implicit none
#include "Zmedia.h"
       type(epmedia):: media
      real*8 Ee,  Eg

      real*8 u, ale, us, ans, ex

      call rndc(u)
      ale = log10(Eg)
      if(u .gt. media%cnst%PairUminLA) then
!          region A
         call k4ptdi(media%tbl%PrSTLA, 
     *        media%cnst%PairUszLA, 
     *        media%cnst%PairEsize,
     *        media%cnst%PairUszLA, 
     *        media%cnst%PairUminLA,
     *        media%cnst%PairLEgmin,
     *        media%cnst%PairdULA,
     *        media%cnst%PairdELA, u,  ale,  ans)  
         Ee = (ans*(1.-u) + 0.5d0)*Eg
      else
!         region B
         us = u**0.25d0
         ex = sqrt(ale - media%cnst%PairLEgmin)
         
         call k4ptdi(media%tbl%PrSTLB, 
     *        media%cnst%PairUszLB, 
     *        media%cnst%PairEsize,
     *        media%cnst%PairUszLB, 
     *        0.d0,
     *        0.d0,
     *        media%cnst%PairdULB,
     *        media%cnst%PairdELB, us,  ex,  ans)  
         Ee = ans* Eg
      endif
      end

