      real*8 function epmuBrem(E, v)
      implicit none

         real*8  Z          !  Z
         real*8  A          !  A
         real*8  A3         !  A**(1/3)
         real*8  Z2         !  Z^2
         real*8  Zp2        !  Z(Z+1.2)
         real*8  D          !  alpha*(2r0Me/Mmu)**2
         real*8  LogZ, Z3   !  ln(Z), Z^(1/3)
         real*8  Shadow     !  shadowing factor A**(-0.1)
         real*8  PointLike  !  fraction of point like interaction 
         real*8  Ak         !  log factor 189 (or 191 by Rozental)
         real*8  Akm        !  Ak * MubyMe/Z3
         real*8  Akm2       !  Ak * sqrt(e)
         real*8  Gzai       !  gzai factor. longitudinally / transvers
                            !         polarized meson absorption XS.
                            !  
!


         common /zmucom/
     *   Z, A, Z2, Zp2, D, LogZ, Z3, Shadow,
     *   PointLike, Ak, Akm, Akm2, A3, Gzai


!               mass (GeV)

       real*8
     1  masele, maspic, maspi0, maskc, mask0, masd,
     2  masmu, masp,  masn,  masrho, masomg, masphi,
     3  maseta, masddb, masnnb, wrho,  womega, wphai,
     4  massigmap, massigma0, massigmam, masgzai0, 
     5  masgzaim, maslambda, maslambdac, masbomega
       
       parameter (
     1  masele=0.511d-3, maspic=139.5685d-3, maspi0=134.9642d-3,
     2  maskc=493.646d-3, mask0=497.671d-3, masd=1869.d-3,
     3  masmu=105.659d-3, masp=0.93827231,  masn=0.93956563,
     4  masrho=768.d-3, masomg=782.d-3, masphi=1019.4d-3,
     5  maseta=548.8d-3, masddb=2*masd, masnnb=2*masp,
     6  wrho = 150.e-3, womega = 8.4e-3, wphai = 4.4e-3  )
       parameter(
     1 massigmap = 1.189, massigma0 = 1.192, massigmam=1.197,
     2 masgzai0 = 1.314, masgzaim = 1.321, 
     3 maslambda = 1.115, maslambdac = 2.282, masbomega=1.672)
!        masddb and masnnb are the minimum value.

      real*8 E ! input. muon total  energy in GeV.
      real*8 v ! input. emitted fractional photon energy (Eg/E).
!
!      function values,( v dsigma/dv ) in mb.
!
!         compute v* dsigma(E,v)/dv in mb/target atom (single atom of
!         (Z,A)  ) of muon bremsstrahlung cross-section. (Z,A) must
!         have been given  by epmuSetCnst and  be usable thru
!         common /zmucom/
      real*8 epmuBremLogf
!
!       Differential muon brem x-section. 
!          

      epmuBrem = D* (4.*(1.-v)/3.d0 + v**2) *
     *     epmuBremLogf(E, v)  ! mb

      end
!     *******************
      real*8 function epmuBremLogf(E, v)
!     *******************
      implicit none

         real*8  Z          !  Z
         real*8  A          !  A
         real*8  A3         !  A**(1/3)
         real*8  Z2         !  Z^2
         real*8  Zp2        !  Z(Z+1.2)
         real*8  D          !  alpha*(2r0Me/Mmu)**2
         real*8  LogZ, Z3   !  ln(Z), Z^(1/3)
         real*8  Shadow     !  shadowing factor A**(-0.1)
         real*8  PointLike  !  fraction of point like interaction 
         real*8  Ak         !  log factor 189 (or 191 by Rozental)
         real*8  Akm        !  Ak * MubyMe/Z3
         real*8  Akm2       !  Ak * sqrt(e)
         real*8  Gzai       !  gzai factor. longitudinally / transvers
                            !         polarized meson absorption XS.
                            !  
!


         common /zmucom/
     *   Z, A, Z2, Zp2, D, LogZ, Z3, Shadow,
     *   PointLike, Ak, Akm, Akm2, A3, Gzai


!               mass (GeV)

       real*8
     1  masele, maspic, maspi0, maskc, mask0, masd,
     2  masmu, masp,  masn,  masrho, masomg, masphi,
     3  maseta, masddb, masnnb, wrho,  womega, wphai,
     4  massigmap, massigma0, massigmam, masgzai0, 
     5  masgzaim, maslambda, maslambdac, masbomega
       
       parameter (
     1  masele=0.511d-3, maspic=139.5685d-3, maspi0=134.9642d-3,
     2  maskc=493.646d-3, mask0=497.671d-3, masd=1869.d-3,
     3  masmu=105.659d-3, masp=0.93827231,  masn=0.93956563,
     4  masrho=768.d-3, masomg=782.d-3, masphi=1019.4d-3,
     5  maseta=548.8d-3, masddb=2*masd, masnnb=2*masp,
     6  wrho = 150.e-3, womega = 8.4e-3, wphai = 4.4e-3  )
       parameter(
     1 massigmap = 1.189, massigma0 = 1.192, massigmam=1.197,
     2 masgzai0 = 1.314, masgzaim = 1.321, 
     3 maslambda = 1.115, maslambdac = 2.282, masbomega=1.672)
!        masddb and masnnb are the minimum value.

      real*8 E  ! input. muon total energy. in  GeV
      real*8 v  ! input fraction ; Eg/E

      real*8 MubyMe
      parameter (MubyMe = masmu/masele)

!
      real*8  delta, logf
!             
!         mim. momentum transfer in unit of Mmu
      delta = (masmu/E) * v /(1.d0-v)/2  


      logf =   Akm / (1.d0 + Akm2*delta)
      if(Z .gt.  10.) then
!            this correction not exist in Rosental
         logf = logf * 2./3.d0 /Z3
      endif
      epmuBremLogf = log(logf)
      end






