!     *******************************
      function epPair(Zin, Egme, x) result(ans)
      use BPPS
      implicit none
#include "Zglobalc.h"
#include "ZbasicCnst.h"
!          compute differentical pair creation cross-section
!          at low energies where no LPM effect exists.

!        epPair = dsigma/dx in mb
!
      real(8),intent(in):: Zin    ! charge of target
      real(8),intent(in):: Egme ! input  Eg/me
      real(8),intent(in):: x    ! input  Ee/Eg.   me/Eg =< x <= 1.-me/Eg
      real(8):: ans

      real*8 phi1, phi2, psi1, psi2
      real(8):: gamma, epsil
      real*8 epPairLowE

      call epBPZpart(Zin)
      delta = 1./(2*x*(1.-x))/Egme
      gamma = 200.*delta/Z13
      epsil = 200.*delta/Z23
      
         call epBPfc(gamma, epsil,  phi1, phi2, psi1, psi2)
         ans = max(  ( (4.d0/3.d0  *(x -1.)*x + 1) *
     *        (Z**2*(phi1-4*cf) + Z*psi1)
     *        - 2.d0/3.d0 *x *(1-x)* 
     *        (Z**2* (phi1-phi2) + Z*(psi1 -psi2)) ), 0.d0)
!             alpha *r0**2 epPair = 0,579 epPair
         ans = ans * ar02       !  in mb
      end function epPair
