      implicit none
#include "Zmedia.h"
#include "Zmass.h"
c
c          test Bhabha scattering cross-section
c     At fixed e+ energy, see the cross-section
c     change as a function of cut off recoil electron
c     energy.
c 
      record /epmedia/media
      integer i, io, icon
      real*8 Ee, prob,  w, path, v, vm
      real*8 xm ,   g
      character*80 file
      real*8  epbhabhatx,  tx, txg, t0, beta2

      io = 10
      
      call  cerrorMsg(
     * "Enter  e+ energy(1. GeV),"//
     * " minimum cutoff  recoil energy(200d-6 GeV)"//  
     * " and file path('../../Data/Media/BGO')", 1)
      Ee = 1.
      w = 200.0d-6
      file = '../../Data/Media/BGO'
      
      read(*, *)  Ee, w, file
      call cerrorMsg(file,  1)

      call copenf(io, file, icon)
      call epReadTab(io, media)
      close(io)
      call epGetEffZA(media)
      call epStern(w, media)
      g = Ee/masele
      t0 = Ee-masele
      beta2 = 1.-1/g/g
      do while ( (Ee-masele) .gt. w )
         vm =  w/t0
         call epbhabhap(media, Ee, w,  prob, path)
         tx = epbhabhatx(g, vm)
         txg = tx * masele/t0/beta2 * media.basearea*2.0
         write(*,'(1p,4g12.4)')  w, prob, tx, txg
         w = w *10.**0.01
      enddo
      end
