#include "ZsaveStruc.h"
c           ****************************************************
c
c         set the form parameter by seeing the configuration
c    form='box', 
c         xxxxx 'cyl','pipe', 'mix' will be set. xxxx
c         'box' may be set only if all components are box 
c               and all edges are parallel and have the  same
c               size in x, y. 
c     For other cases, 'mix' is set.
c         
c     If form != 'mix', faster execution will be possible.
c
        subroutine epsetform
       implicit none
#include  "Zep3Vec.h"
#include  "Zcnfig.h"
c     
        integer i

        do i = 1, Det.nct
           if(Det.cmp(i).NMatreska .gt. 0) then
              form = 'mix'
              goto 10
           endif
        enddo
        call epcbox
 10     continue
        end
        subroutine epcbox
       implicit none
#include  "Zep3Vec.h"
#include  "Zcnfig.h"
#include  "ZepPos.h"

        character*(*) formx

        character*(*) wstruc

        integer nw
        record /epPos/ org, attr
c
        integer i
        real*8 ref

        
        ref = Det.cmp(1).orgx
        do i = 1, Det.nct
           if(Det.cmp(i).struc(1:3) .ne. 'box') goto 10
           if(Det.cmp(i).orgx .ne. ref) goto 10
        enddo
        ref = Det.cmp(1).orgy
        do i = 2, Det.nct
           if(Det.cmp(i).orgy .ne. ref) goto 10
        enddo
        ref = Volat( Det.cmp(1).vol+boxa)
        do i = 2, Det.nct
           if(Volat( Det.cmp(i).vol+boxa ) .ne. ref) goto 10
        enddo
        ref = Volat( Det.cmp(1).vol+boxb )
        do i = 2, Det.nct
           if(Volat( Det.cmp(i).vol+boxb ) .ne. ref) goto 10
        enddo
        form = 'box'
        return         ! *************
 10     continue
        form = 'mix'
        return
c       *****************
        entry epqfrm(formx)
c           inquire form
            formx=form
            return

c       *****************
        entry  epqworld(nw, wstruc)
        nw = Det.nworld
        wstruc = Det.cmp(Det.nct).struc
        return

c       ***********************
        entry epqwcoord(org, attr)
c          returns world origin and attribute
        org.x = Det.cmp(Det.nct).orgx
        org.y = Det.cmp(Det.nct).orgy
        org.z = Det.cmp(Det.nct).orgz
        if(Det.cmp(Det.nct).struc .eq.'box_w') then
c(((((((((((
           attr.x =Volat(Det.cmp(Det.nct).vol+boxa )
           attr.y =Volat(Det.cmp(Det.nct).vol+boxb )
           attr.z =Volat(Det.cmp(Det.nct).vol+boxc )
c))))))))
        elseif( Det.cmp(Det.nct).struc == 'sphere_w') then
c((((((
           attr.x = Volat( Det.cmp(Det.nct).vol+sphr )
c))))))
        elseif( Det.cmp(Det.nct).struc == 'cyl_w' .or.
     *    Det.cmp(Det.nct).struc == 'cyl_y_w' .or.
     *    Det.cmp(Det.nct).struc == 'cyl_x_w' .or.
     *    Det.cmp(Det.nct).struc == 'cyl_z_w' ) then
           attr.x = Volat(Det.cmp(Det.nct).vol+cylr)
           attr.y = Volat(Det.cmp(Det.nct).vol+cylh)
        else
           write(0,*) ' world struc=', Det.cmp(Det.nct).struc 
           write(0,*) ' strange '
           stop
        endif
        end
c     *************
      subroutine epqenvlper(i, org, abc)
c       inqure the enveloper of a given comp.
c       in world  coordinate
      implicit none
#include "Zep3Vec.h"
#include "Zcnfig.h"
#include "ZepPos.h"

      integer i  ! input. component number 

      record /epPos/  org  ! output. world orgin of a box. which
                           !    envelops  the i-th comp.
                           !  
      record /ep3Vec/ abc  ! output. box a, b, c

      call epqenvlper0(i, org, abc)
      call epqenvlper1(i, org, abc)
      end      subroutine epqenvlper
c     *************
      subroutine epqenvlper0(i, org, abc)
c       inqure the enveloper of a given comp.
c       local coord.
      implicit none
#include "Zep3Vec.h"
#include "Zcnfig.h"
#include "ZepPos.h"

      integer i  ! input. component number 

      record /epPos/  org  ! output. local  orign of a box. which
                           !    envelops  the i-th comp.
                           !  
      record /ep3Vec/ abc  ! output. box a, b, c


      character*80 msg
      character(len=MAX_STRUCCHR)::  epparaphrase, tempph
      character(len=MAX_STRUCCHR)::  basename


      integer::uscl

      if(i .le. 0 .or. i .gt.  Det.nct) then
         write(msg, *) ' inquired comp. #=', i, 
     *     ' not exists: epqenvlper'
         call cerrorMsg(msg, 0)
      endif
      call epGetBaseStrucName(Det.cmp(i).struc, basename)
      if(basename .eq. 'box') then
         call epenvlpBox(Det.cmp(i), org, abc)

      elseif(basename .eq. 'cyl') then
         call epenvlpCyl(Det.cmp(i), org, abc)

      elseif(basename .eq. 'pipe') then
         call epenvlpPipe(Det.cmp(i), org, abc)

      elseif( basename .eq. 'prism' ) then
         call epenvlpPrism(Det.cmp(i), org, abc)
      elseif( basename  .eq. 'sphere') then
         call epenvlpSphere(Det.cmp(i), org, abc)
      else
         call epseeUnderScore(Det.cmp(i).struc, uscl)
         tempph = epparaphrase(Det.cmp(i).struc(1:uscl))
         if(tempph(1:4) .eq. 'new-') then
            call epenvlpNew(Det.cmp(i), org, abc)
         else
            write(msg,*)
     *      'struc=', Det.cmp(i).struc,
     *      ' not supported: epqenvlper0. '
            call cerrorMsg(msg,0)
         endif
      endif

      end subroutine epqenvlper0

      subroutine epqenvlper1(i, org, abc)
c       convert output from epqenvloper0. 
c       in world  coordinate
      implicit none
#include "Zep3Vec.h"
#include "Zcnfig.h"
#include "ZepPos.h"

      integer i  ! input. component number 

      record /epPos/  org  !in/output.  output from  eqpenvlper0.
                           !  world orgin of a box. which
                           !  envelops  the i-th comp.
                           !  
      record /ep3Vec/ abc  ! in/output.output from  eqpenvlper0.
                           !   box a, b, c

      record /epPos/ posw, maxp, orgt

      integer j, jmx
      real*8 dx(8), dy(8), dz(8)
      data dx/0., 1., 0., 1., 0., 1., 0., 1./
      data dy/0., 0., 1., 1., 0., 0., 1., 1./
      data dz/0., 0., 0., 0., 1., 1., 1., 1./
      if(NVTX .eq. 0) then
         jmx = 8
      else
         jmx = NVTX
      endif
      do j = 1, jmx
         if(NVTX .eq. 0) then
c             for all 8 corners of the box
c            posw.x = org.x + dx(j) * abc.x
c            posw.y = org.y + dy(j) * abc.y
c            posw.z = org.z + dz(j) * abc.z
            posw = epPos( org.x + dx(j) * abc.x,
     *                    org.y + dy(j) * abc.y,
     *                    org.z + dz(j) * abc.z)
         else
c            posw.x = org.x + VTXx(j) 
c            posw.y = org.y + VTXy(j) 
c            posw.z = org.z + VTXz(j)
            posw = epPos( org.x + VTXx(j), 
     *                    org.y + VTXy(j), 
     *                    org.z + VTXz(j) )
         endif
!            each vetex must be converted to world
!          to get the largest box
         call epl2w(i, posw, posw)
         if(j .eq. 1) then
            orgt = posw
            maxp = posw
         else
            orgt.x = min(orgt.x, posw.x)
            orgt.y = min(orgt.y, posw.y)
            orgt.z = min(orgt.z, posw.z)

            maxp.x = max(maxp.x, posw.x)
            maxp.y = max(maxp.y, posw.y)
            maxp.z = max(maxp.z, posw.z)
         endif
      enddo
      org = orgt
      abc.x = maxp.x -  org.x
      abc.y = maxp.y -  org.y
      abc.z = maxp.z -  org.z
      end  subroutine epqenvlper1

c     *************
      subroutine epenvlpAll
c          compute over all boundary of the system
c         in world  coordinate
      implicit none
#include "Zep3Vec.h"
#include "Zcnfig.h"
#include "ZepPos.h"


      record /epPos/  orgx
      record /ep3Vec/ abcx

      record /epPos/ Orgsave, org
      record /ep3Vec/Abcsave, abc
#ifdef USESAVE
      save   Orgsave, Abcsave
#endif
      integer i, imax

      Orgsave.x = 1.d10
      Orgsave.y = 1.d10
      Orgsave.z = 1.d10
      Abcsave.x = -Orgsave.x
      Abcsave.y = -Orgsave.y
      Abcsave.z = -Orgsave.z

      if( Det.nworld  .gt.  0 ) then
c          If the world has some attribute, it should be recognized
         if( Volat( Det.cmp(Det.nct).vol + 1) .eq. 0.) then
c              no attribute so ignore world size
            imax = Det.nct -1
         else
c              see world size
            imax = Det.nct
         endif
      else
         imax = Det.nct
      endif
c((((((((((
cc      do   i=1, Det.nct
c))))))))
      do   i=1, imax
c           ignore component which is partially contained by another volume.
         if(Det.cmp(i).NPContainer .eq. 0) then
c              i-th comp is not a partially contained one
            call epqenvlper(i, org, abc)
            call epLargerEnv(org, abc, Orgsave, Abcsave)
!                       here Abcsave is not yet edge length
!                    simeply max pos.
         endif
      enddo
ccccc  2002.02.09
!         Abc next is edge length 
      Abcsave.x = Abcsave.x - Orgsave.x
      Abcsave.y = Abcsave.y - Orgsave.y
      Abcsave.z = Abcsave.z - Orgsave.z
ccccc
      return
c     ************  inquire configuration
      entry epqcnf(orgx, abcx)
c     ******************
      orgx = Orgsave
      abcx = Abcsave
      end
c     **********************
      subroutine epLargerEnv(org, abc, orgx, maxpos)
c      suppose a virtual box's world origin be
c      'orgx' and it's largest (x,y,z) coordinate
c      is 'maxpos'. (maxpos = orgx + 3edge length)
c
c    This subroutine compares the box specified by org and abc
c    and returns a box which envelops both of them.
c    The new box is given by orgx and maxpos.
c
c
c       
      implicit none
#include "Zep3Vec.h"
#include "Zcnfig.h"
#include "ZepPos.h"


      record /epPos/  org     ! input. world origin of a box

      record /ep3Vec/ abc     ! input. abc of the box

      record /epPos/ orgx     ! input/output ; in world
                              !  coord. 
      record /epPos/ maxpos   ! input/output.; in world
                              !  coord.

      record /epPos/  posw

      integer i, imx
      real*8 dx(8), dy(8), dz(8)
      data dx/0., 1., 0., 1., 0., 1., 0., 1./
      data dy/0., 0., 1., 1., 0., 0., 1., 1./
      data dz/0., 0., 0., 0., 1., 1., 1., 1./

      if(NVTX .eq. 0) then
         imx = 8
      else
         imx = NVTX
      endif
      do i = 1, imx
         if(NVTX .eq. 0) then
c             for all 8 corners of the box
            posw.x = org.x + dx(i) * abc.x
            posw.y = org.y + dy(i) * abc.y
            posw.z = org.z + dz(i) * abc.z
         else
            posw.x = org.x + VTXx(i) 
            posw.y = org.y + VTXy(i) 
            posw.z = org.z + VTXz(i)
         endif
c             now posw is one of imx corners in world coord.
         orgx.x = min(orgx.x, posw.x)
         orgx.y = min(orgx.y, posw.y)
         orgx.z = min(orgx.z, posw.z)
c             get max pos in world coord.
         maxpos.x = max(maxpos.x, posw.x)
         maxpos.y = max(maxpos.y, posw.y)
         maxpos.z = max(maxpos.z, posw.z)
      enddo
            
      end
c     *******************************
      subroutine epenvlpBox(comp, org, abc)
      implicit none
#include "Zep3Vec.h"
#include "Zcnfig.h"
#include "ZepPos.h"


      record /Component/ comp
      record /epPos/ org
      record /ep3Vec/ abc

      org.x = 0.
      org.y = 0.
      org.z = 0.
c((((((((((
      abc.x = Volat( comp.vol+boxa )
      abc.y = Volat( comp.vol+boxb )
      abc.z = Volat( comp.vol+boxc )
c))))))))))
      NVTX = 0
      end

c     *******************************
      subroutine epenvlpCyl(comp, org, abc)
      implicit none
#include "Zep3Vec.h"
#include "Zcnfig.h"
#include "ZepPos.h"


      record /Component/ comp
      record /epPos/ org
      record /ep3Vec/ abc
      real(8):: temp
c((((((((((((
      org.x = -Volat( comp.vol+cylr )
      org.y = org.x
      org.z = 0.
      abc.x = Volat( comp.vol+ cylr )*2
      abc.y = abc.x
      abc.z = Volat( comp.vol+cylh )
c))))))))))
      NVTX = 0
      if(comp.struc(1:5) == "cyl_y") then
         call epc2v_cyl(comp, org, org)
!         temp = abc.y
c         abc = ep3Vec(abc.x, abc.z, temp)
!         abc = ep3Vec(temp, abc.z, abc.x)
         call epc2v_cyl(comp, abc, abc)
      elseif(comp.struc(1:5) == "cyl_x") then
         call epc2v_cyl(comp, org, org)
!         temp=abc.x
c         abc = ep3Vec(abc.z, abc.y, temp)
!         abc = ep3Vec(abc.z,  temp, abc.y)
         call epc2v_cyl(comp, abc, abc)
      endif

      end

c     *******************************
      subroutine epenvlpPipe(comp, org, abc)
      implicit none
#include "Zep3Vec.h"
#include "Zcnfig.h"
#include "ZepPos.h"



      record /Component/ comp
      record /epPos/ org
      record /ep3Vec/ abc

      real(8):: temp
c((((((((((
      org.x = -Volat( comp.vol+pipeor )
      org.y = org.x
      org.z = 0.
      abc.x = Volat( comp.vol+pipeor )*2
      abc.y = abc.x
      abc.z = Volat( comp.vol+ pipeh )
c))))))))))
      NVTX = 0


      if(comp.struc(1:6) == "pipe_y") then
         call epc2v_pipe(comp, org, org)
!         temp = abc.y
c         abc = ep3Vec(abc.x, abc.z, temp)
!         abc = ep3Vec(temp, abc.z, abc.x)
         call epc2v_pipe(comp, abc, abc)
      elseif(comp.struc(1:6) == "pipe_x") then
         call epc2v_pipe(comp, org, org)
!         temp=abc.x
c         abc = ep3Vec(abc.z, abc.y, temp)
!         abc = ep3Vec(abc.z, temp, abc.y)
         call epc2v_pipe(comp, abc, abc)
      endif
      end


c     *******************************
      subroutine epenvlpSphere(comp, org, abc)
      implicit none
#include "Zep3Vec.h"
#include "Zcnfig.h"
#include "ZepPos.h"


      record /Component/ comp
      record /epPos/ org
      record /ep3Vec/ abc
c(((((((((
      org.x = -Volat( comp.vol+sphr )
c)))))))))
      org.y = org.x
      org.z = org.x

      abc.x = Volat( comp.vol+sphr ) *2
      abc.y = abc.x
      abc.z = abc.x
      NVTX = 0
      end


