c            mubrem :   init
c            mubrmv :   sample fractional energy loss (>eps) for muon
c                       brems
c            mubrmt :   sample path for brems v>eps by muon
c            mubrmf :   fractional energy loss by v<eps of muon due to
c                       brem.  /(g/cm**2)
      subroutine mubrem(eps)
         common /$mubrm/ ieps, epsi
         integer iepsa(5)/100, 30, 20, 10, 1/
         if(abs(eps-0.01)/eps .lt. 1.e-2) then
             ieps=1
         elseif(abs(eps-.0333333)/eps .lt. 1.e-2) then
             ieps=2
         elseif(abs(eps-.05)/eps .lt. 1.e-2) then
             ieps=3
         elseif(abs(eps-.1)/eps .lt. 1.e-2) then
             ieps=4
         elseif(1.-eps .lt. 1.e-2) then
             ieps=5
         else
             write(*,*) ' eps=',eps, ' invalid for mubrem'
             stop
         endif
         epsi=1./iepsa(ieps)
         write(*,*) ' ----brems by muon: taken into account for',
     *              ' v > 1/',  iepsa(ieps), ' ---'
         write(*,*) '     lower energy brems is treated as a part of ',
     *               'continuous energy loss.'
      end
cc         test mubrmf.
c*include  mucset
cc
c      common /$mubrm/ ieps, epsi
c      integer ia(5)/100, 30, 20, 10, 1/
c      character txt*70, capx*16, capy*16
c      open(13, file='c2s5001.#gd.data')
c      capx='e/tev'
c      capy='f.e.l/(g/cm**2)'
c      call mucset(11., 22., .5, 5.5)
c      do 100 ieps=1, 5
c          write(txt,'('' eps=1/'',i3)') ia(ieps)
c          write(13) txt
c          write(13) capx, capy
c          do 50 j=1, 1000
c              e=1.e-3* 10.**( (j-1)/20.)
c              if(e .gt. 1000.) goto 55
c              call mubrmf(e, fe)
c              write(13) e, fe
c  50      continue
c  55      continue
c          write(13) 1.e50, 1.e50
c 100  continue
c      end
c      *********  mubrmf ************
c     **     'b' term for muon brems. in unit of  /(g/cm**2)
c          fractional energy loss by brems (gamma of e from 0 to eps)
c
        subroutine mubrmf(ein, dedtbe)
c
c   ein:input.  energy of muon in tev
c   dedtbe: output.  energy loss /(g/cm**2)/e
c         -de/dt/e=plsq(x) * d*10**-8 (/(g/cm**2), x=log10(e/tev)
       include  'Zmucom.f'
c
       common /$mubrm/ ieps, epsi
c
c         eps=1/100
c       xmin=   -3.101     xmax=    3.101
      plsq1(x)=(((-.1215645e-03*x+0.5062162e-03)*x-.4158942e-03)*x-.1576
     *411e-03)*x+0.1138237
c          eps=1/30
c       xmin=   -3.101     xmax=    3.101
      plsq2(x)=(((-.2540813e-03*x+0.2172424e-02)*x-.5341627e-02)*x+0.370
     *9454e-02)*x+0.3749865
c           eps=/20
c       xmin=   -3.101     xmax=    3.101
      plsq3(x)=(((-.2143098e-03*x+0.3318319e-02)*x-.1069509e-01)*x+0.934
     *2518e-02)*x+0.5572268
c           eps=1/10
c       xmin=   -3.101     xmax=    3.101
      plsq4(x)=(((0.2785670e-03*x+0.6248061e-02)*x-.3101801e-01)*x+0.355
     *4791e-01)*x+ 1.082490
c           eps=1
c       xmin=   -3.101     xmax=    3.101
      plsq5(x)=(((0.1263616e-01*x-.4852675e-02)*x-.3777847    )*x+ 1.235
     *238    )*x+ 7.396185
c
         e=min(ein, 1000.)
         x=log10(e)
         if(ieps .eq. 1) then
             dedtbe= plsq1(x)
         elseif(ieps .eq. 2) then
             dedtbe= plsq2(x)
         elseif(ieps .eq. 3) then
             dedtbe= plsq3(x)
         elseif(ieps .eq. 4) then
             dedtbe= plsq4(x)
         elseif(ieps .eq. 5) then
             dedtbe= plsq5(x)
         else
             write(*,*) ' ieps=',ieps,' undefined for mubrmf'
             stop
         endif
         dedtbe=dedtbe*d*1.e-8
      end
c
c
cc         test mubrmx.
c*include  mucset
cc
c      common /$mubrm/ ieps, epsi
c      integer ia(4)/100, 30, 20, 10/
c      character txt*70, capx*16, capy*16
c      open(13, file='c2s5001.#gd.data')
c      capx='e/tev'
c      capy='mfp(>eps)(g/cm2)'
c      call mucset(11., 22., .5, 5.5)
c      do 100 ieps=1, 4
c          write(txt,'('' eps=1/'',i3)') ia(ieps)
c          write(13) txt
c          write(13) capx, capy
c          do 50 j=1, 1000
c              e=1.e-2* 10.**( (j-1)/20.)
c              if(e .gt. 1000.) goto 55
c              call mubrmx(e, xs)
c              write(13) e, 1./xs
c  50      continue
c  55      continue
c          write(13) 1.e50, 1.e50
c 100  continue
c      end
       subroutine mubrmt(ein, t)
c         sample path for bremse (v>eps).
c         ein: energy (tev)
c           t: output.  sampled path in (g/cm*2)
c
           call mubrmx(ein, xs)
           call rndc(u)
           if(xs .gt. 0.) then
               t=-log(u)/xs
           else
               t=1.e37
           endif
       end
       subroutine mubrmx(ein, xs)
c        ein:input. muon energy in tev
c        xs:output. total xsection for v>eps in /(g/cm**2)
c
       include  'Zmucom.f'
c
       common /$mubrm/ ieps, epsi
c
c         x=log10(e)    xsec(v>eps)/d for muon brem.
c          eps= 0.01000
c       xmin=   -2.101     xmax=    3.076
      plsq1(x)=(((-.5465373e-02*x+0.2659310    )*x-1.483482    )*x+ 2.95
     *2485    )*x+ 43.51918
c         eps=1/30
c       xmin=   -2.101     xmax=    3.076
      plsq2(x)=(((0.1584842e-01*x+0.1546583    )*x-1.308292    )*x+ 2.85
     *8465    )*x+ 30.03764
c         eps=1/20
c       xmin=   -2.101     xmax=    3.076
      plsq3(x)=(((0.2289820e-01*x+0.1092777    )*x-1.209095    )*x+ 2.77
     *0861    )*x+ 25.61404
c          eps=1/10
c       xmin=   -2.101     xmax=    3.076
      plsq4(x)=(((0.3104880e-01*x+0.3437958e-01)*x-.9826320    )*x+ 2.50
     *6079    )*x+ 18.32747
c
         e=min(ein, 1000.)
         x=log10(e)
         if(x .lt. -3.) then
             xs=0.
         else
             if(ieps .eq. 1) then
                 xsbd= plsq1(x)
             elseif(ieps .eq. 2) then
                 xsbd= plsq2(x)
             elseif(ieps .eq. 3) then
                 xsbd= plsq3(x)
             elseif(ieps .eq. 4) then
                 xsbd= plsq4(x)
             elseif(ieps .eq. 5) then
c
             else
                 write(*,*) ' ieps=',ieps,' undefined for mubrmf'
                 stop
             endif
             if(ieps .ne. 5) then
                 xs=xsbd*d*1.e-8
             else
                 xs=0.
             endif
          endif
      end
cc         test mubrmv.
c*include  mucset
cc
c      common /$mubrm/ ieps, epsi
c      integer ia(4)/100, 30, 20, 10/
c      character txt*70, capx*16
c      open(13, file='c2s5001.#gd.data')
c      capx='v'
c      call mucset(11.,22., .5, 5.5)
c      do 100 ieps=1, 4
c          epsi=1./ia(ieps)
c          do 50 j=1, 1000
c              e=3.16e-2* 10.**( (j-1)/1.)
c              if(e .gt. 1000.) goto 55
c              if(j .eq. 1) then
c                write(txt,'('' eps=1/'',i3,'' e='',f8.4)') ia(ieps), e
c              else
c                write(txt,'('' e='',f8.4)') e
c              endif
c              write(13) txt
c              write(13) capx
c              do 30 k=1, 20000
c                  call mubrmv(e, v)
c                  write(13) v
c  30          continue
c              write(13) 1.e50
c  50      continue
c  55      continue
c 100  continue
c      end
       subroutine mubrmv(ein, v)
c       ein: input.   muon energy in tev
c         v: output.  sampled fractional energy loss of muon
c
c        sampling table of v for muon brem.  log10(e/tev)=-2 (.333) 2
c        v(iu, ie):  iu=1,41 (u=0 (.025) 1)
c                    ie=1,12 (log10(e/tev)=-2 (.333) 2 )
c        v1= v/eps**u
      parameter (iu=41, ie=12)
c
      dimension  vtbl(iu, ie, 4)
      dimension v1(iu*ie), v2(iu*ie), v3(iu*ie), v4(iu*ie)
c
      equivalence (v1(1), vtbl(1,1,1))
      equivalence (v2(1),   vtbl(1,1,2))
      equivalence (v3(1),   vtbl(1,1,3))
      equivalence (v4(1),   vtbl(1,1,4))
c
c          eps=1/100
c
      data (v1    (i),i=   1,  63)/
     1 1.00000, 0.71818, 0.62631, 0.56868, 0.52973, 0.50242, 0.48299,
     2 0.46921, 0.45968, 0.45346, 0.44993, 0.44864, 0.44927, 0.45158,
     3 0.45539, 0.46059, 0.46708, 0.47478, 0.48365, 0.49366, 0.50479,
     4 0.51703, 0.53038, 0.54485, 0.56047, 0.57725, 0.59521, 0.61441,
     5 0.63487, 0.65664, 0.67977, 0.70431, 0.73032, 0.75787, 0.78702,
     6 0.81785, 0.85043, 0.88484, 0.92118, 0.95953, 1.00000, 1.00000,
     7 0.77074, 0.67955, 0.61992, 0.57863, 0.54922, 0.52802, 0.51277,
     8 0.50203, 0.49481, 0.49045, 0.48845, 0.48848, 0.49028, 0.49364,
     9 0.49842, 0.50452, 0.51185, 0.52035, 0.52997, 0.54069, 0.55249/
      data (v1    (i),i=  64, 126)/
     1 0.56535, 0.57927, 0.59426, 0.61033, 0.62748, 0.64575, 0.66515,
     2 0.68571, 0.70747, 0.73046, 0.75471, 0.78028, 0.80719, 0.83551,
     3 0.86528, 0.89655, 0.92939, 0.96385, 1.00000, 1.00000, 0.81071,
     4 0.72399, 0.66491, 0.62300, 0.59270, 0.57062, 0.55460, 0.54320,
     5 0.53545, 0.53065, 0.52830, 0.52803, 0.52957, 0.53270, 0.53727,
     6 0.54316, 0.55027, 0.55852, 0.56787, 0.57827, 0.58968, 0.60209,
     7 0.61548, 0.62985, 0.64518, 0.66148, 0.67876, 0.69702, 0.71628,
     8 0.73655, 0.75785, 0.78021, 0.80363, 0.82815, 0.85380, 0.88060,
     9 0.90859, 0.93780, 0.96825, 1.00000, 1.00000, 0.84268, 0.76272/
      data (v1    (i),i= 127, 189)/
     1 0.70606, 0.66489, 0.63467, 0.61243, 0.59619, 0.58458, 0.57664,
     2 0.57168, 0.56919, 0.56881, 0.57023, 0.57325, 0.57770, 0.58343,
     3 0.59034, 0.59835, 0.60740, 0.61743, 0.62840, 0.64027, 0.65302,
     4 0.66664, 0.68110, 0.69640, 0.71254, 0.72950, 0.74729, 0.76591,
     5 0.78537, 0.80568, 0.82684, 0.84887, 0.87177, 0.89557, 0.92027,
     6 0.94590, 0.97247, 1.00000, 1.00000, 0.86930, 0.79741, 0.74452,
     7 0.70510, 0.67567, 0.65377, 0.63766, 0.62607, 0.61810, 0.61308,
     8 0.61051, 0.61001, 0.61130, 0.61414, 0.61837, 0.62383, 0.63042,
     9 0.63805, 0.64664, 0.65614, 0.66648, 0.67764, 0.68958, 0.70227/
      data (v1    (i),i= 190, 252)/
     1 0.71570, 0.72984, 0.74468, 0.76021, 0.77643, 0.79333, 0.81091,
     2 0.82916, 0.84810, 0.86771, 0.88801, 0.90900, 0.93068, 0.95307,
     3 0.97617, 1.00000, 1.00000, 0.89201, 0.82875, 0.78040, 0.74331,
     4 0.71505, 0.69371, 0.67781, 0.66624, 0.65817, 0.65297, 0.65017,
     5 0.64938, 0.65034, 0.65281, 0.65661, 0.66160, 0.66767, 0.67471,
     6 0.68265, 0.69142, 0.70098, 0.71127, 0.72226, 0.73392, 0.74623,
     7 0.75915, 0.77268, 0.78680, 0.80150, 0.81677, 0.83260, 0.84899,
     8 0.86594, 0.88343, 0.90147, 0.92007, 0.93921, 0.95892, 0.97918,
     9 1.00000, 1.00000, 0.91152, 0.85675, 0.81308, 0.77844, 0.75134/
      data (v1    (i),i= 253, 315)/
     1 0.73044, 0.71457, 0.70280, 0.69440, 0.68878, 0.68549, 0.68419,
     2 0.68459, 0.68647, 0.68965, 0.69399, 0.69937, 0.70569, 0.71287,
     3 0.72084, 0.72955, 0.73894, 0.74899, 0.75965, 0.77090, 0.78271,
     4 0.79506, 0.80794, 0.82132, 0.83521, 0.84958, 0.86443, 0.87975,
     5 0.89555, 0.91181, 0.92852, 0.94570, 0.96334, 0.98144, 1.00000,
     6 1.00000, 0.92814, 0.88105, 0.84158, 0.80901, 0.78273, 0.76194,
     7 0.74581, 0.73357, 0.72458, 0.71832, 0.71436, 0.71238, 0.71210,
     8 0.71329, 0.71578, 0.71942, 0.72409, 0.72969, 0.73613, 0.74335,
     9 0.75129, 0.75989, 0.76912, 0.77893, 0.78930, 0.80020, 0.81160/
      data (v1    (i),i= 316, 378)/
     1 0.82349, 0.83585, 0.84866, 0.86192, 0.87562, 0.88973, 0.90427,
     2 0.91921, 0.93457, 0.95033, 0.96649, 0.98304, 1.00000, 1.00000,
     3 0.94198, 0.90118, 0.86497, 0.83380, 0.80787, 0.78686, 0.77022,
     4 0.75733, 0.74764, 0.74067, 0.73602, 0.73335, 0.73240, 0.73294,
     5 0.73480, 0.73782, 0.74188, 0.74687, 0.75271, 0.75932, 0.76664,
     6 0.77462, 0.78322, 0.79239, 0.80209, 0.81232, 0.82303, 0.83420,
     7 0.84582, 0.85788, 0.87035, 0.88323, 0.89651, 0.91018, 0.92422,
     8 0.93865, 0.95344, 0.96860, 0.98412, 1.00000, 1.00000, 0.95306,
     9 0.91686, 0.88279, 0.85237, 0.82641, 0.80500, 0.78777, 0.77424/
      data (v1    (i),i= 379, 441)/
     1 0.76390, 0.75630, 0.75104, 0.74780, 0.74630, 0.74633, 0.74768,
     2 0.75022, 0.75382, 0.75835, 0.76375, 0.76992, 0.77680, 0.78434,
     3 0.79249, 0.80122, 0.81047, 0.82023, 0.83047, 0.84117, 0.85230,
     4 0.86385, 0.87581, 0.88815, 0.90088, 0.91398, 0.92744, 0.94126,
     5 0.95543, 0.96994, 0.98480, 1.00000, 1.00000, 0.96146, 0.92822,
     6 0.89538, 0.86523, 0.83908, 0.81723, 0.79949, 0.78543, 0.77458,
     7 0.76650, 0.76079, 0.75712, 0.75523, 0.75489, 0.75590, 0.75811,
     8 0.76138, 0.76561, 0.77070, 0.77658, 0.78317, 0.79042, 0.79829,
     9 0.80672, 0.81569, 0.82515, 0.83509, 0.84548, 0.85631, 0.86754/
      data (v1    (i),i= 442, 492)/
     1 0.87917, 0.89118, 0.90357, 0.91632, 0.92942, 0.94286, 0.95665,
     2 0.97077, 0.98522, 1.00000, 1.00000, 0.96741, 0.93590, 0.90366,
     3 0.87355, 0.84716, 0.82497, 0.80685, 0.79241, 0.78120, 0.77278,
     4 0.76677, 0.76282, 0.76067, 0.76009, 0.76087, 0.76287, 0.76594,
     5 0.76998, 0.77488, 0.78057, 0.78699, 0.79406, 0.80175, 0.81000,
     6 0.81879, 0.82808, 0.83784, 0.84805, 0.85868, 0.86973, 0.88116,
     7 0.89298, 0.90516, 0.91770, 0.93058, 0.94381, 0.95737, 0.97126,
     8 0.98547, 1.00000/
c
c      eps=1/30
c
      data (v2    (i),i=   1,  63)/
     1 1.00000, 0.78143, 0.71162, 0.66446, 0.63056, 0.60558, 0.58704,
     2 0.57334, 0.56344, 0.55659, 0.55227, 0.55008, 0.54973, 0.55100,
     3 0.55372, 0.55776, 0.56302, 0.56941, 0.57688, 0.58539, 0.59490,
     4 0.60538, 0.61682, 0.62922, 0.64256, 0.65686, 0.67212, 0.68835,
     5 0.70558, 0.72381, 0.74308, 0.76341, 0.78482, 0.80736, 0.83107,
     6 0.85596, 0.88210, 0.90953, 0.93828, 0.96842, 1.00000, 1.00000,
     7 0.82819, 0.76022, 0.71236, 0.67693, 0.65021, 0.62996, 0.61467,
     8 0.60332, 0.59516, 0.58964, 0.58637, 0.58502, 0.58536, 0.58721,
     9 0.59043, 0.59489, 0.60051, 0.60723, 0.61497, 0.62372, 0.63342/
      data (v2    (i),i=  64, 126)/
     1 0.64407, 0.65564, 0.66812, 0.68151, 0.69582, 0.71103, 0.72717,
     2 0.74425, 0.76227, 0.78127, 0.80125, 0.82224, 0.84427, 0.86737,
     3 0.89156, 0.91689, 0.94338, 0.97107, 1.00000, 1.00000, 0.86099,
     4 0.79739, 0.75088, 0.71547, 0.68821, 0.66718, 0.65105, 0.63886,
     5 0.62990, 0.62363, 0.61964, 0.61762, 0.61732, 0.61856, 0.62119,
     6 0.62507, 0.63011, 0.63625, 0.64340, 0.65153, 0.66060, 0.67058,
     7 0.68143, 0.69316, 0.70574, 0.71917, 0.73345, 0.74858, 0.76455,
     8 0.78139, 0.79909, 0.81767, 0.83714, 0.85752, 0.87883, 0.90108,
     9 0.92430, 0.94851, 0.97373, 1.00000, 1.00000, 0.88566, 0.82774/
      data (v2    (i),i= 127, 189)/
     1 0.78390, 0.74966, 0.72278, 0.70173, 0.68536, 0.67282, 0.66347,
     2 0.65678, 0.65238, 0.64994, 0.64923, 0.65005, 0.65225, 0.65570,
     3 0.66029, 0.66594, 0.67260, 0.68019, 0.68868, 0.69803, 0.70821,
     4 0.71919, 0.73097, 0.74352, 0.75684, 0.77092, 0.78576, 0.80135,
     5 0.81770, 0.83481, 0.85268, 0.87133, 0.89076, 0.91098, 0.93199,
     6 0.95383, 0.97649, 1.00000, 1.00000, 0.90552, 0.85402, 0.81381,
     7 0.78164, 0.75588, 0.73538, 0.71924, 0.70674, 0.69729, 0.69043,
     8 0.68579, 0.68309, 0.68207, 0.68256, 0.68439, 0.68744, 0.69160,
     9 0.69678, 0.70291, 0.70994, 0.71781, 0.72649, 0.73593, 0.74611/
      data (v2    (i),i= 190, 252)/
     1 0.75701, 0.76860, 0.78088, 0.79383, 0.80743, 0.82169, 0.83660,
     2 0.85216, 0.86836, 0.88521, 0.90270, 0.92084, 0.93963, 0.95909,
     3 0.97921, 1.00000, 1.00000, 0.92227, 0.87759, 0.84164, 0.81213,
     4 0.78799, 0.76845, 0.75282, 0.74054, 0.73112, 0.72416, 0.71933,
     5 0.71635, 0.71500, 0.71510, 0.71650, 0.71907, 0.72271, 0.72732,
     6 0.73283, 0.73919, 0.74634, 0.75424, 0.76284, 0.77212, 0.78205,
     7 0.79261, 0.80378, 0.81554, 0.82788, 0.84079, 0.85426, 0.86828,
     8 0.88285, 0.89796, 0.91362, 0.92981, 0.94655, 0.96382, 0.98164,
     9 1.00000, 1.00000, 0.93673, 0.89884, 0.86736, 0.84074, 0.81840/
      data (v2    (i),i= 253, 315)/
     1 0.79991, 0.78483, 0.77275, 0.76329, 0.75613, 0.75098, 0.74760,
     2 0.74578, 0.74536, 0.74619, 0.74815, 0.75114, 0.75506, 0.75986,
     3 0.76546, 0.77181, 0.77886, 0.78659, 0.79494, 0.80390, 0.81344,
     4 0.82353, 0.83417, 0.84532, 0.85699, 0.86916, 0.88182, 0.89496,
     5 0.90857, 0.92265, 0.93720, 0.95221, 0.96768, 0.98361, 1.00000,
     6 1.00000, 0.94921, 0.91764, 0.89034, 0.86640, 0.84567, 0.82804,
     7 0.81330, 0.80123, 0.79155, 0.78401, 0.77837, 0.77444, 0.77203,
     8 0.77097, 0.77114, 0.77242, 0.77470, 0.77791, 0.78197, 0.78681,
     9 0.79239, 0.79865, 0.80556, 0.81307, 0.82117, 0.82981, 0.83899/
      data (v2    (i),i= 316, 378)/
     1 0.84867, 0.85884, 0.86949, 0.88060, 0.89217, 0.90417, 0.91661,
     2 0.92947, 0.94276, 0.95645, 0.97056, 0.98508, 1.00000, 1.00000,
     3 0.95979, 0.93361, 0.90977, 0.88795, 0.86837, 0.85124, 0.83658,
     4 0.82428, 0.81421, 0.80617, 0.79997, 0.79543, 0.79238, 0.79069,
     5 0.79021, 0.79085, 0.79249, 0.79505, 0.79846, 0.80266, 0.80758,
     6 0.81319, 0.81943, 0.82627, 0.83368, 0.84163, 0.85010, 0.85906,
     7 0.86849, 0.87838, 0.88871, 0.89948, 0.91066, 0.92225, 0.93425,
     8 0.94663, 0.95941, 0.97256, 0.98609, 1.00000, 1.00000, 0.96847,
     9 0.94644, 0.92509, 0.90467, 0.88576, 0.86880, 0.85399, 0.84136/
      data (v2    (i),i= 379, 441)/
     1 0.83084, 0.82228, 0.81554, 0.81045, 0.80686, 0.80462, 0.80361,
     2 0.80372, 0.80485, 0.80691, 0.80982, 0.81352, 0.81796, 0.82308,
     3 0.82883, 0.83519, 0.84211, 0.84957, 0.85754, 0.86599, 0.87492,
     4 0.88429, 0.89409, 0.90431, 0.91494, 0.92597, 0.93738, 0.94918,
     5 0.96134, 0.97387, 0.98676, 1.00000, 1.00000, 0.97524, 0.95605,
     6 0.93627, 0.91664, 0.89802, 0.88102, 0.86598, 0.85302, 0.84209,
     7 0.83312, 0.82595, 0.82043, 0.81642, 0.81378, 0.81238, 0.81211,
     8 0.81287, 0.81457, 0.81714, 0.82051, 0.82461, 0.82940, 0.83483,
     9 0.84086, 0.84746, 0.85460, 0.86224, 0.87037, 0.87896, 0.88800/
      data (v2    (i),i= 442, 492)/
     1 0.89747, 0.90734, 0.91762, 0.92829, 0.93934, 0.95076, 0.96254,
     2 0.97468, 0.98717, 1.00000, 1.00000, 0.98019, 0.96274, 0.94384,
     3 0.92459, 0.90605, 0.88894, 0.87369, 0.86045, 0.84923, 0.83994,
     4 0.83247, 0.82666, 0.82236, 0.81945, 0.81779, 0.81728, 0.81780,
     5 0.81927, 0.82161, 0.82476, 0.82865, 0.83324, 0.83846, 0.84430,
     6 0.85070, 0.85763, 0.86508, 0.87300, 0.88140, 0.89023, 0.89949,
     7 0.90916, 0.91923, 0.92968, 0.94051, 0.95171, 0.96326, 0.97516,
     8 0.98741, 1.00000/
c
c       eps=1/20
c
      data (v3    (i),i=   1,  63)/
     1 1.00000, 0.80317, 0.74242, 0.70048, 0.66968, 0.64654, 0.62906,
     2 0.61594, 0.60628, 0.59946, 0.59500, 0.59257, 0.59189, 0.59276,
     3 0.59502, 0.59855, 0.60324, 0.60902, 0.61583, 0.62362, 0.63235,
     4 0.64200, 0.65254, 0.66396, 0.67625, 0.68942, 0.70345, 0.71837,
     5 0.73417, 0.75087, 0.76848, 0.78703, 0.80652, 0.82699, 0.84846,
     6 0.87096, 0.89451, 0.91916, 0.94493, 0.97186, 1.00000, 1.00000,
     7 0.84791, 0.78918, 0.74700, 0.71506, 0.69046, 0.67142, 0.65678,
     8 0.64568, 0.63751, 0.63180, 0.62820, 0.62642, 0.62626, 0.62754,
     9 0.63013, 0.63392, 0.63882, 0.64476, 0.65169, 0.65955, 0.66833/
      data (v3    (i),i=  64, 126)/
     1 0.67799, 0.68851, 0.69988, 0.71209, 0.72513, 0.73900, 0.75371,
     2 0.76926, 0.78566, 0.80292, 0.82105, 0.84008, 0.86002, 0.88088,
     3 0.90270, 0.92550, 0.94929, 0.97412, 1.00000, 1.00000, 0.87831,
     4 0.82372, 0.78307, 0.75142, 0.72649, 0.70682, 0.69141, 0.67949,
     5 0.67050, 0.66399, 0.65961, 0.65709, 0.65620, 0.65678, 0.65868,
     6 0.66179, 0.66602, 0.67129, 0.67754, 0.68472, 0.69279, 0.70172,
     7 0.71148, 0.72205, 0.73343, 0.74559, 0.75854, 0.77226, 0.78677,
     8 0.80205, 0.81813, 0.83500, 0.85267, 0.87115, 0.89046, 0.91062,
     9 0.93163, 0.95352, 0.97630, 1.00000, 1.00000, 0.90053, 0.85104/
      data (v3    (i),i= 127, 189)/
     1 0.81299, 0.78262, 0.75819, 0.73860, 0.72301, 0.71078, 0.70138,
     2 0.69443, 0.68958, 0.68657, 0.68520, 0.68528, 0.68668, 0.68928,
     3 0.69298, 0.69771, 0.70339, 0.70998, 0.71743, 0.72570, 0.73477,
     4 0.74460, 0.75518, 0.76650, 0.77854, 0.79130, 0.80476, 0.81893,
     5 0.83380, 0.84937, 0.86566, 0.88265, 0.90037, 0.91880, 0.93798,
     6 0.95789, 0.97856, 1.00000, 1.00000, 0.91806, 0.87420, 0.83953,
     7 0.81119, 0.78795, 0.76900, 0.75371, 0.74155, 0.73208, 0.72494,
     8 0.71985, 0.71654, 0.71483, 0.71454, 0.71553, 0.71769, 0.72092,
     9 0.72514, 0.73029, 0.73630, 0.74312, 0.75073, 0.75907, 0.76814/
      data (v3    (i),i= 190, 252)/
     1 0.77789, 0.78832, 0.79940, 0.81112, 0.82347, 0.83645, 0.85005,
     2 0.86426, 0.87908, 0.89451, 0.91055, 0.92720, 0.94447, 0.96235,
     3 0.98086, 1.00000, 1.00000, 0.93271, 0.89481, 0.86405, 0.83830,
     4 0.81675, 0.79886, 0.78419, 0.77235, 0.76298, 0.75580, 0.75055,
     5 0.74700, 0.74497, 0.74430, 0.74487, 0.74656, 0.74928, 0.75294,
     6 0.75749, 0.76285, 0.76898, 0.77584, 0.78339, 0.79161, 0.80046,
     7 0.80992, 0.81997, 0.83060, 0.84179, 0.85354, 0.86583, 0.87865,
     8 0.89200, 0.90587, 0.92027, 0.93518, 0.95061, 0.96655, 0.98302,
     9 1.00000, 1.00000, 0.94535, 0.91345, 0.88681, 0.86391, 0.84426/
      data (v3    (i),i= 253, 315)/
     1 0.82759, 0.81365, 0.80217, 0.79291, 0.78565, 0.78018, 0.77630,
     2 0.77387, 0.77274, 0.77278, 0.77390, 0.77600, 0.77901, 0.78286,
     3 0.78750, 0.79286, 0.79892, 0.80562, 0.81295, 0.82087, 0.82936,
     4 0.83839, 0.84795, 0.85803, 0.86860, 0.87967, 0.89121, 0.90322,
     5 0.91569, 0.92862, 0.94201, 0.95584, 0.97012, 0.98484, 1.00000,
     6 1.00000, 0.95632, 0.93006, 0.90736, 0.88716, 0.86930, 0.85372,
     7 0.84036, 0.82910, 0.81980, 0.81232, 0.80649, 0.80216, 0.79920,
     8 0.79749, 0.79692, 0.79739, 0.79882, 0.80113, 0.80426, 0.80815,
     9 0.81276, 0.81803, 0.82393, 0.83044, 0.83750, 0.84512, 0.85325/
      data (v3    (i),i= 316, 378)/
     1 0.86188, 0.87100, 0.88058, 0.89062, 0.90111, 0.91203, 0.92337,
     2 0.93513, 0.94730, 0.95988, 0.97285, 0.98623, 1.00000, 1.00000,
     3 0.96570, 0.94435, 0.92498, 0.90699, 0.89050, 0.87568, 0.86262,
     4 0.85136, 0.84185, 0.83400, 0.82770, 0.82285, 0.81932, 0.81701,
     5 0.81582, 0.81567, 0.81646, 0.81813, 0.82061, 0.82385, 0.82779,
     6 0.83240, 0.83763, 0.84346, 0.84984, 0.85675, 0.86417, 0.87208,
     7 0.88046, 0.88929, 0.89856, 0.90825, 0.91836, 0.92887, 0.93977,
     8 0.95107, 0.96274, 0.97479, 0.98721, 1.00000, 1.00000, 0.97347,
     9 0.95598, 0.93909, 0.92264, 0.90701, 0.89258, 0.87959, 0.86816/
      data (v3    (i),i= 379, 441)/
     1 0.85833, 0.85007, 0.84330, 0.83795, 0.83390, 0.83107, 0.82935,
     2 0.82867, 0.82894, 0.83009, 0.83207, 0.83480, 0.83824, 0.84235,
     3 0.84708, 0.85240, 0.85828, 0.86469, 0.87160, 0.87900, 0.88686,
     4 0.89516, 0.90389, 0.91304, 0.92259, 0.93254, 0.94287, 0.95357,
     5 0.96464, 0.97608, 0.98786, 1.00000, 1.00000, 0.97960, 0.96482,
     6 0.94953, 0.93401, 0.91883, 0.90453, 0.89145, 0.87979, 0.86965,
     7 0.86103, 0.85387, 0.84811, 0.84366, 0.84043, 0.83832, 0.83725,
     8 0.83715, 0.83793, 0.83954, 0.84192, 0.84502, 0.84878, 0.85317,
     9 0.85816, 0.86370, 0.86977, 0.87635, 0.88341, 0.89093, 0.89889/
      data (v3    (i),i= 442, 492)/
     1 0.90727, 0.91607, 0.92527, 0.93486, 0.94482, 0.95515, 0.96584,
     2 0.97688, 0.98827, 1.00000, 1.00000, 0.98415, 0.97107, 0.95670,
     3 0.94165, 0.92667, 0.91236, 0.89915, 0.88730, 0.87690, 0.86801,
     4 0.86057, 0.85452, 0.84979, 0.84628, 0.84391, 0.84258, 0.84223,
     5 0.84277, 0.84415, 0.84630, 0.84917, 0.85272, 0.85689, 0.86167,
     6 0.86700, 0.87286, 0.87923, 0.88608, 0.89339, 0.90114, 0.90932,
     7 0.91790, 0.92688, 0.93625, 0.94599, 0.95609, 0.96655, 0.97736,
     8 0.98851, 1.00000/
c
c         eps=1/10
c
      data (v4    (i),i=   1,  63)/
     1 1.00000, 0.83976, 0.79570, 0.76449, 0.74088, 0.72260, 0.70836,
     2 0.69736, 0.68902, 0.68291, 0.67872, 0.67620, 0.67516, 0.67544,
     3 0.67691, 0.67948, 0.68306, 0.68759, 0.69300, 0.69926, 0.70632,
     4 0.71417, 0.72276, 0.73209, 0.74213, 0.75289, 0.76435, 0.77650,
     5 0.78935, 0.80290, 0.81714, 0.83209, 0.84775, 0.86414, 0.88125,
     6 0.89910, 0.91771, 0.93708, 0.95725, 0.97821, 1.00000, 1.00000,
     7 0.88103, 0.83884, 0.80797, 0.78390, 0.76472, 0.74937, 0.73715,
     8 0.72755, 0.72018, 0.71475, 0.71102, 0.70881, 0.70795, 0.70832,
     9 0.70982, 0.71235, 0.71584, 0.72024, 0.72549, 0.73155, 0.73840/
      data (v4    (i),i=  64, 126)/
     1 0.74599, 0.75430, 0.76333, 0.77305, 0.78344, 0.79452, 0.80626,
     2 0.81866, 0.83173, 0.84547, 0.85987, 0.87494, 0.89070, 0.90714,
     3 0.92427, 0.94212, 0.96068, 0.97997, 1.00000, 1.00000, 0.90739,
     4 0.86868, 0.83946, 0.81605, 0.79695, 0.78132, 0.76860, 0.75836,
     5 0.75029, 0.74411, 0.73961, 0.73661, 0.73497, 0.73455, 0.73527,
     6 0.73702, 0.73974, 0.74337, 0.74784, 0.75312, 0.75918, 0.76596,
     7 0.77347, 0.78166, 0.79052, 0.80004, 0.81021, 0.82102, 0.83246,
     8 0.84453, 0.85722, 0.87053, 0.88448, 0.89905, 0.91425, 0.93010,
     9 0.94659, 0.96373, 0.98153, 1.00000, 1.00000, 0.92559, 0.89085/
      data (v4    (i),i= 127, 189)/
     1 0.86389, 0.84178, 0.82338, 0.80803, 0.79532, 0.78490, 0.77651,
     2 0.76994, 0.76498, 0.76148, 0.75931, 0.75835, 0.75850, 0.75967,
     3 0.76180, 0.76481, 0.76866, 0.77330, 0.77869, 0.78479, 0.79159,
     4 0.79905, 0.80716, 0.81590, 0.82525, 0.83520, 0.84575, 0.85688,
     5 0.86859, 0.88088, 0.89375, 0.90719, 0.92120, 0.93579, 0.95097,
     6 0.96672, 0.98306, 1.00000, 1.00000, 0.93927, 0.90869, 0.88441,
     7 0.86409, 0.84685, 0.83223, 0.81993, 0.80969, 0.80131, 0.79462,
     8 0.78945, 0.78567, 0.78316, 0.78181, 0.78154, 0.78225, 0.78388,
     9 0.78637, 0.78968, 0.79374, 0.79852, 0.80399, 0.81012, 0.81688/
      data (v4    (i),i= 190, 252)/
     1 0.82425, 0.83221, 0.84075, 0.84984, 0.85948, 0.86967, 0.88038,
     2 0.89161, 0.90337, 0.91564, 0.92842, 0.94171, 0.95552, 0.96983,
     3 0.98466, 1.00000, 1.00000, 0.95036, 0.92413, 0.90287, 0.88472,
     4 0.86905, 0.85553, 0.84396, 0.83419, 0.82606, 0.81945, 0.81423,
     5 0.81030, 0.80756, 0.80590, 0.80526, 0.80556, 0.80673, 0.80872,
     6 0.81147, 0.81495, 0.81911, 0.82392, 0.82936, 0.83538, 0.84197,
     7 0.84911, 0.85678, 0.86497, 0.87366, 0.88284, 0.89250, 0.90263,
     8 0.91322, 0.92427, 0.93578, 0.94773, 0.96014, 0.97298, 0.98627,
     9 1.00000, 1.00000, 0.95987, 0.93805, 0.92002, 0.90431, 0.89045/
      data (v4    (i),i= 253, 315)/
     1 0.87825, 0.86760, 0.85843, 0.85066, 0.84421, 0.83899, 0.83493,
     2 0.83195, 0.82997, 0.82894, 0.82878, 0.82945, 0.83088, 0.83304,
     3 0.83588, 0.83937, 0.84347, 0.84816, 0.85340, 0.85917, 0.86546,
     4 0.87224, 0.87949, 0.88722, 0.89539, 0.90400, 0.91304, 0.92250,
     5 0.93238, 0.94266, 0.95334, 0.96442, 0.97589, 0.98775, 1.00000,
     6 1.00000, 0.96818, 0.95065, 0.93582, 0.92253, 0.91047, 0.89957,
     7 0.88983, 0.88122, 0.87375, 0.86739, 0.86210, 0.85783, 0.85454,
     8 0.85217, 0.85067, 0.85000, 0.85010, 0.85093, 0.85245, 0.85463,
     9 0.85742, 0.86080, 0.86474, 0.86921, 0.87420, 0.87967, 0.88561/
      data (v4    (i),i= 316, 378)/
     1 0.89201, 0.89884, 0.90611, 0.91378, 0.92186, 0.93032, 0.93918,
     2 0.94841, 0.95801, 0.96797, 0.97829, 0.98897, 1.00000, 1.00000,
     3 0.97540, 0.96175, 0.94977, 0.93858, 0.92805, 0.91821, 0.90914,
     4 0.90091, 0.89358, 0.88717, 0.88169, 0.87713, 0.87345, 0.87063,
     5 0.86864, 0.86743, 0.86697, 0.86721, 0.86813, 0.86968, 0.87184,
     6 0.87458, 0.87786, 0.88167, 0.88597, 0.89075, 0.89600, 0.90169,
     7 0.90780, 0.91433, 0.92125, 0.92857, 0.93626, 0.94432, 0.95274,
     8 0.96151, 0.97063, 0.98009, 0.98988, 1.00000, 1.00000, 0.98150,
     9 0.97105, 0.96131, 0.95171, 0.94227, 0.93313, 0.92445, 0.91639/
      data (v4    (i),i= 379, 441)/
     1 0.90903, 0.90247, 0.89673, 0.89182, 0.88776, 0.88452, 0.88207,
     2 0.88038, 0.87943, 0.87918, 0.87959, 0.88064, 0.88229, 0.88452,
     3 0.88729, 0.89058, 0.89437, 0.89863, 0.90335, 0.90851, 0.91410,
     4 0.92009, 0.92647, 0.93324, 0.94038, 0.94788, 0.95573, 0.96392,
     5 0.97246, 0.98132, 0.99050, 1.00000, 1.00000, 0.98644, 0.97835,
     6 0.97015, 0.96158, 0.95279, 0.94403, 0.93553, 0.92747, 0.92001,
     7 0.91325, 0.90726, 0.90205, 0.89766, 0.89407, 0.89126, 0.88921,
     8 0.88789, 0.88727, 0.88731, 0.88799, 0.88927, 0.89113, 0.89354,
     9 0.89647, 0.89991, 0.90381, 0.90818, 0.91298, 0.91821, 0.92384/
      data (v4    (i),i= 442, 492)/
     1 0.92987, 0.93628, 0.94305, 0.95018, 0.95766, 0.96548, 0.97363,
     2 0.98210, 0.99090, 1.00000, 1.00000, 0.99022, 0.98368, 0.97641,
     3 0.96842, 0.95998, 0.95139, 0.94292, 0.93481, 0.92723, 0.92030,
     4 0.91409, 0.90866, 0.90403, 0.90018, 0.89712, 0.89482, 0.89324,
     5 0.89237, 0.89217, 0.89260, 0.89365, 0.89527, 0.89744, 0.90014,
     6 0.90334, 0.90702, 0.91116, 0.91574, 0.92075, 0.92616, 0.93196,
     7 0.93814, 0.94469, 0.95159, 0.95884, 0.96643, 0.97435, 0.98259,
     8 0.99114, 1.00000/
c
       common /$mubrm/ ieps, epsi
c
       e=min(ein, 100.)
       x=log10(e)
       call rndc(u)
c
       if(ieps .ge. 1 .and. ieps .le. 4)then
          call
     *    k4ptdi(vtbl(1,1,ieps), iu, ie, iu, 0., -2., .025, .3333333,
     *    u, x, ans)
          v=ans*epsi**u
       elseif(ieps .eq. 5) then
          v=1.
       else
          write(*,*) ' ieps=',ieps,' undef for mubrmv'
          stop
       endif
       end
