c      test kdblexpi1
c      implicit none
c     real*8 a/0./, ans, eps/1.d-10/
c     external func
c     real*8 func
c     call kdblexpi1(func, a, eps, ans)
c     write(*,*) ' ans=',ans, asin(1.d0)
c     end
c     real*8 function func(x)
c     real*8 x
c     func = 1./(1.+x**2)
c     end
c***************************************************
c      integral of a given function from a to inf.
c   by Mori & Moriguchi's double exponentil forumula.
c   This is adpted version of Maruzen lib.
c
c   /usage/  call kdblexpi1(func, a, eps, ans)
c    func: real*8. input. integrand function name.
c       a: real*8.  inut. the lower bound of the
c                 integral region.
c     eps: real*8. input. absolute error tolerance
c    ans : real*8. output. obtained integral.
c
c*************************************************

      subroutine kdblexpi1(func, a, eps, ans)
      implicit none
c----      include 'kdblexpi1.h'
#include "KKlib/kdblexpi1.h"

      real*8 func, a, eps, ans, epsv
      external func
      real*8 h
      real*8 vold, vnew, wm, wp
      real*8 eps0/1.0d-32/, epsq, epsm/0./, epsp/0./

      logical first/.true./
      save first
      integer is, ih, km, kp, nm, np, i, mstep
c
      if( first ) then
         call kdblexpi1aux
         first = .false.
      endif
         
      neval = 0

      if (abs(eps) .ge. eps0) then
        epsv = abs(eps)
      else
        epsv = eps0
      end if

      epsq = 0.2 * sqrt(epsv)

      h = half

      is = 2**npow
      ih = is

      l = 1

  101 continue

      km = 0
      kp = 0
      nm = 0
      np = 0

      vnew = 0

c     ---- initial step ----
c          integrate with mesh size = 0.5
c          and check decay of integrand
c
       do   i = is, nend, ih
        if (kp .le. 1) then
          wp = func(ap(i,l) + a) * bp(i,l)
          neval = neval + 1
          vnew = vnew + wp
          if (abs(wp) .le. epsv) then
            kp = kp + 1
            if (kp .ge. 2) then
              np = i - ih
              go to 111
            end if
          else
            kp = 0
          end if
        end if
       enddo
 111   continue
      if (l .le. 2) then
        if (np .eq. 0) then
          l = l + 1
          go to 101
        end if
      end if

       do   i = is, nend, ih

        if (km .le. 1) then
          wm = func(am(i,l) + a) * bm(i,l)
          neval = neval + 1
          vnew = vnew + wm
          if (abs(wm) .le. epsv) then
            km = km + 1
            if (km .ge. 2) then
              nm = i - ih
              go to 121
            end if
          else
            km = 0
          end if
        end if
       enddo
  121 continue

      vnew = vnew + func(a0(l) + a) * b0(l)
      neval = neval + 1

      if (nm .eq. 0) then
        nm = nend
        epsm = 0.2 * sqrt(abs(wm))
        write (*,
     *  '("kdblexpi1: Warning. slow decay on negative side ")')
      end if

      if (np .eq. 0) then
        np = nend
        epsp = 0.2 * sqrt(abs(wp))
        write (*,
     * '("Kdblexpi1: Warning. slow decay on positive side")')
      end if
c
      epsq = max(epsq, epsm, epsp)

c     ---- general step ----

      vold = h * vnew

       do   mstep = 1, npow
        vnew = 0.0
        ih = is
        is = is / 2
         do   i = is, nm, ih
          vnew = vnew
     $         + func(am(i,l) + a) * bm(i,l)
          neval = neval + 1
         enddo
         do   i = is, np, ih
          vnew = vnew
     $         + func(ap(i,l) + a) * bp(i,l)
          neval = neval + 1
         enddo

        vnew = (vold + h * vnew) * half
        if (abs(vnew - vold) .lt. epsq) then
c        ---- converged and return ----
          ans = vnew
          return
        endif
        h = h * half
        vold = vnew
      enddo
      write (*,
     * '("kdblexpi1: Warning. Insufficient mesh refinement")')
      ans = vnew
      end
c      ************************
      subroutine kdblexpi1aux
      implicit none
c----      include 'kdblexpi1.h'
#include "KKlib/kdblexpi1.h"
c
c     generate points and weights for double
c     exponential forula
c     over half infinite interval (a,infinity)        

c         l for de half infinite transformation       
c         l = 1  x = exp(0.5*t - exp(-t))            
c         l = 2  x = exp(t - exp(-t))                
c         l = 3  x = exp(2 * sinh t)                 

 
      real*8 h,eh, en, eni
      real*8 sh,ch
      integer n6
      parameter (n6 = 6)
      integer i

      npow = n6
      nend = 5 * 2**(npow+1)
      h = one / 2**(npow+1)
      eh = exp(h)

c     ---- de transformation x = exp(0.5*t-exp(-t)) ----

      a0(1) = exp(-one)
      b0(1) = 1.5d0 * a0(1)
      en = 1.0

       do   i = 1, nend
        en = en * eh
        eni = 1 / en
        sh = half * h * i
        ap(i,1) = exp(sh - eni)
        bp(i,1) = (half + eni) * ap(i,1)
        am(i,1) = exp(-sh - en)
        bm(i,1) = (half + en) * am(i,1)
       enddo

c     ---- de transformation x = exp(t-exp(-t)) ----
c                         l = 2

      a0(2) = exp(-one)
      b0(2) = 2.0 * a0(2)
      en = 1.0

       do   i = 1, nend
        en = en * eh
        eni = 1 / en
        sh = h * i
        ap(i,2) = exp(sh - eni)
        bp(i,2) = (1 + eni) * ap(i,2)
        am(i,2) = exp(-sh - en)
        bm(i,2) = (1 + en) * am(i,2)
       enddo

c     ---- de transformation x = exp(2*sinh t) ----
c                        l = 3

      a0(3) = 1.0
      b0(3) = 2.0
      en = 1.0

       do   i = 1, nend
        en = eh * en
        eni = 1 / en
        sh = en - eni
        ch = en + eni
        ap(i,3) = exp(sh)
        bp(i,3) = ch * ap(i,3)
        am(i,3) = 1 / ap(i,3)
        bm(i,3) = ch * am(i,3)
       enddo
      end
