      subroutine epBrSampP(media, Ee, prob, path)
c          generic brems sampling routine
      implicit none
#include "Zmedia.h"
#include "ZepTrackp.h"

      record /epmedia/media  ! input.
      real*8 Ee            ! input. Electron/positron energy in GeV
      real*8 prob          ! output. Brems prob. per r.l
      real*8 path          ! ouptut. sampled path in r.l

      real*8 u
      real*8 rhoin
      logical::LPMworks

      LPMworks = LPMeffect .and.
     * ( Ee > media.cnst.BremEeminLPM*Flpm/min(media.rhoc, 1.d0) )
   
      if( LPMworks ) then
c              LPM region
!!!         if( media.rhoc .eq. 1.) then
         call epBrHSampP(media, Ee, prob)
!!!         elseif( media.name(1:3) .eq.  "Air"  ) then
c                  for air we have scaling formula
c                 g/cm3 * 10^-3/10^-6 (kg/m3) = 10^3
!!!            rhoin = media.rho*media.rhoc* 1.e3
!!!            call cbremLPMXsec(Ee, rhoin, prob) !  prob.  /r.l
!!!         elseif( abs( media.rhoc-1.) .gt. 0.02 ) then
!!!            write(0,*)'  rhoc=', media.rhoc,' for ', media.name,
!!!     *    ' is not close to 1 (> 2%) with LPM effect; dangerous'
!!!            stop
!!!         else
!!!            call epBrHSampP(media, Ee, prob)
!!!         endif
      else
         if( Ee <= EpartialSC ) then
               ! EpartialSC <= BrEemaxS2 so surely Seltzer region
            call epBrSSampP(media, Ee,  prob)
         elseif(Ee .le. media.cnst.BrScrE) then
c            screeinig region
            call epBrLSampP(media, Ee,  prob)
         elseif( Ee .gt. media.cnst.CompScrE ) then
c            complete screeing region;no LPM.  may not come here; 
            call epBrCSampP(media, Ee, prob)
         endif
      endif
      call rndc(u)
      path = - log(u)/prob
      end
c     *********************************** 
      subroutine epBrSampE(media, Ee, Eg)
      implicit none
#include "Zmedia.h"
#include "ZepTrackp.h"
      record /epmedia/media  ! input.
      real*8 Ee            ! input. e-/e+ energy in GeV
      real*8 Eg            ! output. sampled Eg in GeV

      logical LPMworks

      LPMworks =LPMeffect .and.
     * ( Ee > media.cnst.BremEeminLPM*Flpm/min(media.rhoc, 1.d0))

      if( LPMworks ) then
         call epBrHSampE(media, Ee, Eg)
      else
         if(Ee <= EpartialSC ) then
c            Seltzer region
            call epBrSSampE(media, Ee,  Eg)
         elseif(Ee <  media.cnst.BrScrE) then
c            partial screeinig region
            call epBrLSampE(media, Ee,  Eg)
         elseif(Ee  >= media.cnst.CompScrE ) then
c            complete screeing region
            call epBrCSampE(media, Ee, Eg)
         else
            write(0,*)  'logial error of Brems sampling'
            stop
         endif
      endif
      end
