      subroutine epBrLSampP(media, Ee, prob)
!          partial screening region by ps1 or ps2
      implicit none
#include "Zmedia.h"
#include "ZepTrackp.h"
      record /epmedia/media
      real*8 Ee
      real*8 prob  ! output probability of Brems / X0

      real*8 ale
      

      if(Ee .le. media.cnst.BremEemin) then
         prob= 1.d-40
      else
         ale=log10(Ee)
         call kintp3(media.tbl.BrTXL,
     *   1, media.cnst.BremTXTL, media.cnst.BremLEemin,
     *   media.cnst.BremdETXL, ale, prob) 
      endif
      if( HowNormBrems == -1 ) then
         ! nothing to do
      else
         if( HowNormBrems == 1 ) then
            prob = prob/media.cnst.NormS
         elseif( HowNormBrems == 0 ) then
            prob = prob/media.cnst.NormPS
         else
            write(0,*) 'HowNormBrems =',HowNormBrems, 
     *              ' invalid in epBrLSampP'
            stop
         endif
      endif
      end
c     ************
      subroutine epBrLSampE(media, Ee, Eg)
c     ************
      implicit none
#include "Zmedia.h"
#include "Zmass.h"
      record /epmedia/media
      real*8 Ee,  Eg

      real*8 u, ale, us, ans, Ek, error
      real*8 dummy(1)
      data dummy/0.d0/
      save

      call rndc(u)
      Ek = Ee - masele
      ale = log10(Ee)
      if(u .gt. media.cnst.BremUminLA) then
c          region A
c&&&&&&&&&&&&&&&
c
c            this is a little bit faster  ( ~!0% )
c            than
c            using kpolintp2; accuracy seems OK
c          
         call k4ptdi(media.tbl.BrSTLA, 
     *        media.cnst.BremUszLA, 
     *        media.cnst.BremEsize,
     *        media.cnst.BremUszLA, 
     *        media.cnst.BremUminLA,
     *        media.cnst.BremLEemin,
     *        media.cnst.BremdULA,
     *        media.cnst.BremdEL, u,  ale,  ans)  
     
c         call kpolintp2(media.cnst.BremUminLA, 1,  media.cnst.BremdULA,
c     *        media.cnst.BremLEemin, 1,  media.cnst.BremdEL,
c     *        media.tbl.BrSTLA,   media.cnst.BremUszLA, 
c     *        media.cnst.BremUszLA, media.cnst.BremEsize,
c     *         3, 3, u, ale, ans, error) 
c         Eg= exp( ans*(1.-u))*media.cnst.BremEgmin
         Eg= exp( ans*(1.-u))*media.cnst.BremEgmin * Ek
      else
c         region B
         us = u**0.25d0
c&&&&&&&&&&&&&&&&&
         call k4ptdi(media.tbl.BrSTLB, 
     *        media.cnst.BremUszLB, 
     *        media.cnst.BremEsize,
     *        media.cnst.BremUszLB, 
     *        0.d0,
     *        media.cnst.BremLEemin,
     *        media.cnst.BremdULB,
     *        media.cnst.BremdEL, us,  ale,  ans)  
 
c        call kpolintp2(dummy, 1,  media.cnst.BremdULB,
c     *        media.cnst.BremLEemin, 1,  media.cnst.BremdEL,
c     *        media.tbl.BrSTLB,   media.cnst.BremUszLB, 
c     *        media.cnst.BremUszLB, media.cnst.BremEsize,
c     *         3, 3, us, ale, ans, error) 
c&&&&&&&&&&&&&&
c         Eg = exp(-ans*u)*(Ee - masele)
         Eg = exp(-ans*u)*Ek

      endif
      end

