c     **********************************
      function epPrgene(media, Eg, x) result(ans)
      use BPLPM
      implicit none
c
c     Generic pair creation function for entire energy region.
c     The same note as for epPrgenex
c
c     Eg < PairNonSc ==> Original B.H is modified
c     Eg < PairScrE  ==> partial screening only 
c     PairWcrE< Ee < PairEgmaxL===>complete sc. 
c     Ee < Eg2H      ===> complete sc.+ LPM  table
c     Ee > Ee2H      ===> comp. + LPM  by rejection
c
c
#include "Zglobalc.h"
#include "ZbasicCnst.h"
#include "Zmedia.h"
#include "Zmass.h"
#include "ZepTrackp.h"

      record /epmedia/ media  ! input media
      real(8),intent(in)::  Eg  !  photon energy in GeV.
      real(8),intent(in)::   x  !  x = Ee/Eg. (Ee one of pair
                                ! electron  energy)
      real(8)::ans  !  pair creation cross-section  ds/dx in mb


      real*8  epPairS
      real*8  epCompScrPrs
      real(8):: Egme
c
      integer i
      real*8 f, normf

      Egme = Eg/masele
      if(Eg .lt. media.cnst.PairEgmin) then
         ans  = 0.
      elseif(Eg .le.  media.cnst.PrScrE) then
c       A)   normally  next one holds
c               ------|-----------|---------
c                     PrScrE     PairEgmaxL  
c                    =CompScr
c
c       B)   next situation may not happen
c               ------|----------|-------
c                    PrScrE     CompScrE
c                 =PairEgmaxL
c           partial screening or no screening
         ans = epPairS(media, Egme, x)
      elseif(Eg .le. media.cnst.PairEgmaxL .and.
     *       Eg .gt.   media.cnst.CompScrE) then
c          In the case of B, this dose not happen
c          complete screening without LPM
         ans = epCompScrPrs(media,  x)
      elseif( .not. LPMeffect ) then
         ans = epCompScrPrs(media,  x)
      else
c          complete screening +  LPM
         call  epNormLPMp(media,  normf)
         ans = epPairSH(media, Eg, x)*normf
      endif

      end
c     ************************************
      subroutine epPrgeneTX(xmin, xmax, tx)
      implicit none
#include "Zglobalc.h"
#include "ZbasicCnst.h"
#include "Zmedia.h"
#include "Zmass.h"
#include "ZBPgene.h"


      real*8  xmin  ! input.  Ee/Eg min.
      real*8  xmax  ! input.  Ee/Eg max.
      real*8  tx    ! output.  Integral of pair function from
                    !         x= xmin to xmax
      external epPrgenex
      real*8   epPrgenex,  ans1, ans2
      real*8  Eg, d,  vt

      Eg = Egme *masele

      d=(xmax-xmin)/20.d0
      vt=xmax-d
      call k16pGaussLeg(epPrgenex, xmin, vt, 16,  ans1)
      call k16pGaussLeg(epPrgenex, vt, xmax, 16,  ans2)
      tx = ans1+ans2

      end
c     **************
      real*8 function epPrgeneSolv(v)
c     **************
      implicit none

c          used to solve total-cross-section * u = integral of
c          pair function from min to v.
c
c
c
      common/upsic/upsi,vmax
      real*8 upsi, vmax

      real*8 v

      real*8 ans

      call epPrgeneTX(v, vmax, ans)

      epPrgeneSolv = ans/upsi-1.d0

      end
