      function epBrem(Zin, Eeme, x) result(ans)
      use BPPS
      implicit none
#include "Zglobalc.h"
#include "ZbasicCnst.h"
!          This is by Tsai
!          From table B.4 of  Tsai (Rev. Mod. Phys.vol.46' 74).
!          compute differentical bremstralhng cross-section
!          at low energies where no LPM effect exists.
!        epBrem(media, Egme,x)= dsigma/dx : in  mb
!           alpha * r0**2 = 0.579 mb
!
      real(8),intent(in):: Zin  ! target atom Z
      real(8),intent(in)::Eeme ! input  Ee/me, i.e,  gamma factor 
      real(8),intent(in)::  x    ! input  Eg/Ee.    x <= 1.-me/Ee
      real(8)::ans   ! ds/dx in mb
 

      real(8):: phi1, phi2, psi1, psi2
      real(8):: gamma, delta, epsil


      call epBPZpart(Zin)
      delta = x/(2*(1.-x))/Eeme
      gamma = 200.* delta/ Z13
      epsil = 200.* delta/ Z23

      call epBPfc( gamma, epsil,  phi1, phi2, psi1, psi2)
      ans = ( (4.d0/3.d0 *(1.-x) + x**2) *
     * ( Z**2*(phi1-4*cf) + Z*psi1 )
     *  + 2.d0/3.d0 *(1-x) *
     * (Z**2*(phi1-phi2) + Z*(psi1-psi2)))/x

      ans= max(ans, 0.d0)
!          To mb, alpha r0**2 = 0.579 must be multiplied
      ans = ans * ar02
      end function epBrem
