      module BPLPM
      implicit none
      character(8),save::name=' '
      private
      real(8),save:: s1, alogs1, sconst, x0g, conv2mb, Z,
     *               s, Xc, Eesave, Egsave
      
      real,parameter:: pi12=37.699112
      real,parameter:: pi6=18.849556
      real,parameter:: er= 1.e-4
      public sconst
      public smigb, smigp, epBremH, epPairH, epBPLPMconst
      contains
!     interface to epPairH and epBremH
!     which are in epBPfuncH.f   for the LPM region
!    *************************
     function epPairSH(media, Eg, x) result(ans)
!    *************************
      implicit none
#include "Zmedia.h"
      record /epmedia/ media  ! input target media
      real(8),intent(in):: Eg  ! Eg  GeV
      real(8),intent(in)::  x    !  Ee/Eg


      call epBPLPMconst(media)
      ans = epPairH(Egme, x)
      end

!    *************************
     function epBremSH(media, Ee, x) result(ans)
!    *************************
      use BPLPM
      implicit none
#include "Zmedia.h"
#include "Zmass.h"
      record /epmedia/ media  ! input target media
      real(8),intent(in):: Ee  ! Ee GeV
      real(8),intent(in):: x     !  Eg/Ee
      real(8):: ans       ! ds/dx mb


      write(0,*) ' epBPLPMconst'
      call epBPLPMconst(media)
      Eesave = Ee
      call smigb0(media, Ee, x)  ! s and Xc are put in BPLPM
      write(0,*) ' epBremH'
      ans = epBremH(Ee, x)
      write(0,*) ' exiting BremSH'
      end
      subroutine smigb0(media, Ee, x)
      implicit none
#include "Zmedia.h"
      record /epmedia/ media
      real(8),intent(in):: Ee  ! electron energy GeV
      real(8),intent(in):: x   ! Eg/Ee

      !  migdal's  s; to be  stored in BPLPM module
      !            Xc= 1/(1+sconst/E) also stored in BPLPM
      !      
      real(4):: E, v
      logical got
      got = .false.
      select case( media.name )
        case('W')
           if( Ee > 1.7 ) then
             ans =0.3962*sqrt(10./Ee)
             got = .true.
           endif
        case('Pb')
           if( Ee > 1.8 ) then
              ans =0.5013*sqrt(10./Ee)
              got = .true.
           endif
        case('SCIN') 
           if( Ee > 200. ) then
              ans = sqrt(200./Ee)
              got = .true.
           endif
        case default
      end select
      if( .not. got ) then
                  !v, E must be single
         E = Ee
         v = x
         s = smigb(x, E, 1.0, er)
      endif
      Xc = 1./(1. + sconst/Ee)
      end subroutine smigb0

!     ****************************************************************
!     *                                                              *
!     * smigb:  get root s, from recursive relation                  *
!     *                                                              *
!     ****************************************************************
!
!
      function smigb(v, E, sin, er) result(ans)
      implicit none
!
      real,intent(in):: v, E, sin, er
      real:: ans

      real:: ss, s
!      real::  sbrem2   ! internal
!
      s = sin
      do
         ss=sqrt(sbrem2(v,E,s))
         if(abs((s-ss)/ss) < er) exit
         s=ss
      enddo
      ans = ss
      end function smigb
!
!     ***********
      function smigp(v, E, sin, er) result(ans)
!     ***********
      implicit none
!
      real,intent(in):: v, E,  sin, er
      real:: ans

      real:: ss, s

!      real:: spair2   ! internal

      s = sin
      do 
         ss = sqrt( spair2(v, e, s)  )
         if(abs((s-ss)/ss) < er) exit
         s=ss
      enddo
      ans = ss
      end function smigp
!     ****************************************************************
!     *                                                              *
!     * sbrem2:  auxliary function for brem with landau effect       *
!     * spair2:  //                    pair                          *
!     *                                                              *
!     ****************************************************************
!
!
      function sbrem2(v,e,s) result(ans)
      implicit none
!
      real,intent(in):: v, E,  s
      real:: ans

      real:: tmp
!      real::  gzai  ! internal

      tmp=sconst*v
      ans = tmp/(1.-v)/E/gzai(s)
      end function sbrem2

      function  spair2(v,E,s) result(ans)
      implicit none
      real,intent(in):: v, E,  s
      real:: ans

      real:: tmp
!      real:: gzai  ! internal

      tmp=sconst/v
      ans = tmp/(1.-v)/e/gzai(s)
      end function spair2
!     ****************************************************************
!     *                                                              *
!     * gzai:  gzai function which appear in ladanu effect           *
!     *                                                              *
!     ****************************************************************
!
!
      function gzai(s) result(ans)
      implicit none
      real,intent(in):: s
      real:: ans

      if(s > 1.) then
         ans = 1.
      elseif(s < s1) then
         ans =  log(s)/alogs1+1.
      else
         ans = 2.
      endif
      
      end function gzai
!     ****************************************************************
!     *                                                              *
!     * gmigdl:  g(s) function which appear in landau effect         *
!     * psimig:  pis(s) //                                           *
!     *                                                              *
!     ****************************************************************
!
!             .... psiim is needed.....
!
      function gmigdl(s,eps) result(ans)
      implicit none
      real,intent(in):: s, eps
      real::ans

      real  psiim  ! exernal
!
      ans = (pi12*s-48.*s*s*psiim(s+0.5,s,0,eps))*s
      end function gmigdl
!
!     ************
      function psimig(s,eps) result(ans)
!     ************
      implicit none
      real,intent(in):: s, eps
      real:: ans
      real psiim   ! external
!

      ans = ( (psiim(s,s,1,eps)*s*24.-pi6)*s+6.) *s
      end function psimig
!     ****************************************
!     *                                                             
!     * epBPLPMconst:  LPM const is calculated

!      For LPM, we use effective Z / media but not Z /atom or Z/molecule
! 


!
      subroutine epBPLPMconst(media)
      implicit  none
#include "Zmedia.h"      
#include "Zmass.h"      
!
      record /epmedia/media  ! input
 
!      s1=    ( z**0.3333333/ 183 )**2
      if(name /= media.name) then
         name = media.name
         s1 = media.s1
         alogs1 =  media.logs1
         conv2mb = 1.d0/media.mbtoPX0 
!
!        
         Z = media.Z
         x0g = media.X0g
!         const in eq.60 of migdal's paper. phys. rev. vol 103 1956
!         energy is in gev
         sconst=( 1.37e3 ) **2 * media.X0 * masele
      endif

      end subroutine epBPLPMconst
      end module BPLPM
