      implicit none
#include "Zmedia.h"
#include "Zmass.h"
c
c          test Bhabha scattering diff.  function.
c          as a function of recoil electron energy
c          at fixed positrotn energy
c 
      record /epmedia/media
      integer i, io, icon
      real*8 Ee, prob,  w, path, v, vm
      real*8 g, func, epBhabha,epBhabhaRL, func2
      character*80 file

      io = 10
      
      call  cerrorMsg(
     * "Enter  positron energy(1. GeV),"//
     * " minimu recoil energy(200d-6 GeV)"//  
     * " and file path('../../Data/Media/BGO')", 1)
      Ee = 1.
      w = 200.0d-6
      file = '../../Data/Media/BGO'
      
      read(*, *)  Ee, w, file
      call cerrorMsg(file,  1)

      call copenf(io, file, icon)
      call epReadTab(io, media)
      close(io)
      call epGetEffZA(media)
      call epStern(w, media)
      vm =  1.01*w/((Ee-masele))
      v = 1.0
      call epbhabhap(media, Ee, w,  prob, path)
      g = Ee/masele

      do while ( v .gt. vm )
         func = epBhabha(g, v)  ! bare Bhabha function
         func2 = epBhabhaRL(g, v)  ! bare Bhabha function
         write(*,'(1p,5g12.4)') v,  func, func2,
     *       func*media.sh.a/((g-1)*masele)/(1.-1./g/g),
     *       func2*media.sh.a/((g-1)*masele)/(1.-1./g/g)
         v = v/10.**0.02
      enddo
      end

      real*8 function epBhabha(g, v)
      implicit none
c         gives diff. Bhabha xs= ds/dv (v=Ek/T0)
c       Expressions are used in many literatures
c     Ek; recoil  electron kinetic energy
      real*8 v
      real*8 g  ! incident positron gamma factor
c     T0:      its kinetic energy
c            
c        if this is multiplied by C/m(g-1), prob/(g/cm2)
c       is obtained.  C=0.153..Z/A/beta2
c
      real*8 B1, B2, B3, B4, y, beta2

      y = 1./(g+1.)
      B1 = 2.- y**2
      B4 =  (1.-2*y)**3
      B3 = B4+(1.-2*y)**2
      B2 = (1.-2*y)*(3.+y**2)
      beta2 = 1.- 1./g/g

      epBhabha=1./v**2 - beta2*(B1/v -B2 + B3*v -B4*v*v)
      end
      real*8 function epBhabhaRL(g, v)
      implicit none
c         gives diff. Bhabha xs= ds/dv (v=Ek/T0)
c      Expressions are based on Rohrlich & Carlso,
c        Phys.Rev.vol.93, No.1 (1954) p.38
c       Apparent formulat looks very much different from
c       the epBhabha, and not easy to prove that the both
c       are equivalent, numerical results coincide.
c
c     Ek; recoil  electron kinetic energy
      real*8 v
      real*8 g  ! incident positron gamma factor
c     T0:      its kinetic energy
c            
c        if this is multiplied by C/m(g-1), prob/(g/cm2)
c       is obtained.  C=0.153..Z/A/beta2
c
      real*8 B1, B2, B3, B4, y, beta2
      real*8 u
      y = 1./(g+1.)
      u = g-1.0
      beta2 = 1.- 1./g/g

      epBhabhaRL=1./v**2 - beta2/v + (u/g)**2/2
     * - u*y*( (g+2)/g/v - 2*beta2 +
     *   v*(u/g)**2 ) 
     * + (u*y)**2*(0.5 + 1./g + 1.5/g/g
     * - (u/g)**2*v*(1.-v))
      end
