cc               to test kpolyg
c      implicit none
c      real*8 x,y, kpolyg
c      integer i, n
c      do n=0, 0
c         do i=1, 2500
c            x =-0.10 + (i-1)* 0.01
c            y = kpolyg(n, x)
c            write(*,*) x, y
c         enddo
c         write(*, *) 
c      enddo
c      end
c
c     *******************************************
c     *                                         *
c     *  kpolyg:  n-th logarithmic derivative    *
c     *          of gamma function.             *
c     *                                         *
c     *******************************************
c
c usage:
c         y= kpolyg(n,x)
c
c    n:  0,1,2... specifies n-th derivative
c    x:  argument. may be negative.
c        kpolyg(0,x) = psi(x) = d ln(Gamma(x))/dx
c         d  (G'/G ) /dx
c        kpolyg(1, x) =d psi(x)/dx etc
c      Note  psi(x) !=   dln(Gamma(x+1))/dx
c
c
       real*8 function kpolyg(n,x)
       implicit none
       real*8 x
       integer n
c
c
c
c
c     Computes n-th derivative of psi function with 7-8 significant dig
c     ts. psi(x) is logarithmic derivative of gamma function. psi(1)=-g
c     where g=0.57721566---Euler const. in Rossi notation, psi(s+1)=
c     dlog(s!)/ds=polyg(0,s+1.), where s! means factorial of s.  x must
c     not be 0,-1,-2,---, and for practical reason must be > -20, n<
c     nmax, (of course must be >= 0). if so message printed, and polyg=
c     1.0e35.
c
c
      integer,parameter::nmax=50 
      real*8 f(nmax)
      real*8 b(6)/8.333333e-2, -1.388889e-3, 3.3068783e-5,
     1         -8.267196e-7,  2.087676e-8, -52.841901e-11/
      logical first/.true./
      integer i, nt, j, m
      real*8 z, s, znt, z2, sn, sum, zn
      save first 

      if(first) then
c         compute factorial up to nmax
         first=.false.
         f(1)=1.
         do i=2,nmax
            f(i)=float(i-1)*f(i-1)
         enddo   
      endif   
c
      z=x
      if(z .gt. 0. .or. z - aint(z) .ne. 0. .and. 
     *           (n .ge. 0  .and.  n .lt. nmax)  ) then
         s=0.
         nt=n+1
         do while (z .lt. 4.)
            znt=1.
            do i=1,nt
               znt=znt*z
            enddo   
            s=s+1./znt
            z=z+1.
         enddo
         s=f(nt)*s
         z2=z*z
         zn=1.
         do while (nt .gt. 1)
            nt=nt-1
            zn=zn*z
         enddo   
         sn=-1.
         if(mod(n,2).ne.0) sn=1.
         sum=0.
         do i=1,6
            j=7-i
            m=j+j+n
            sum=(sum+f(m)*b(j))/z2
         enddo 
         sum=((sum+0.5*f(n+1)/z)/zn+s)*sn
         if(n .eq. 0) then
            kpolyg=log(z)+sum
         else   
            kpolyg=sum+f(n)/zn*sn
         endif   
      else   
         write(*,
     *   '( ''***error input to kpolyg: (z,n)='',e18.8,i10)') z,n
         kpolyg=1.e36
      endif   
      end
