      subroutine epBrSSampP(media, Ee, prob)
c          brems prob. sampling by Seltzer data.
      implicit none
#include "Zmedia.h"
#include "Zmass.h"
#include "ZepTrackp.h"

      record /epmedia/media
      real*8 Ee
      real*8 prob  ! output probability of Brems / X0

      real*8 ale, Ek


      if(Ee .le. media.cnst.BrEeminS) then
         prob= 1.d-40
      elseif( Ee <= media.cnst.BrEemaxS) then
         Ek = Ee - masele
         ale=log10(Ek)

         call kintp3(media.tbl.BrTXS,
     *   1, media.cnst.BrTXTS, media.cnst.BrLEeminS,
     *   media.cnst.BrdETXS, ale, prob) 
      elseif(Ee <=  media.cnst.BrEemaxS2 ) then
         Ek = Ee - masele
         ale=log10(Ek)
         call kintp3(media.tbl.BrTXS2,
     *   1, media.cnst.BrTXTS2, media.cnst.BrLEeminS2,
     *   media.cnst.BrdETXS2, ale, prob) 
      else
         write(0,*) ' Ee=',Ee,' too large for Seltzer'
         stop
      endif
      if( HowNormBrems == -1 ) then
         ! nothing to do
      else
         if( HowNormBrems == 1 ) then
            prob =prob / media.cnst.NormS
         elseif( HowNormBrems == 0 ) then
            prob =prob / media.cnst.NormS
         else
            write(0,*) 'HowNormBrems=',HowNormBrems
            write(0,*) ' invalide in epBrSSampP'
            stop
         endif
      endif
      end
c     ************
      subroutine epBrSSampE(media, Eein, Eg)
c     ************
c         brems energy by Seltzer
      implicit none
#include "Zmedia.h"
#include "Zmass.h"
      record /epmedia/media
      real*8 Eein,  Eg

      real*8 Ee, Ek 

      real*8 u, ale, us, ans, vmax
      integer count
      logical ok
c&&&&&&&
      real*8 dummy(1)
      real*8 error
      data dummy/0.d0/
      save
c&&&&&&&&&&&


      Ek = Eein-masele
      if(Eein .lt. media.cnst.BrEeminS) then
c         this  happne when electron loses energy    
c         after sampling of processes
         Ee = media.cnst.BrEeminS
      else
         Ee = Eein
      endif
      if(Ee <= media.cnst.BrEemaxS) then
         call epBrSSampE1(media, Ee, Eg)
      elseif( Ee <= media.cnst.BrEemaxS2) then
         call epBrSSampE2(media, Ee, Eg)
      else
         write(0,*)
     *   ' Ee=',Ee, ' too large for Seltzer'
         stop
      endif
      end

      subroutine epBrSSampE1(media, Eein, Eg)
c         brems energy by Seltzer
      implicit none
#include "Zmedia.h"
#include "Zmass.h"
      record /epmedia/media
      real*8 Eein,  Eg

      real*8 Ee, Ek 

      real*8 u, ale, us, ans, vmax
      integer count
      logical ok
c&&&&&&&
      real*8 dummy(1)
      real*8 error
      data dummy/0.d0/
      save
c&&&&&&&&&&&
      Ee = Eein
      Ek = Ee - masele
      vmax = 1.-masele/Ee
      ale = log10(Ek)

      count = 0      
 10   continue
      call rndc(u)
      if(u .gt. media.cnst.BrUminSA) then
c          region A
c&&&&&&&&&&&&&
c         call k4ptdi(media.tbl.BrSTSA, 
c     *        media.cnst.BrUszSA, 
c     *        media.cnst.BrES,
c     *        media.cnst.BrUszSA, 
c     *        media.cnst.BrUminSA,
c     *        media.cnst.BrLEeminS,
c     *        media.cnst.BrdUSA,
c     *        media.cnst.BrdES, u,  ale,  ans)  
c         Eg= exp( ans*(1.-u))*media.cnst.BrEgminS
         call kpolintp2(media.cnst.BrUminSA, 1,  media.cnst.BrdUSA,
     *            media.cnst.BrLEeminS, 1, media.cnst.BrdES,
     *            media.tbl.BrSTSA,  media.cnst.BrUszSA, 
     *            media.cnst.BrUszSA,  media.cnst.BrES,
     *             3, 3,  u, ale, ans, error)
c&&&&&&&&
!         Eg= exp( ans*(1.-u))*media.cnst.BrEgminS*Ee
         Eg= exp( ans*(1.-u))*media.cnst.BrEgminS   !  BrEgminS is not ratio v9.135
      else
c         region B
         us = u**0.25d0
         call kpolintp2(dummy, 1, media.cnst.BrdUSB,  
     *            media.cnst.BrLEeminS, 1, media.cnst.BrdES,
     *            media.tbl.BrSTSB,  media.cnst.BrUszSB, 
     *            media.cnst.BrUszSB,  media.cnst.BrES,
     *             3, 3,  us, ale, ans, error)
         Eg = exp(-ans*u)*Ee*vmax
      endif

      ok = Eein-Eg .ge. masele

      if(.not. ok) then
         count  = count + 1
         if(count .gt. 100 ) then
            call rndc(u)
            Eg = (Eein-masele)*u
            return  !  ******
         endif
         goto 10
      endif
      end   subroutine epBrSSampE1

      subroutine epBrSSampE2(media, Eein, Eg)
c         brems energy by Seltzer, upper region
      implicit none
#include "Zmedia.h"
#include "Zmass.h"
      record /epmedia/media
      real*8 Eein,  Eg

      real*8 Ee, Ek 

      real*8 u, ale, us, ans, vmax
      integer count
      logical ok
c&&&&&&&
      real*8 dummy(1)
      real*8 error
      data dummy/0.d0/
      save
c&&&&&&&&&&&
      Ee= Eein
      Ek = Ee - masele
      vmax = 1.-masele/Ee
      ale = log10(Ek)

      count = 0      
 10   continue
      call rndc(u)
      if(u .gt. media.cnst.BrUminSA2) then
c          region A
         call kpolintp2(media.cnst.BrUminSA2, 1, 
     *             media.cnst.BrdUSA2,
     *            media.cnst.BrLEeminS2, 1, media.cnst.BrdES2,
     *            media.tbl.BrSTSA2,  media.cnst.BrUszSA2, 
     *            media.cnst.BrUszSA2,  media.cnst.BrES2,
     *             3, 3,  u, ale, ans, error)
c&&&&&&&&
         Eg= exp( ans*(1.-u))*media.cnst.BrEgminS2*Ee
      else
c         region B
         us = u**0.25d0
         call kpolintp2(dummy, 1, media.cnst.BrdUSB2,  
     *        media.cnst.BrLEeminS2, 1, media.cnst.BrdES2,
     *        media.tbl.BrSTSB2,  media.cnst.BrUszSB2, 
     *        media.cnst.BrUszSB2,  media.cnst.BrES2,
     *             3, 3,  us, ale, ans, error)
         Eg = exp(-ans*u)*Ee*vmax
      endif

      ok = Eein-Eg .ge. masele

      if(.not. ok) then
         count  = count + 1
         if(count .gt. 100 ) then
            call rndc(u)
            Eg = (Eein-masele)*u
            return  !  ******
         endif
         goto 10
      endif
      end subroutine epBrSSampE2
