#!/bin/bash
if [ $# != 2 ]; then
    cat <<EOF
Usage: ./textCnf4.sh  epicsfile configfile
     where 
      epicsfile:  path to the  epicsfile
      configfile: relative path to config from the "dir"
                  or absolute path to config
        ***** "dir"  is the directory where the epicsfile exits ****
       For example: 
      ./textCnf4.sh  ../UserHook/FirstKiss/epicsfile config
EOF
exit
fi
make clean 
make -f testCnf4.mk

fullpath=$1
name=${fullpath##*/}
dir=${fullpath%/*}
cwd=`pwd`
cd $dir
echo $name $2 | $cwd/a.out 
cd $cwd

