#!/bin/bash
if [ $# != 4  ] && [ $# != 5 ] ; then
    cat <<EOF
Usage: ./textdEdx.sh  code subcode charge W
     where 
           code:  incident particle code (e-->2, mu->3, pi->4, K->5,p->6
                  heavy 9)  
        subcode:  anti particle-->1  regular particle -1 
                  heavy--> A
         charge:  Z
              W:  delta ray min energy in GeV(100keV --> 100e-6)
                ***if this is large restricted dE/dx
                   coinsides with dE/dx full ***
      ouputfile:  file path where  the result is stored; if not given, 
                  stdout 
      *** other implicit input:
      ./epicsfile:  StoppingPw is used
                  SrimEmax is used
                 -- RecoilKeMin is overwriten  by W--
        ./config:  Media is obtained from here
EOF
exit
fi
make  -f dEdx.mk clean 
make -f dEdx.mk


if [ $4 -eq 0 ]; then
    echo charge must not be 0
    exit
fi


if [ $# -eq 5 ] ; then
  echo  ./epicsfile ./config $1 $2   $3 $4   | ./a.out > $5
  echo output has been directed to  $5
else
  echo  ./epicsfile ./config $1 $2   $3 $4  | ./a.out 
fi
