      module prism
      integer,save::Compnum=-1000
      real(8),save:: a, b, c, h    ! 
      end module prism

      subroutine  eprprs(comp)
      implicit none
#include "Zglobalc.h"
#include "Zep3Vec.h"
#include "Zcnfig.h"
      record /Component/ comp   ! output. to recieve the config data.                               
      call eprpst(comp, 4, 4, 1, 6)
      if(comp.struc == 'prism' .or.
     *   comp.struc == 'prism_xy'     ) then
      elseif( comp.struc == 'prism_yx' ) then
      elseif( comp.struc == 'prism_xz' ) then
      elseif( comp.struc == 'prism_zx' )  then
      elseif( comp.struc == 'prism_yz' ) then
      elseif( comp.struc == 'prism_zy' ) then
      else
         write(0,*) ' at prism program'
         write(0,*) ' error structure=', comp.struc
         stop
      endif
      end      subroutine  eprprs

      subroutine epbprs(comp, pos, dir, length, icon)
      implicit none
c#include "Zglobalc.h"
#include "ZepTrackp.h"
#include "Zep3Vec.h"
#include "Zcnfig.h"
#include "ZepPos.h"
#include "ZepDirec.h"
#include "Zepdebug.h"
      record /Component/comp    ! input.  prism
      record /epPos/ pos        ! input.  position.
      record /epDirec/ dir      ! input. direction cosinse                                          
      real(8),intent(out):: length !  length cm from pos to the boundary
      integer,intent(out):: icon      !  0: length obtained. pos is inside
                             !        1:  //                        outside
                             !       -1: the line dose not cross the volume                                 
      record /epPos/ cpos
      record /epDirec/ cdir

      call epv2c_prism(comp, pos, cpos)
      call epv2cd_prism(comp,  dir, cdir)
      call epbprs0(comp, cpos, cdir, length, icon)
      end subroutine epbprs

      subroutine epv2c_prism(comp, pos, cpos)
      use prism
      implicit none
#include "ZepTrackp.h"
#include "Zep3Vec.h"
#include "Zcnfig.h"
#include "ZepPos.h"
#include "ZepDirec.h"
!            local coord of variant to local coord 
!            of canonical prism
      record /Component/comp    ! input.  honeycomb                                                 
      record /epPos/ pos        ! input.  position.
      record /epPos/ cpos       ! output  pos-->canonical one

      real(8):: temp
      call epprismCnst(comp)
      if( comp.struc == "prism" ) then
         cpos = pos
      elseif(  comp.struc == "prism_xy" ) then
         cpos = pos
      elseif(  comp.struc == "prism_y" .or. 
     *       comp.struc == "prism_yx"  ) then
         cpos =epPos(pos.y, b-pos.x, pos.z)
      elseif(  comp.struc == "prism_xz" ) then
         temp =  b - pos.z
         cpos = epPos( pos.x, temp, pos.y)
      elseif(   comp.struc == "prism_zx" ) then
         cpos = epPos( pos.z, pos.x, pos.y)
      elseif(   comp.struc == "prism_yz" ) then
         cpos =epPos(pos.y, pos.z, pos.x)
      elseif(   comp.struc == "prism_z" .or.
     *          comp.struc == "prism_zy" ) then
         temp =  b - pos.y
         cpos =epPos(pos.z, temp, pos.x)
      else
         write(0,*) ' struc=',comp.struc, ' invalid'
         stop
      endif
      end subroutine epv2c_prism

      subroutine epv2cd_prism(comp, dir, cdir)
      use prism
      implicit none
#include "ZepTrackp.h"
#include "Zep3Vec.h"
#include "Zcnfig.h"
#include "ZepPos.h"
#include "ZepDirec.h"
!            local coord of variant to local coord 
!            of canonical prism
      record /Component/comp    ! input.  honeycomb                                                 
      record /epDirec/ dir      ! input. direction cosinse                                          
      record /epDirec/ cdir   ! output    dir--> //

      call epprismCnst(comp)
      if( comp.struc == "prism" ) then
         cdir = dir
      elseif(  comp.struc == "prism_xy" ) then
         cdir = dir
      elseif(  comp.struc == "prism_y" .or. 
     *       comp.struc == "prism_yx"  ) then
         cdir =epDirec(dir.y, -dir.x, dir.z)
      elseif(  comp.struc == "prism_xz" ) then
         cdir = epDirec(dir.x, -dir.z, dir.y)
      elseif(   comp.struc == "prism_zx" ) then
         cdir = epDirec(dir.z, dir.x, dir.y)
      elseif(   comp.struc == "prism_yz" ) then
         cdir = epDirec(dir.y, dir.z, dir.x)
      elseif(   comp.struc == "prism_z" .or.
     *          comp.struc == "prism_zy" ) then
         cdir = epDirec(dir.z, -dir.y, dir.x)
      else
         write(0,*) ' struc=',comp.struc, ' invalid'
         stop
      endif
      end subroutine epv2cd_prism



      subroutine epc2v_prism(comp, cpos, pos)
      use prism
      implicit none
#include "ZepTrackp.h"
#include "Zep3Vec.h"
#include "Zcnfig.h"
#include "ZepPos.h"
#include "ZepDirec.h"
!             canonical coord to variant local
      record /Component/comp    ! input.  honeycomb                                                 
      record /epPos/ cpos        ! input.  canonical position.
      record /epPos/ pos        ! output  pos-->varant local one

      real(8):: temp
      call epprismCnst(comp)
      if( comp.struc == "prism" ) then
         pos = cpos
      elseif(  comp.struc == "prism_xy" ) then
         pos = cpos
      elseif(  comp.struc == "prism_y" .or. 
     *       comp.struc == "prism_yx"  ) then
!         cpos =epPos(pos.y, b-pos.x, pos.z)  V-->C
!                     X : y    Y : b-x   Z :z
         pos =epPos(b-cpos.y, cpos.x, cpos.z)  ! C-->V
      elseif(  comp.struc == "prism_xz" ) then
!         temp =  b - pos.z
!         cpos = epPos( pos.x, temp, pos.y)
!              X: x     Y: b-z   Z: y
         pos = epPos(cpos.x, cpos.z,  b-cpos.y) 
      elseif(   comp.struc == "prism_zx" ) then
!         cpos = epPos( pos.z, pos.x, pos.y)
!                  X:z    Y:x          Z:y
         pos = epPos(cpos.y,  cpos.z, cpos.x)
      elseif(   comp.struc == "prism_yz" ) then
!         cpos =epPos(pos.y, pos.z, pos.x)
!                X:y   Y:z    Z:x
         pos= epPos( cpos.z, cpos.x, cpos.y)
      elseif(   comp.struc == "prism_z" .or.
     *          comp.struc == "prism_zy" ) then
!         temp =  b - pos.y
!         cpos =epPos(pos.z, temp, pos.x)
!              X: z      Y: b-y   Z:x
         pos = epPos(cpos.z, b-cpos.y, cpos.x)
      else
         write(0,*) ' struc=',comp.struc, ' invalid'
         stop
      endif
      end subroutine epc2v_prism

      subroutine epc2vd_prism(comp, cdir, dir)
      use prism
      implicit none
#include "ZepTrackp.h"
#include "Zep3Vec.h"
#include "Zcnfig.h"
#include "ZepPos.h"
#include "ZepDirec.h"
!            local coord of variant to local coord 
!            of canonical prism
      record /Component/comp    ! input.  honeycomb                                                 
      record /epDirec/ cdir      ! input. direction cosinse in canonical coord.
                                         
      record /epDirec/ dir   ! output.  local coord.
      real(8):: temp

      call epprismCnst(comp)
      if( comp.struc == "prism" ) then
         dir = cdir
      elseif(  comp.struc == "prism_xy" ) then
         dir = cdir
      elseif(  comp.struc == "prism_y" .or. 
     *       comp.struc == "prism_yx"  ) then
!         cdir =epDirec(dir.y, -dir.x, dir.z)   X:y   Y:-x  Z:z
         dir =epDirec(-cdir.y, cdir.x, cdir.z)
      elseif(  comp.struc == "prism_xz" ) then
!         temp =  b - pos.z
!         cdir = epDirec(dir.x, -dir.z, dir.y)  X:x  Y:-z   Z:y
         dir = epDirec(cdir.x, cdir.z, -cdir.y) 
      elseif(   comp.struc == "prism_zx" ) then
!         cdir = epDirec(dir.z, dir.x, dir.y)  X:z Y:x Z:y
         dir = epDirec(cdir.y, cdir.z, cdir.x) 
      elseif(   comp.struc == "prism_yz" ) then
!         cdir = epDirec(dir.y, dir.z, dir.x)  X:y  Y:z  Z:x
         dir = epDirec(cdir.z, cdir.x, cdir.y) 
      elseif(   comp.struc == "prism_z" .or.
     *          comp.struc == "prism_zy" ) then
!         temp =  b - pos.y
!         cdir = epDirec(dir.z, -dir.y, dir.x) X:z  Y;-y  Z:x
         dir = epDirec(cdir.z, -cdir.y, cdir.x)
      else
         write(0,*) ' struc=',comp.struc, ' invalid'
         stop
      endif
      end subroutine epc2vd_prism

      subroutine epprismCnst(comp)
      use prism
      implicit none
#include "Zep3Vec.h"
#include "Zcnfig.h"
      record /Component/ comp   ! output. to recieve the config data.

      if( Compnum /= comp.cn ) then
         a = Volat( comp.vol + 1)
         b = Volat( comp.vol + 2)
         c = Volat( comp.vol + 3)
         h = Volat( comp.vol + 4)
         Compnum = comp.cn
      endif
      end    subroutine epprismCnst


      subroutine epsprism(ncx, pos, icon)
c          search specified prism
c         Is  pos in ncx-th comp.  ? if yes, icon=0 else
c               icon = 1
c         pos is assumed to be Local coord.
       implicit none
#include  "ZepTrackv.h"
#include  "Zcnfig.h"
           record /epPos/ pos
           integer ncx,  icon
           record /epPos/ cpos
!              to canonical coord.              
      call epv2c_prism(Det.cmp(ncx),  pos, cpos)
      call epsprism0(ncx, cpos, icon)
      end    subroutine epsprism

      subroutine epenvlpPrism(comp, org, abc)
      use prism
      implicit none
#include "Zep3Vec.h"
#include "Zcnfig.h"
#include "ZepPos.h"
c
      record /Component/ comp
      record /epPos/ org
      record /ep3Vec/ abc
      real(8)::temp, temp2
      record /epPos/ vtx, tvtx
      integer i

      call epenvlpPrism0(comp, org, abc)
c/////////
c      write(0,*) 'org=',org
c      write(0,*) 'abc=',abc
c//////////
      if( comp.struc == "prism" ) then
      elseif(  comp.struc == "prism_xy" ) then
      elseif(  comp.struc == "prism_y" .or. 
     *       comp.struc == "prism_yx"  ) then
!         temp = org.x
!         org = epPos( org.y, temp, org.z)
         temp = abc.x
         abc = ep3Vec( abc.y, temp, abc.z)
      elseif(  comp.struc == "prism_xz" ) then
         temp = abc.y
         abc = ep3Vec( abc.x, abc.z, temp)
      elseif(   comp.struc == "prism_zx" ) then
!         temp = org.x
!         temp2 = org.y
!         org = epPos( org.z, temp, temp2)
         temp = abc.x
         temp2 = abc.y
         abc = ep3Vec( temp2, abc.z, temp)
      elseif(   comp.struc == "prism_yz" ) then
!         temp =  Volat(comp.vol+prismb) - org.y
!         temp2 = org.x
!         org = epPos(org.y, temp, temp2)
         temp = abc.y
         temp2= abc.x
         abc = ep3Vec( abc.z, temp2, temp)
      elseif(   comp.struc == "prism_z" .or.
     *          comp.struc == "prism_zy" ) then
!         temp =  Volat(comp.vol+prismb) - org.y
!         temp2 = org.x
!         org = epPos(org.z, temp, temp2)
         temp = abc.y
         temp2 = abc.x
         abc = ep3Vec( abc.z, temp, temp2)
c///////////
c         write(0,*) ' org =', org
c         write(0,*) ' abc =', abc
c////////
      else
         write(0,*) ' struc=',comp.struc, ' invalid'
         write(0,*) ' detected at epenvlpPrism'
         stop
      endif

c             canonicla -->local
!!      do i = 1, NVTX
!!         if(  comp.struc == "prism_y" .or. 
!!     *       comp.struc == "prism_yx"  ) then
!!            temp = VTXx(i)
!!            VTXx(i) =b- VTXy(i)   !??
!!            VTXy(i) = temp
!!         elseif(  comp.struc == "prism_xz" ) then
!!            temp = b - VTXy(i)
!!            temp2 = VTXz(i)
!!            VTXy(i) =  temp2
!!            VTXz(i) =  temp
!!         elseif(   comp.struc == "prism_zx" ) then
!!            temp = VTXx(i)
!!            VTXx(i) = VTXy(i)
!!            VTXy(i) = VTXz(i)
!!            VTXz(i) = temp
!!         elseif(   comp.struc == "prism_yz" ) then
!!            temp =  VTXy(i)
!!            temp2 = VTXx(i)
!!            VTXx(i) = VTXz(i)
!!            VTXy(i) = temp2
!!            VTXz(i) = temp
!!         elseif(   comp.struc == "prism_z" .or.
!!     *          comp.struc == "prism_zy" ) then
!!            temp =  b - VTXy(i)
!!            temp2 = VTXx(i)
!!            VTXx(i) = VTXz(i)
!!            VTXy(i) = temp
!!            VTXz(i) = temp2
!!c///////////
!!c            write(0,*) ' org =', org
!!c            write(0,*) ' abc =', abc
!!c////////
!!         endif
!!      enddo
      do i = 1, NVTX
         vtx = epPos( VTXx(i), VTXy(i), VTXz(i))
         call epc2v_prism(comp, vtx, tvtx)
         VTXx(i) = tvtx.x
         VTXy(i) = tvtx.y
         VTXz(i) = tvtx.z
      enddo

      end  subroutine epenvlpPrism

      subroutine epatlocprism(comp,loc)
      implicit none
#include "Zep3Vec.h"
#include "Zcnfig.h"
      record /Component/ comp   ! input.
      integer loc(*)
      integer i
      do i = 1, 4
         loc(i) = i
      enddo
      end subroutine epatlocprism

      subroutine epbprs0(comp, posl, dirl, length, icon)
      use prism
      implicit none
c #include "Zglobalc.h"
#include "ZepTrackp.h"
#include "Zep3Vec.h"
#include "Zcnfig.h"
#include "ZepPos.h"
#include "ZepDirec.h"
#include "Zepdebug.h"
      record /Component/comp    ! input.  honeycomb
      record /epPos/ posl        ! input.  position
      record /epDirec/ dirl      ! input. direction cosinse
      real(8),intent(out):: length    !  length cm from pos to the boundary
      integer,intent(out):: icon ! t 0: length obtained. pos    is inside
                      !        1:  //                        outside                                                      !       -1: the line dose not cross the volume
      call kxplPrism(posl.x, posl.y, posl.z,
     *     dirl.x, dirl.y, dirl.z,
     *     a, b, c, h, length, icon)

      end      subroutine epbprs0

      subroutine epenvlpPrism0(comp, org, abc)
      use prism
      implicit none
#include "Zep3Vec.h"
#include "Zcnfig.h"
#include "ZepPos.h"

      record /Component/ comp
      record /epPos/ org
      record /ep3Vec/ abc

      call epprismCnst(comp)

!      org.x = min(Volat(base+prisma), Volat(base + prismc), 0.d0)
!      org.y = min(Volat(base+prismb), 0.d0)
!      org.z = min(Volat(base+prismh), 0.d0)
      org = epPos(  min(a, c,  0.d0), 
     *              min( b, 0.d0),
     *              min( h, 0.d0) )
      abc = ep3Vec( max(a, c, 0.d0) - org.x,
     *              max(b, 0.d0)    - org.y,
     *              max(h, 0.d0)    - org.z )


      NVTX = 6
      VTXx(1) = 0.
      VTXy(1) = 0.
      VTXz(1) = 0

      VTXx(2) = a
      VTXy(2) = 0.
      VTXz(2) = 0.

      VTXx(3) = c
      VTXy(3) = 0.
      VTXz(3) = h

      VTXx(4) = 0.
      VTXy(4) = b
      VTXz(4) = 0

      VTXx(5) = a
      VTXy(5) = b
      VTXz(5) = 0.

      VTXx(6) = c
      VTXy(6) = b
      VTXz(6) = h
      end  subroutine epenvlpPrism0
      subroutine epsprism0(ncx, pos, icon)
      use prism
c          search specified prism
c         Is  pos in ncx-th comp.  ? if yes, icon=0 else
c               icon = 1
c         pos is assumed to be Local coord.
       implicit none
#include  "ZepTrackv.h"
#include  "Zcnfig.h"
           record /epPos/ pos
           integer ncx,  icon

        call kioPrism(pos.x, pos.y, pos.z, 
     *        a, b, c, h, icon)
       end    subroutine  epsprism0

