       subroutine eppos2cn(ncx, aTrack, nc)
       implicit none

c          find  component # of given track which is
c          in or near ncx-th component. 
c          if ncx = 0, 
c               aTrack.pos is assumed to be in world coord.
c          else
c               aTrack.pos is assumed to be in local coord.
c               of the ncx-th comp.
c
#include  "ZepTrack.h"
#include  "Zep3Vec.h"
#include  "Zcnfig.h"

       integer ncx
       record /epTrack/ aTrack  ! input. ask  where is this track
       integer nc               ! output.  found comp. #, if
                        ! the point is outside of any comp.
                        ! nc=Det.nct+1

       character*70 msg
c
!!       if(form .eq. 'box') then
!!c                   only boxes with the same a, b 
!!          call epsbox(ncx, aTrack, nc)
!!       elseif(form .eq. 'cyl') then
!!          call epscyl(ncx, aTrack, nc)
!!       elseif(form .eq. 'pipe') then
!!          call epspip(ncx, aTrack, nc)
!!       elseif(form .eq.  'mix') then
          call epsall(ncx, aTrack.pos,  nc)
!       else
!          write(msg,*)
!     *         ' eppos2cn for form=',form, ' not supported'
!          call cerrorMsg(msg, 0)
!       endif
      end
      subroutine epsInside(pos, nci,  nco)
      implicit none
#include  "ZepMaxdef.h"
#include  "ZepPos.h"
#include  "Zep3Vec.h"
#include  "Zcnfig.h"
      record /epPos/ pos  !  input. see if pos is in some matreska.
c                                   pos is in W.C
      integer   nci  !  input.  component number  which  includes pos,
                     !  and is Matreska
      integer   nco  !  output.  Matreska's  component number which
                     !          includes pos.  if 0, there is no
                     !          child matreska which includes pos.

      record /epPos/ posl

      integer i, icon
      do i  = 1, Det.cmp(nci).NMatreska
c(((((((((((((((
c         call epw2l(Det.cmp(nci).Contains(i), pos, posl)
c         call epsOne(Det.cmp(nci).Contains(i), posl, icon)
         call epw2l(CnArea( Det.cmp(nci).Contains+i), pos, posl)
         call epsOne(CnArea( Det.cmp(nci).Contains+i), posl, icon)
c)))))))))))))
         if(icon .eq. 0) then
c((((((((((((((
c            nco  = Det.cmp(nci).Contains(i)
            nco  = CnArea( Det.cmp(nci).Contains+i )
c))))))))))
            goto 10
         endif
      enddo
      nco =  0
 10   continue
      end


      subroutine epsOne(ncx, pos, icon)
      implicit none
#include  "ZepMaxdef.h"
#include  "ZepPos.h"
#include  "Zep3Vec.h"
#include  "Zcnfig.h"

c          see if pos is in ncx-th comp.
c          pos is in l.c of  ncx
c          if  yes, icon = 0 else  icon =1
c        This simply judge pos is inside  of ncx-th comp.
c       Even if yes, the point may be in an inner componennt.
c       or not included in a union part.
c       So that it must be examined further.
c
      record /epPos/ pos
      
      character*80 msg
      character*8  epparaphrase, tempph

      integer  ncx,  i, icon
      integer uscl
c     
      i = ncx

      if(Det.cmp(i).struc(1:3) .eq. 'box') then
         call epssbox(i, pos, icon)

      elseif(Det.cmp(i).struc(1:3) .eq. 'cyl') then
         call epscyl1(i, pos, icon)

      elseif(Det.cmp(i).struc(1:4) .eq. 'pipe') then
         call epspip1(i, pos, icon)

      elseif(Det.cmp(i).struc(1:6) .eq. 'sphere') then
         call epsssph(i, pos, icon)

      elseif(Det.cmp(i).struc .eq. 'prism' .or.
     *      Det.cmp(i).struc(1:6) .eq. 'prism_') then   
         call epsprism(i, pos, icon)
      elseif(Det.cmp(i).struc(1:4) .eq. 'new-') then
         call epsNew(Det.cmp(i), pos, icon)
      else
         call epseeUnderScore(Det.cmp(i).struc, uscl)
         tempph = epparaphrase(Det.cmp(i).struc(1:uscl))
         if(tempph(1:4) .eq. 'new-') then
            call epsNew(Det.cmp(i), pos, icon)
         else
            write(msg, *) ' struc=', trim(Det.cmp(i).struc),
     *           '  for ',i,'-th comp. invalid'
            call cerrorMsg(msg, 0)
         endif
      endif
      end
      subroutine epsPCont(ncx, pos, icon)
      implicit none
#include  "ZepMaxdef.h"
#include  "ZepPos.h"
#include  "Zep3Vec.h"
#include  "Zcnfig.h"
c          see if pos, in ncx-th comp.,
c          is included in a parent which partially
c          includes ncx-th comp.  pos is in ncx-local.
c          if  yes, icon = 0 else  icon =1
c          If there is no parent, icon =0
c
      record /epPos/ pos

      integer  ncx,  icon

      character*80 msg
      character*8  epparaphrase, tempph

      integer i, j, ii

      record /epPos/ posw, posl
c           see if parent matreska  which partially
c           contains this ncx-th comp.
c           If the point is not in any of such a parent
c           matreska, icon = 1 will result
c           so the point is considered not included in
c           the current component.


      i = ncx
      if(Det.cmp(i).NPContainer .gt. 0) then
         call epl2w(ncx, pos, posw)
         do j =1, Det.cmp(i).NPContainer
c                see if pos is inside the  parent matreshka which is ii-th
c                comp.
c((((((((((((((
c            ii = Det.cmp(i).PContained(j)
            ii = CnArea( Det.cmp(i).PContained+j )
c))))))))))
            call epw2l(ii, posw,  posl)
            if(Det.cmp(ii).struc(1:3) .eq. 'box') then
               call epssbox(ii, posl, icon)
            elseif(Det.cmp(ii).struc(1:3) .eq. 'cyl') then
               call epscyl1(ii, posl, icon)
            elseif(Det.cmp(ii).struc(1:4) .eq. 'pipe') then
               call epspip1(ii, posl, icon)
            elseif(Det.cmp(ii).struc(1:6) .eq. 'sphere') then
               call epsssph(ii, posl, icon)
            elseif(Det.cmp(ii).struc .eq. 'prism' .or.
     *             Det.cmp(ii).struc(1:6) .eq. 'prism_') then
               call epsprism(ii, posl,  icon)
            elseif(Det.cmp(ii).struc(1:4) .eq. 'new-') then
               call epsNew(Det.cmp(ii),  posl, icon)
            else
               tempph = epparaphrase(Det.cmp(ii).struc)
               if(tempph(1:4) .eq. 'new-') then
                  call epsNew(Det.cmp(ii),  posl, icon)
               else
                  write(msg, *)
     *                ' struc=', Det.cmp(i).struc,'  for ',i,
     *                '-th comp. invalid'
                  call cerrorMsg(msg, 0)
               endif
            endif
            if(icon .eq. 0) goto 100
         enddo
      else
         icon = 0
      endif
 100  continue
      end
c             
      subroutine  epsMatreska(ncx, pos, nc)
      implicit none
#include  "ZepMaxdef.h"
#include  "ZepPos.h"
#include  "Zep3Vec.h"
#include  "Zcnfig.h"
c          see if pos  in ncx-th comp.
c          is included in one of the child Matreskas.
c          pos is in ncx-local.
c          if some matreska is found, nc will get
c          that comp. # or nc = ncx.
c       
c      
      record /epPos/ pos
      integer  ncx,    nc
      integer  nco
      record /epPos/ posw

      nc = ncx
      if(Det.cmp(nc).NMatreska .gt. 0) then

         call epl2w(nc, pos, posw)

         do  while(Det.cmp(nc).NMatreska .gt. 0)
c           find inner most matreska
c           nc-th comp.is matreska,  search
c           if posw, is inside  matreska
c              posw in w.c
            call epsInside(posw, nc, nco)

c                       nco =0 means there is no matreska to contain
c                       pos
            if(nco .eq. 0) goto 300
c                 nco-th comp. contains pos, see if more matreska
            nc = nco
         enddo
      endif
 300  continue
      end

      subroutine epsall(ncx, pos, nc)
c          ncx=0--> pos is in w.c
c         else      in l.c of ncx.
      implicit none
#include  "ZepMaxdef.h"
#include  "ZepPos.h"
#include  "Zep3Vec.h"
#include  "Zcnfig.h"

      record /epPos/ pos
      integer  ncx, nc
      integer i, icon, jcon
      record /epPos/ posw, posl

c        assume  we may search only box or sphere_w
c        which is uncontained first.

      if(ncx .eq. 0)  then
         posw = pos
      else
c             search firstly  ncx-comp for which no conversion is
c             needed.
c             pos is in ncx-th comp.
         call epsOne(ncx, pos, icon)

         if(icon .eq. 0) then
c              yes, so examine matreska
            call epsMatreska(ncx, pos, nc)
c/////////////////
c            call debugpos('epspos2cn matreska', ncx, pos, nc)
c//////////////////
c              if not matreska, nc=ncx. if pos in inner comp.
c              nc becomes the inner most one.
            if(ncx .ne. nc) then
               call epl2w(ncx, pos, posw)
               call epw2l(nc,  posw, posl)
            else
               posl = pos
            endif
c            call epsPCont(nc, pos, jcon)
            call epsPCont(nc, posl, jcon)
c /////////////
c            call debugpos('epspos2cn epsPCont',nc,pos,jcon)
c/////////////////
            if(jcon .ne. 0) then
c               nc is  partially contained by other comp.
c               but  pos is not in that part. i.e., outside
               call epl2w(ncx, pos, posw)
               goto 5
            endif
            goto 10
         else
c                prepare to search in other comp. covert
c                pos into posw
            call epl2w(ncx, pos, posw)
         endif
      endif
 5    continue
c                 -----------------
c       search other comp.  for the fast search, 
c       first examine uncontained component  only.
!!!!!!! v9.14 except for small detectors consisting of same
!             area, only the world is uncontained, so
!             we may search from the last one
!      do i = ncx+1,  Det.nct
      do i =  Det.nct, 1, -1
c         if( (Det.cmp(i).struc(1:3) .eq. 'box'  .or.
c     *        Det.cmp(i).struc .eq. 'sphere_w')  
c     *     .and.
c     *        Det.cmp(i).NContainer .eq. 0) then
         !!!!!!!!v9.14 only world is with NContainer= 0
         !!!! so skip non-world comp. 
         if( i < Det.nct .and. Det.nworld == 1 ) then
            nc= Det.nct+1
            goto 10
         endif
         !!!!!!!!
         if(Det.cmp(i).NContainer .eq. 0) then
            call epw2l(i, posw, posl)
            call epsOne(i, posl, icon)
c///////////////
c            call debugpos('eppos2cn;epsOne', i, posl,icon)
c//////////////////
            if(icon .eq.  0) then
               call epsMatreska(i, posl, nc)
c///////////////
c             call debugpos('eppos2cn;epsOne;matre', i, posl,icon)
c//////////////////
               if(nc .ne. i) then
                  call epw2l(nc, posw, posl)
               endif
               call epsPCont(nc, posl, jcon)
c///////////////
c            call debugpos('eppos2cn;epsOne;PCont', nc, posl,jcon)
c//////////////////
               if(jcon .ne. 0) then
                  nc = Det.nct + 1
               endif
               goto 10
            endif
         endif
      enddo
!      do i = ncx -1, 1, -1
!c         if( (Det.cmp(i).struc(1:3) .eq. 'box'  .or.
!c     *        Det.cmp(i).struc .eq. 'sphere_w')  
!c     *     .and.
!c     *        Det.cmp(i).NContainer .eq. 0) then
!         if(Det.cmp(i).NContainer .eq. 0) then
!
!            call epw2l(i, posw, posl)
!            call epsOne(i, posl, icon)
!c///////////////
!c            call debugpos('eppos2cn;epsOne;inv', i, posl,icon)
!c//////////////////
!
!            if(icon .eq. 0) then
!               call epsMatreska(i, posl, nc)
!c///////////////
!c            call debugpos('eppos2cn;matre;inv', i, posl,nc)
!c//////////////////
!
!               if(i .ne. nc) then
!                  call epw2l(nc, posw, posl)
!               endif
!               call epsPCont(nc, posl, jcon)
!c///////////////
!c            call debugpos('eppos2cn;mPCont;inv', nc, posl, jcon) 
!c//////////////////
!
!               if(jcon .ne. 0) then
!                  nc = Det.nct + 1
!               endif
!               goto 10
!            endif
!         endif
!      enddo
      nc= Det.nct+1

 10   continue
      end
c     ***************************************
      subroutine epsbox(ncx, aTrack, nc)
      implicit none
c          find  component # of position pos which is
c          in or near ncx-th component. 
c          if ncx =0, xx is world coord.
c          else ncx-local coord.
#include  "ZepTrackv.h"
#include  "Zcnfig.h"

      record /epTrack/ aTrack
      record /epPos/ pos
      integer ncx, nc

c
      pos = aTrack.pos
      if(ncx .le. 0) then
         call epsbxa(pos, nc)
      elseif(ncx .le. Det.nct) then
         if(0.d0 .le. pos.z      .and.
     *        pos.z .le. Volat( Det.cmp(ncx).vol + boxc)) then
            if(0.d0 .le. pos.x .and.
     *           pos.x .le. Volat( Det.cmp(ncx).vol + boxa) ) then
               if(0.d0 .le. pos.y .and.
     *              pos.y .le. Volat( Det.cmp(ncx).vol + boxb)) then
                  nc=ncx
               else
                  nc=Det.nct+1
               endif
            else
               nc=Det.nct+1
            endif
         else
            if(aTrack.w.z .gt. 0.) then
               call epsbxu(ncx, pos, nc)
            else
               call epsbxd(ncx, pos, nc)
            endif
         endif
      else
         nc=Det.nct+1
      endif
      end
!!c      *****************
!!      subroutine epscyl(ncx, aTrack, nc)
!!      implicit none
!!#include  "ZepTrackv.h"
!!#include  "Zcnfig.h"
!!
!!      record /epTrack/ aTrack
!!      record /epPos/ pos
!!      integer ncx, nc
!!      record /epPos/ post
!!
!!c            ncx=0 --> pos is w.c
!!c               else ncx-local
!!      post = aTrack.pos
!!
!!      if(ncx .le. 0) then
!!         call epscya(post, nc)
!!      elseif(ncx .le. Det.nct) then
!!C&&&&&&&
!!         call epv2c_cyl(Det.cmp(ncx), post, pos)
!!c&&&&&
!!         if(0.d0 .le. pos.z      .and.
!!     *        pos.z .le. Volat( Det.cmp(ncx).vol + cylh)) then
!!            if(pos.x**2 + pos.y**2 .le.
!!     *           Volat( Det.cmp(ncx).vol + cylr)**2) then
!!               nc=ncx
!!            else
!!               nc = Det.nct+1
!!            endif
!!         else
!!            if(aTrack.w.z .gt. 0.) then
!!               call epscyu(ncx, pos, nc)
!!            else
!!               call epscyd(ncx, pos, nc)
!!            endif
!!         endif
!!      else
!!         nc = Det.nct+1
!!      endif
!!      end
c ******************************* search only ncx-th cyl
      subroutine epscyl1(ncx, posi, icon)
        implicit none
#include "ZepTrackv.h"
#include "Zcnfig.h"

        record /epPos/ posi
        integer ncx, icon
!    &&&&&&&&&&
        record /epPos/ pos


c          pos in local-c.
c  &&&&         convert to canonial one
        call epv2c_cyl(Det.cmp(ncx), posi, pos)
c  &&&&&&
        if(0.d0 .le. pos.z      .and.
     *       pos.z .le. Volat( Det.cmp(ncx).vol + cylh)) then
           if(pos.x**2 + pos.y**2 .le.
     *          Volat( Det.cmp(ncx).vol + cylr)**2) then
              icon  =0
           else
              icon = 1
           endif
        else
           icon = 1
        endif
        end
!!c ****************************
!!       subroutine epspip(ncx, aTrack, nc)
!!       implicit none
!!#include "ZepTrackv.h"
!!#include "Zcnfig.h"
!!
!!       record /epTrack/ aTrack
!!       integer ncx,  nc
!!        
!!       real*8 temp
!!       record /epPos/ pos
!!c          ncx =0  --> xx in w.c
!!c           else     in l.c
!!
!!       pos = aTrack.pos
!!
!!       if(ncx .le. 0) then
!!          call epspipa(pos, nc)
!!       elseif(ncx .le. Det.nct) then
!!          if(0.d0 .le. pos.z      .and.
!!     *         pos.z .le. Volat( Det.cmp(ncx).vol + pipeh)) then
!!             temp = pos.x**2 + pos.y**2 
!!             if( temp .le. Volat( Det.cmp(ncx).vol + pipeor)**2 .and.
!!     *          temp .ge. Volat( Det.cmp(ncx).vol + pipeir)**2 ) then
!!                nc=ncx
!!             else
!!                nc = Det.nct+1
!!             endif
!!          else
!!             if(aTrack.w.z .gt. 0.) then
!!                call epspipu(ncx, pos, nc)
!!             else
!!                call epspipd(ncx, pos, nc)
!!             endif
!!          endif
!!       else
!!          nc = Det.nct+1
!!       endif
!!       end
       subroutine epsbxu(ncx, pos, nc)
       implicit none
c              search upward  when form=box
c       xx, yy, zz is assumed to be in ncx-local
c
#include  "ZepTrackv.h"
#include  "Zcnfig.h"
          
       integer ncx, nc
       record /epPos/ pos
       
       integer i
       record /epPos/ posw      ! world coord.
       record /epPos/ posl      !  local. coord.

       call epl2w(ncx, pos, posw)
       do   i=max(ncx-1,1), Det.nct
          if(i .eq. ncx) goto 100
          call epw2l(i, posw, posl)
          if(0.d0 .le. posl.z  .and.
     *         posl.z .le.  Volat( Det.cmp(i).vol + boxc)) then
             if(0.d0 .le. posl.x .and.
     *            posl.x .le.  Volat( Det.cmp(i).vol + boxa)) then
                if(0.d0 .le. posl.y .and.
     *               posl.y .le. Volat( Det.cmp(i).vol + boxb)) then
                   nc=i
                   goto 101
                else
                   nc = Det.nct+1
                   goto 101
                endif
             else
                nc = Det.nct+1
                goto 101
             endif
          elseif(0.d0 .gt. posl.z) then
             nc = Det.nct+1
             goto 101
          endif
 100      continue
       enddo
       nc= Det.nct+1
 101   continue
       end 
c
c       ************
        subroutine epsbxd(ncx, pos, nc)
c       ************
       implicit none
c              search upward  when form=box
c       xx, yy, zz is assumed to be in ncx-local
c
#include  "ZepMaxdef.h"
#include  "ZepPos.h"
#include  "Zep3Vec.h"
#include  "Zcnfig.h"
          
           integer ncx, nc
           record /epPos/ pos

           integer i
           record /epPos/ posw ! world coord.
           record /epPos/ posl !  local. coord.

c             search downword
        call epl2w(ncx, pos, posw)
        do   i=min(ncx+1,Det.nct), 1, -1
           if(i .eq. ncx) goto 200
           call epw2l(i, posw, posl)
           if(0.d0 .le. posl.z  .and.
     *          posl.z .le.  Volat( Det.cmp(i).vol + boxc)) then
              if(0.d0 .le. posl.x .and.
     *             posl.x .le. Volat( Det.cmp(i).vol + boxa))  then
                 if(0.d0 .le. posl.y .and.
     *                posl.y .le. Volat( Det.cmp(i).vol + boxb))then
                    nc=i
                    goto 201
                 else
                    nc = Det.nct+1
                    goto 201
                 endif
              else
                 nc = Det.nct+1
                 goto 201
              endif
           elseif(0.d0 .lt. posl.z) then
              nc = Det.nct+1
              goto 201
           endif
 200       continue 
        enddo
        nc = Det.nct+1
 201    continue
       end
!!       subroutine epscyu(ncx, pos, nc)
!!c            pos in l.c
!!       implicit none
!!#include  "ZepTrackv.h"
!!#include  "Zcnfig.h"
!!       record /epPos/ pos
!!       integer ncx, nc
!!       record /epPos/ posw, posl
!!       integer i
!!
!!       call epl2w(ncx, pos, posw)
!!       do   i=ncx+1, Det.nct
!!          call epw2l(i, posw, posl)
!!          if(0.d0 .le. posl.z  .and.
!!     *         posl.z .le.  Volat( Det.cmp(i).vol + cylh)) then
!!             if(posl.x**2 + posl.y**2 
!!     *            .le. Volat( Det.cmp(i).vol + cylr)**2)   then
!!                nc=i
!!                goto 101
!!             else
!!                nc = Det.nct+1
!!                goto 101
!!             endif
!!          endif
!!       enddo
!!       nc = Det.nct+1
!! 101   continue
!!       end
c
!!c       ************
!!      subroutine epscyd(ncx, pos, nc)
!!c       ************
!!c            pos in l.c
!!       implicit none
!!#include  "ZepTrackv.h"
!!#include  "Zcnfig.h"
!!       record /epPos/ pos
!!       integer ncx, nc
!!       record /epPos/ posw, posl
!!       integer i
!!
!!c             search downward
!!        call epl2w(ncx, pos, posw)
!!        do   i=ncx-1, 1, -1
!!           call epw2l(i, posw, posl)
!!           if(0.d0 .le. posl.z  .and.
!!     *              posl.z .le.  Volat( Det.cmp(i).vol + cylh)) then
!!              if(posl.x**2 + posl.y**2 
!!     *          .le. Volat( Det.cmp(i).vol + cylr)**2)  then
!!                 nc=i
!!                 goto 201
!!              else
!!                 nc = Det.nct+1
!!                 goto 201
!!              endif
!!           endif
!!        enddo
!!        nc = Det.nct+1
!! 201    continue
!!       end
!!!      ***********************************
!!       subroutine epspipu(ncx, pos, nc)
!!c         pos in l.c
!!       implicit none
!!#include  "ZepTrackv.h"
!!#include  "Zcnfig.h"
!!       record /epPos/pos
!!       integer ncx, nc
!!       real*8 temp
!!       integer i
!!       record /epPos/ posw, posl
!!       
!!       call epl2w(ncx, pos, posw)
!!       do   i=ncx+1, Det.nct
!!          call epw2l(i, posw, posl)
!!          if(0.d0 .le. posl.z  .and.
!!     *        posl.z .le.  Volat( Det.cmp(i).vol + pipeh)) then
!!             temp = posl.x**2 +  posl.y**2
!!             if(temp .le. Volat( Det.cmp(i).vol + pipeor)**2 .and.
!!     *            temp .ge. Volat( Det.cmp(i).vol + pipeir)**2  )   then
!!                nc=i
!!                goto 101
!!             else
!!                nc = Det.nct+1
!!                goto 101
!!             endif
!!          endif
!!       enddo
!!       nc = Det.nct+1
!! 101   continue
!!       end
!!c
!!c      ************
!!       subroutine  epspipd(ncx, pos, nc)
!!c      ************
!!       implicit none
!!#include  "ZepTrackv.h"
!!#include  "Zcnfig.h"
!!       record /epPos/pos
!!       integer ncx, nc
!!       real*8 temp
!!       integer i
!!       record /epPos/ posw, posl
!!
!!
!!c             search downward
!!        call epl2w(ncx, pos, posw)
!!        do   i=ncx-1, 1, -1
!!           call epw2l(i, posw, posl)
!!           if(0.d0 .le. posl.z  .and.
!!     *          posl.z .le. Volat( Det.cmp(i).vol + pipeh)) then
!!              temp = posl.x**2 + posl.y**2 
!!              if( temp .le. Volat( Det.cmp(i).vol + pipeor)**2 .and.
!!     *            temp .ge. Volat( Det.cmp(i).vol + pipeir)**2)  then
!!                 nc=i
!!                 goto 201
!!              else
!!                 nc =  Det.nct+1
!!                 goto 201
!!              endif
!!           endif
!!        enddo
!!        nc = Det.nct+1
!! 201    continue
!!       end
c      ********************************
       subroutine  epspipa(pos, nc)
c      ********************************
       implicit none
#include  "ZepTrackv.h"
#include  "Zcnfig.h"
       record /epPos/pos
       integer nc
       real*8 temp
       integer i
       record /epPos/ posl, post

c             search all
       do   i=1, Det.nct
          call epw2l(i, pos, post)
c&&&&&
          call epv2c_pipe(Det.cmp(i), post, posl)
c&&&&&

          if(0.d0 .le. posl.z  .and. 
     *        posl.z .le. Volat( Det.cmp(i).vol + pipeh)) then
             temp = posl.x**2 + posl.y**2 
             if(temp .le. Volat( Det.cmp(i).vol + pipeor)**2 .and.
     *          temp .ge. Volat( Det.cmp(i).vol + pipeir)**2) then       
                nc=i
                goto 301
             endif
          endif
       enddo
       nc =  Det.nct+1
 301   continue
       end
       subroutine epsbxa(pos, nc)
       implicit none
c              search all component( the same a, b assumed)
c              pos is in the world coord.
c       ************
#include  "ZepTrackv.h"
#include  "Zcnfig.h"
       record/epPos/ pos
       integer nc
       
       record /epPos/ posl        
       integer i


c       search all
       do   i=1, Det.nct
          call epw2l(i, pos, posl)
          if(0.d0 .le. posl.z  .and.
     *         Volat( Det.cmp(i).vol + boxc) .ge. posl.z) then
             if(0.d0 .le. posl.x .and.
     *            Volat( Det.cmp(i).vol + boxa).ge. posl.x) then
                if(0.d0 .le. posl.y .and.
     *               Volat( Det.cmp(i).vol + boxb) .ge. posl.y) then
                   nc=i
                   goto 301
                else
                   nc = Det.nct+1
                   goto 301
                endif
             else
                nc = Det.nct+1
                goto 301
             endif
          endif
       enddo
       nc = Det.nct+1
 301   continue
       end
       subroutine epscya(pos, nc)
c             pos is in w.c
       implicit none
c       ************
#include  "ZepTrackv.h"
#include  "Zcnfig.h"
       record /epPos/ pos
       integer nc
       record /epPos/ posl, post
       integer i

c             search all
       do   i=1, Det.nct
          call epw2l(i, pos, post)
c&&&&&
          call epv2c_cyl(Det.cmp(i), post, posl)
c&&&&&
          if(0.d0 .le. posl.z  .and. 
     *         Volat( Det.cmp(i).vol + cylh) .ge. posl.z) then
             if( posl.x**2 + posl.y**2 .le.
     *            Volat( Det.cmp(i).vol + cylr)**2)  then
                nc=i
                goto 301
             else
                nc =  Det.nct+1
                goto 301
             endif
          endif
       enddo
       nc = Det.nct+1
 301   continue
       end
       subroutine epspip1(ncx, posi, icon)
c         search only ncx-th pipe
c         xx .. is assumed to be in local coord.
       implicit none
c       ************
#include  "ZepTrackv.h"
#include  "Zcnfig.h"
       record /epPos/ posi
       integer  icon, ncx
       real*8 temp

       record /epPos/ pos

c  &&&&         convert to canonial one
        call epv2c_pipe(Det.cmp(ncx), posi, pos)
c  &&&&&&


       if(0.d0 .le. pos.z  .and. 
     *         Volat( Det.cmp(ncx).vol + pipeh) .ge. pos.z) then
          temp = pos.x**2 + pos.y**2
          if(temp .le. Volat( Det.cmp(ncx).vol + pipeor)**2 .and.
     *       temp .ge. Volat( Det.cmp(ncx).vol + pipeir)**2)  then
             icon = 0
          else
             icon = 1
          endif
       else
          icon = 1
       endif
       end
       subroutine epssbox(ncx, pos, icon)
c          search specified box
c          Is pos in ncx-th comp.  ? if yes, icon=0 else
c          icon = 1
c          pos is assumed to be in Local coord.
       implicit none
#include  "ZepTrackv.h"
#include  "Zcnfig.h"
           record /epPos/ pos
           integer ncx,  icon
        

           if(0.d0 .le. pos.z  .and. 
     *        pos.z .le. Volat( Det.cmp(ncx).vol + boxc)) then
              if(0.d0 .le. pos.x .and.
     *             pos.x .le. Volat( Det.cmp(ncx).vol + boxa)) then
                 if(0.d0 .le. pos.y .and.
     *                pos.y .le. Volat( Det.cmp(ncx).vol + boxb)) then
                    icon  =0
                    goto 101
                 endif
              endif
           endif
           icon = 1
 101       continue
       end
       subroutine epsssph(ncx, pos, icon)
c          search specified sphere
c         Is  pos in ncx-th comp.  ? if yes, icon=0 else
c               icon = 1
c         pos is assumed to be Local coord.
       implicit none
#include  "ZepTrackv.h"
#include  "Zcnfig.h"
           record /epPos/ pos
           integer ncx,  icon

           if( pos.x**2 + pos.y**2 + pos.z**2  .le.
     *         Volat( Det.cmp(ncx).vol + sphr)**2) then
              icon  = 0
           else
              icon = 1
           endif
       end
       subroutine epw2l(ncx, pos, poso)
c        world to local conversion
      implicit none
#include  "ZepTrackv.h"
#include  "Zcnfig.h"

      record /epPos/ pos    ! input
      record /epPos/ poso    ! output. poso can be pos
      record /epPos/ temp
      integer ncx
      if(ncx > Det.nct) then
         poso = pos
         return !**********
      endif

      poso.x = pos.x - Det.cmp(ncx).orgx
      poso.y = pos.y - Det.cmp(ncx).orgy
      poso.z = pos.z - Det.cmp(ncx).orgz
 
      if(Det.cmp(ncx).rotation) then
         temp.x = Det.cmp(ncx).direc(1) * poso.x +
     *      Det.cmp(ncx).direc(2) * poso.y +
     *      Det.cmp(ncx).direc(3) * poso.z


         temp.y = Det.cmp(ncx).direc(4) * poso.x +
     *      Det.cmp(ncx).direc(5) * poso.y +
     *      Det.cmp(ncx).direc(6) * poso.z

         temp.z = Det.cmp(ncx).direc(7) * poso.x +
     *      Det.cmp(ncx).direc(8) * poso.y +
     *      Det.cmp(ncx).direc(9) * poso.z
         poso = temp
      endif

      end
      subroutine epl2w(ncx, pos, poso)
c         local to world conversion
      implicit none
#include  "ZepTrackv.h"
#include  "Zcnfig.h"
      record /epPos/ pos ! input
      record /epPos/ poso ! output, poso can be pos

      integer ncx
      record /epPos/ temp

      if(Det.cmp(ncx).rotation) then
         temp.x = Det.cmp(ncx).direc(1) * pos.x +
     *      Det.cmp(ncx).direc(4) * pos.y +
     *      Det.cmp(ncx).direc(7) * pos.z 


         temp.y = Det.cmp(ncx).direc(2) * pos.x +
     *      Det.cmp(ncx).direc(5) * pos.y +
     *      Det.cmp(ncx).direc(8) * pos.z

         temp.z = Det.cmp(ncx).direc(3) * pos.x +
     *      Det.cmp(ncx).direc(6) * pos.y +
     *      Det.cmp(ncx).direc(9) * pos.z

         poso.x = temp.x + Det.cmp(ncx).orgx
         poso.y = temp.y + Det.cmp(ncx).orgy
         poso.z = temp.z + Det.cmp(ncx).orgz
      else
         poso.x = pos.x + Det.cmp(ncx).orgx
         poso.y = pos.y + Det.cmp(ncx).orgy
         poso.z = pos.z + Det.cmp(ncx).orgz
      endif


      end
      subroutine epw2ld(ncx, pos, poso)
c        world to local conversion for direction cos.
c        also you can use this vector direction such as B, E
c        field.
      implicit none
#include  "ZepTrackv.h"
#include  "Zcnfig.h"
      record /epDirec/ pos ! input
      record /epDirec/ poso ! output. poso can be pos

      integer ncx
 
      record /epDirec/ temp
      if(ncx > Det.nct) then
         poso = pos
         return   !*********
      endif
      if(Det.cmp(ncx).rotation) then
         temp.x = Det.cmp(ncx).direc(1) * pos.x +
     *      Det.cmp(ncx).direc(2) * pos.y +
     *      Det.cmp(ncx).direc(3) * pos.z


         temp.y = Det.cmp(ncx).direc(4) * pos.x +
     *      Det.cmp(ncx).direc(5) * pos.y +
     *      Det.cmp(ncx).direc(6) * pos.z

         temp.z = Det.cmp(ncx).direc(7) * pos.x +
     *      Det.cmp(ncx).direc(8) * pos.y +
     *      Det.cmp(ncx).direc(9) * pos.z

         poso = temp
      else
         poso = pos
      endif


      end
      subroutine epw2ldm(ncx, pos, poso, pinout)
c        world to local conversion for direction cos and
c        momentum
      implicit none
#include  "ZepTrackv.h"
#include  "Zcnfig.h"
      record /epDirec/ pos ! input
      record /epDirec/ poso ! output. poso can be pos
      record /ptcl/ pinout ! in/out ptcl info.
      integer ncx
      real*8 pabs
      record /epDirec/ temp

      if( ncx > Det.nct ) then
         poso = pos
         return  !*********
      endif
      if(Det.cmp(ncx).rotation) then
         temp.x = Det.cmp(ncx).direc(1) * pos.x +
     *      Det.cmp(ncx).direc(2) * pos.y +
     *      Det.cmp(ncx).direc(3) * pos.z


         temp.y = Det.cmp(ncx).direc(4) * pos.x +
     *      Det.cmp(ncx).direc(5) * pos.y +
     *      Det.cmp(ncx).direc(6) * pos.z

         temp.z = Det.cmp(ncx).direc(7) * pos.x +
     *      Det.cmp(ncx).direc(8) * pos.y +
     *      Det.cmp(ncx).direc(9) * pos.z
         poso = temp
         pabs = sqrt(pinout.fm.p(1)**2 +pinout.fm.p(2)**2
     *          + pinout.fm.p(3)**2)
         pinout.fm.p(1) = pabs*temp.x
         pinout.fm.p(2) = pabs*temp.y
         pinout.fm.p(3) = pabs*temp.z
      else
         poso = pos
      endif


      end
      subroutine epl2wd(ncx, pos, poso)
c         local to world conversion for direction cos
      implicit none
#include  "ZepTrackv.h"
#include  "Zcnfig.h"
      record /epDirec/ pos ! input
      record /epDirec/ poso ! output. poso can be pos

      integer ncx
      record /epDirec/ temp

      if(Det.cmp(ncx).rotation) then
         temp.x = Det.cmp(ncx).direc(1) * pos.x +
     *      Det.cmp(ncx).direc(4) * pos.y +
     *      Det.cmp(ncx).direc(7) * pos.z 


         temp.y = Det.cmp(ncx).direc(2) * pos.x +
     *      Det.cmp(ncx).direc(5) * pos.y +
     *      Det.cmp(ncx).direc(8) * pos.z

         temp.z = Det.cmp(ncx).direc(3) * pos.x +
     *      Det.cmp(ncx).direc(6) * pos.y +
     *      Det.cmp(ncx).direc(9) * pos.z
         poso = temp
      else
         poso = pos
      endif


      end
      subroutine epl2wdm(ncx, pos, poso, pinout)
c         local to world conversion for direction cos
c          and momentum
      implicit none
#include  "ZepTrackv.h"
#include  "Zcnfig.h"
      record /epDirec/ pos ! input
      record /epDirec/ poso ! output. poso can be pos
      record /ptcl/  pinout !  for momentum part are affected

      integer ncx
      record /epDirec/ temp
      real*8 pabs

      if(Det.cmp(ncx).rotation) then
         temp.x = Det.cmp(ncx).direc(1) * pos.x +
     *      Det.cmp(ncx).direc(4) * pos.y +
     *      Det.cmp(ncx).direc(7) * pos.z 

         temp.y = Det.cmp(ncx).direc(2) * pos.x +
     *      Det.cmp(ncx).direc(5) * pos.y +
     *      Det.cmp(ncx).direc(8) * pos.z

         temp.z = Det.cmp(ncx).direc(3) * pos.x +
     *      Det.cmp(ncx).direc(6) * pos.y +
     *      Det.cmp(ncx).direc(9) * pos.z
         poso = temp
         pabs = sqrt( pinout.fm.p(1)**2 + pinout.fm.p(2)**2
     *               + pinout.fm.p(3)**2 )
         pinout.fm.p(1) = pabs*temp.x
         pinout.fm.p(2) = pabs*temp.y
         pinout.fm.p(3) = pabs*temp.z
      else
         poso = pos
      endif
      end

      subroutine epv2c_cyl(comp, posv, posc)
      implicit none
#include "Zep3Vec.h"
#include  "Zcnfig.h"
#include  "ZepPos.h"
      record /epPos/ posv ! input
      record /epPos/ posc ! output. 
      record /Component/ comp
      if( comp.struc == "cyl_x") then
         posc = epPos( posv.z, posv.y, posv.x)
      elseif(comp.struc == "cyl_y") then
         posc = epPos( posv.x, posv.z, posv.y)
      else
         posc = posv
      endif
      end
      subroutine epc2v_cyl(comp, posc, posv)
      implicit none
#include "Zep3Vec.h"
#include  "Zcnfig.h"
#include  "ZepPos.h"
      record /epPos/ posc ! input
      record /epPos/ posv ! output. 
      record /Component/ comp
      if( comp.struc == "cyl_x") then
         posv = epPos( posc.z, posc.y, posc.x)
      elseif(comp.struc == "cyl_y") then
         posv = epPos( posc.x, posc.z, posc.y)
      else
         posc = posv
      endif
      end
      subroutine epv2cd_cyl(comp, dirv, dirc)
      implicit none
#include "Zep3Vec.h"
#include  "Zcnfig.h"
#include  "ZepPos.h"
      record /epPos/ dirv ! input
      record /epPos/ dirc ! output. 
      record /Component/ comp
      if( comp.struc == "cyl_x") then
         dirc = epPos( dirv.z, dirv.y, dirv.x)
      elseif(comp.struc == "cyl_y") then
         dirc = epPos( dirv.x, dirv.z, dirv.y)
      else
         dirc = dirv
      endif
      end
      subroutine epc2vd_cyl(comp, dirc, dirv)
      implicit none
#include "Zep3Vec.h"
#include  "Zcnfig.h"
#include  "ZepPos.h"
      record /epPos/ dirc ! input
      record /epPos/ dirv ! output. 
      record /Component/ comp
      if( comp.struc == "cyl_x") then
         dirv = epPos( dirc.z, dirc.y, dirc.x)
      elseif(comp.struc == "cyl_y") then
         dirv = epPos( dirc.x, dirc.z, dirc.y)
      else
         dirv = dirc
      endif
      end

      subroutine epv2c_pipe(comp, posv, posc)
!           variant local to canonical local; used when
!           manipulating things in canonical local
!          (for boundary search etc).  system normally recognizes
!           variant local as usual local 
      implicit none
#include "Zep3Vec.h"
#include  "Zcnfig.h"
#include  "ZepPos.h"
      record /epPos/ posv ! input
      record /epPos/ posc ! output. 
      record /Component/ comp
      if( comp.struc == "pipe_x") then
         posc = epPos( posv.z, posv.y, posv.x)
      elseif(comp.struc == "pipe_y") then
         posc = epPos( posv.x, posv.z, posv.y)
      else
         posc = posv
      endif
      end
      subroutine epc2v_pipe(comp, posc, posv)
      implicit none
#include "Zep3Vec.h"
#include  "Zcnfig.h"
#include  "ZepPos.h"
      record /epPos/ posc ! input
      record /epPos/ posv ! output. 
      record /Component/ comp
      if( comp.struc == "pipe_x") then
         posv = epPos( posc.z, posc.y, posc.x)
      elseif(comp.struc == "pipe_y") then
         posv = epPos( posc.x, posc.z, posc.y)
      else
         posc = posv
      endif
      end
      subroutine epv2cd_pipe(comp, dirv, dirc)
      implicit none
#include "Zep3Vec.h"
#include  "Zcnfig.h"
#include  "ZepPos.h"
      record /epPos/ dirv ! input
      record /epPos/ dirc ! output. 
      record /Component/ comp
      if( comp.struc == "pipe_x") then
         dirc = epPos( dirv.z, dirv.y, dirv.x)
      elseif(comp.struc == "pipe_y") then
         dirc = epPos( dirv.x, dirv.z, dirv.y)
      else
         dirc = dirv
      endif
      end
      subroutine epc2vd_pipe(comp, dirc, dirv)
      implicit none
#include "Zep3Vec.h"
#include  "Zcnfig.h"
#include  "ZepPos.h"
      record /epPos/ dirc ! input
      record /epPos/ dirv ! output. 
      record /Component/ comp
      if( comp.struc == "pipe_x") then
         dirv = epPos( dirc.z, dirc.y, dirc.x)
      elseif(comp.struc == "pipe_y") then
         dirv = epPos( dirc.x, dirc.z, dirc.y)
      else
         dirv = dirc
      endif
      end
