module modUI
  real(4),save,allocatable::ElossE(:)
  real(4),save,allocatable::ElossT(:)
end module modUI

!  these are intentinally not contained in modUI (to keep user 
!  program unchaged)
  subroutine epAlloc(compno)
    use modUI
    implicit none
    integer,intent(in):: compno  ! total number of components
    allocate(ElossE(compno))  ! effective loss for light emission
    allocate(ElossT(compno))  ! true  loss for
  end subroutine epAlloc
  subroutine epqEloss(i, dET, dEeff)
    use modUI
    implicit none
    integer,intent(in)::i  ! comp. no
    real(4),intent(out)::dET  ! total energy deposit in that comp
    real(4),intent(out)::dEeff  ! effective dE with quenching
                         ! if comp. is not specified with d /=0, 
                         ! output will be 0.

    dET = ElossT(i)
    dEeff = ElossE(i)
  end subroutine epqEloss

! clear Eloss counter
  subroutine epcEloss
    use modUI
    implicit none
    
    ElossT(:) = 0.
    ElossE(:) = 0.
  end subroutine epcEloss

