c      implicit none
c      real*8 x
c      integer i, m,n
c      call cerrorMsg('Enter m, n', 1)
c      read(*, *) m, n
c      do i = 1, 100000
c         call ksmpintbeta(m, n, x)
c         write(*, *) sngl(x)
c      enddo
c      end

      subroutine ksmpintbeta(m, n, x)
      implicit none
c         samples random variable x of which density is
c          x**m * (1-x)** n dx 
c      where m >= 0 and n>=0 are integers.
c
c        This can be sampled generating n+m+1 uniform 
c     random variables in 0~1 and take the n+1-th largest one
c
      integer m  ! input. >=0
      integer n  ! input. >=0.  m+n must be =< 100
      real*8 x   ! output. sampled variable
c
      integer maxsize
      parameter (maxsize=100)
      real*8 ua(maxsize), u
      integer i

      if( m+n .gt. maxsize) then
         write(*,*)' ksmpintbeta:  too large m+n; m=',m, ' n=',n
         stop 9999
      endif
      if(m .lt. 0  .or.  n .lt. 0) then
         write(*, *) 
     *   ' ksmpintbeta: too small m or n; m=',m, ' n=',n
         stop 9999
      endif
      do i = 1, m+n+1
         call rndc(u)
         ua(i) = u
      enddo
c           sort
      call kcsr1(ua, m+n+1, 'd')
      x = ua(n+1)
      end

      
