c      mugeo0: init for coord. transformation
c      muptos: 1ry to *
c      muroc0: init. rock profile
c      murock: compute path length for given zenith and fai in rock
c      muradl: compute r.l of rock or other whose z, z'**2/a are given
c           rndc    !  not included
c           kmover  !
c           kcossn  !
c           kgauss  !subroutines to be imported from kklib
c           k4ptdi  !
c           kmover  !
c     ****************************************************************
c     *                                                              *
c     * mugeo0: initialize routine for computing geomagnetic field   *
c     *         effect (give gmf constants and 1ry direction)        *
c     *                                                              *
c     * muptos: 1ry to * system conversion                           *
c     *                                                              *
c     ************************ tested 90.02.23 ***********************
c
c  /usage/   call mugeo0(bh, bv, w01,  w02, w03, t)
c                 this must be called when the 1ry direction is fixed
c coordinate system:
c
c          let y* be geomagnetic north
c              x*                west
c              z* vertical axis going downwards
c
c      then  gmf is // to y*-z* plane
c
c          let the unit vector of 1ry paticle be z#=(w01, w02, w03) in
c          * system.  ( # is for vector)
c          form x axis by  b# x z#  where b# is the vector of gmf so
c          that  x# = b# x z# / ! b# x z# ! (if b#//z#, x should be
c          x* ).    y axis is on b#-z# plane, i.e y# = z# x x#.
c          the angle between b# and z# is alfa.   gmf effect is
c          computed easily in the frame where x axis is rotated
c          so that z axis coincide with b#.    then the deflection etc
c          is transformed to (x,y,z) system where coordinate of ptcls
c          are measured.
c
c
c  *** mugeo0 ***
c
c -- input --
c     bh:  horizontal component of gmf             (gauss)
c     bv:  vertical   //               (may be < 0)  //
c    w01:  1ry ptcle direction cosine to x* axis
c    w02:  1ry ptcle direction cosine to y* axis
c    w03:  1ry ptcle direction cosine to z* axis
c
c -- output --
cc     t:  transformaton matrix t(3,3).
c
c               x*    {t(1,1),t(1,2),t(1,3)}  x
c               y* =  {t(2,1),t(2,2),t(2,3)}  y
c               z*    {t(3,1),t(3,2),t(3,3)}  z
c
c
      subroutine mugeo0(bh, bv, w01, w02, w03, t)
c
      dimension t(3,3)
      data small /1.e-3/
      dimension tm(3,3)
c
c          mag. of gmf
      b=sqrt(bh**2 + bv**2)
c          cos(alfa)
      cosa=(bh * w02  +  bv * w03)/b
      cosa2=cosa**2
      sina=sqrt(1. - cosa2)
      bt=b * sina
      sb2= w01**2 + (bh/b-w02)**2 + (bv/b-w03)**2
      if(sb2 .gt. small) then
          cota=cosa/sina
          tm(1,1)= ( bh*w03 - bv*w02 ) /bt
          tm(1,2)= -cota*w01
          tm(1,3)= w01
          tm(2,1)= bv*w01/bt
          tm(2,2)= bh/bt - cota*w02
          tm(2,3)= w02
          tm(3,1)= -bh*w01/bt
          tm(3,2)= bv/bt - cota*w03
          tm(3,3)= w03
      else
          tm(1,1)= 1.
          tm(1,2)= 0.
          tm(1,3)= 0.
          tm(2,1)= 0.
          tm(2,2)=bv/b
          tm(2,3)=bh/b
          tm(3,1)=0.
          tm(3,2)= -bh/b
          tm(3,3)= bv/b
      endif
      call kmover(tm, 1, 9, t, 1)
      return
c
c       convert (x,y,z) in 1ry system into * system
c     ************
      entry muptos(x, y, z, xs, ys, zs)
c     ************
c
      tmp1= tm(1,1)*x + tm(1,2)*y + tm(1,3)*z
      tmp2= tm(2,1)*x + tm(2,2)*y + tm(2,3)*z
      zs  = tm(3,1)*x + tm(3,2)*y + tm(3,3)*z
      xs  = tmp1
      ys  = tmp2
      return
      end
cc        test muroc0; murock
cc
c        parameter (ipdb=99, pi=3.141592, Torad=pi/180.)
c        parameter (nr=61, ntet=360)
c        dimension dh(nr, ntet)
c        dimension tet(ntet), r(nr)
c        character*8  picnm
cc
cc       call muroc0('c2g5100.rock.data(kgf)', a, z, zba, z2ba,rho, bh,
cc   *   bv, beta)
cc       call muroc0('c2g5100.rock.data(frejus)', a, z, zba, z2ba,rho,
cc   *   bh, bv, beta)
c        dz=1.
c        da=1.
c        do 100 i=1, ntet
c            t=(i-1)*Torad
c            do 90 j=1, nr
c                 rt=(j-1)*Torad
c                 call murock(rt, t, dh(j, i) )
c  90        continue
c 100    continue
cc
cc         this is to draw  (length for given teta, fai)
c        call opnpdb('c2s5001.#pdb.data&', ipdb)
c                 do 30 i=1, ntet
c                    tet(i)=((i-1) )*Torad
c  30             continue
c                 do 40 i=1, nr
c                    r(i)=  (i-1)
c  40             continue
c                 picnm='frjtf'
c                 call newpic(picnm, 1,  'length&')
c                 call cont2c(nr, ntet, r, tet, dh, nr)
c                 call picend
c        call clspdb
c     end
c    ***********************************************************
c    *
c    * muroc0: init. for geometry of the detector position underground
c    * murock: comute path length of muon to reach the detector
c    *
c    ***********************************************************
c
c
c/usage/   call muroc0(dsn, a, z, zba, z2ba, rho, bh, bv, beta)
c          call murock(tet, fai, path)
c    dsn: input. dataset name which contatins path length table for
c                given teta and fai.
c                for the sturucter of the data, see
c                'c2g5100.rock.data(frejus)'.  or ..(kgf)
c     a,z,zba,z2ba,rho:  output. rho is in g/cm**2
c           bh, bv: output. geomagnetic strength in gauss. horizontal
c                           and vertical component.
c         beta: angle btween x* and detector direction (in deg).
c
c    tet: input. zenith angle (====in rad===)
c    fai: input. azimuthal angle (in rad).  azimuth is measured from
c                a fixed direction of the detector.
c   path: output. length from the surface of the earth to the detector
c                 in g/cm**2 for given tet, fai.
       subroutine muroc0(dsn, a, z, zba, z2ba, rho, bh, bv, beta)
         parameter (nzen=20, nazim=100)
         parameter (pi=3.141592, Torad=pi/180.)
         dimension dh(nzen, nazim), za(nzen), aa(nazim)
c
             character*(*) dsn
             data jflat/0/
             character*79 txt
c
             open(21, file=dsn, status='shr', action='read')
             write(*,*) ' rock profile is by ', dsn
             read(21,'(a)') txt
             write(*,'(a)') txt
c
             read(21,'(a)') txt
             write(*,'(a)') txt
             read(21,'(a)') txt
             write(*,'(a)') txt
             read(txt,*)  a, z, zba, z2ba, rho, bh, bv, beta
             rhoi=rho
c
             read(21,'(a)') txt
             l=index(txt, 'flat')
             if(l .gt. 0) then
                 read(txt(l+5:20), *) vdep
                 write(*,*) ' flat earth surface assumed ',
     *           ' vertical depth=',vdep,' hg/cm**2'
                 jflat=1
                 vdep=vdep*100.
             else
                 jflat=2
                 call ksetrv(za, 1, nzen, -1.)
                 read(21,*) za
                 call kfrge(za, 1, -nzen, 0., nzena, icon)
                 nazima=0
                  do   i=1, nazim
                     read(21, *, end=101) aa(i), (dh(j, i),j=1, nzena)
                      do   j=1, nzena
c                           convert dh into g/cm**2
                        dh(j,i)=dh(j,i)*100.*rhoi
                      enddo
                     nazima=nazima+1
                  enddo
  101            continue
                 dz=za(nzena)/(nzena-1)
                 da=360./nazima
                 write(*,*) ' zenith step=',dz, ' azimuth step=',da,
     *           ' # of zenith =',nzena, ' # of azimuth=',nazima
                 dz=dz*Torad
                 da=da*Torad
            endif
            close(21)
            return
c
       entry murocq(zmin, zmax)
            if(jflat .eq. 1) then
                zmin=vdep
                zmax=vdep/.5
            elseif(jflat .eq. 2) then
                 zmin=dh(1,1)
                 zmax=zmin
                  do   i=1, nazima
                     call kfmin(dh, 1, nzena, lmn)
                     call kfmax(dh, 1, nzena, lmx)
                     zmin=min(dh(lmn, i), zmin)
                     zmax=max(dh(lmx, i), zmax)
                  enddo
            endif
            return
c
       entry murock(tet, fai, path)
c
            if(jflat .eq. 2) then
c                     dh is now in g/cm**2
                call
     *          k4ptdi(dh, nzena, nazima, nzen,
     *          0., 0.,  dz, da,  tet, fai, path)
            elseif(jflat .eq. 1) then
                path=vdep/cos(tet)
            else
                write(*,*) ' muroc0 not yet called '
                stop
            endif
       end
c     ****************************************************************
c     *                                                              *
c     * muradl:  compute radiation length of given rock              *
c     *                                                              *
c     *********************** tested 90.03.01 ************************
c
c   /usage/
c            call kradl1(z, zba,  z2ba, x0g)
c
c    z:  <z> charge of the matter
c  zba:  <z/a>
c z2ba: <z**2/a>
c  x0g:  //                           g/cm**2
c
c
c     *** note ***
c
c         correction to born approximation is not included in this
c         r.l so it must be included in the cross-section.
c
c
c
      subroutine muradl(z, zba, z2ba, x0g)
c
c         cnst=
c         4/137* r0**2 * n  where r0 is the classical electron radius
c                           n the avogadro number
c                           r0=2.8176e-13 cm
c                           n=6.0247
c
      data  cnst/1.396e-3/
c
      z3=z**(-0.3333333)
      alogz3=log( 183.* z3 )
      gzai=log(1440. * z3**2 ) /  alogz3
c        inverse of r.l in g/cm**2
c     t0inv=cnst / a  *  z*( z + gzai ) * alogz3
      t0inv=cnst * (z2ba+zba*gzai) * alogz3
c
      x0g=1. / t0inv
      end
c      ***********************************************************
c      *
c      * kmover: move real*4 array to another array
c      *
c      ***********************************************************
c/usage/ call kmover(a, intv, n, b, intb)
c         a--->  b
c
       subroutine kmover(a, intv, n, b, intb)
c
          dimension a(intv, n), b(intb, n)
c
           do   i=1, n
              b(1, i)=a(1, i)
           enddo
       end
      subroutine kcossn(cs,sn)
c     to generate cos(phy),sin(phy), where phy is uniform in (0,2pi).
c     .........required subprogram...rndc ..............................
c      *** until loop*** 
      do while (.true.)
          call rndc(u)
          call rndc(v)
          v=v+v-1.
          a=u*u
          b=v*v
          c=a+b
      if         (c .le. 1.)
     *                   goto 10
      enddo
   10 continue
      cs=(a-b)/c
      sn=2.*u*v/c
      return
      end
c     ****************************************************************
c     *                                                              *
c     *   kgauss: generates 2 independent gaussian random variables  *
c     *                                                              *
c     ****************************************************************
c
c  /usage/
c                call kgauss(av, s, x1, x2)
c
c     av:  average of gaussian distribution
c      s:  standard deviation //
c  x1,x2:  obtained 2 independent gaussian random variables
c
c
c   method:
c             generate following two:
c             sqrt(-log(u)) * cos(p) and  sqrt(-log(u)) * sin(p)
c             then, they are independent gaussian radom variables
c             with mean 0 and variance 1.  here, u is uniform random
c             number in (0,1), and p in (0,2pi)
c        *** note ***  establish condition for rndc usage, if want to
c                      select one of rnd or rnd2.
c
c
      subroutine kgauss(av,s,x1,x2)
c
c
c         *** until loop*** 
         do while (.true.)
             call rndc(u1)
             call rndc(u2)
c              generate cos(p) and sin(p)
             u1=u1+u1-1.
             u1s=u1*u1
             u2s=u2*u2
             tmp=u1s+u2s
         if         (tmp .lt. 1.)
     *                      goto 20
         enddo
   20    continue
         call rndc(u3)
         al=alog(u3)
         al=sqrt(-al-al)
         cs=(u1s-u2s)/tmp
         sn=u1*u2/tmp
         sn=sn+sn
         x1=al*cs*s+av
         x2=al*sn*s+av
      end
c     ****************************************************************
c     *                                                              *
c     * k4ptdi:  4-point two dimensional interpolation               *
c     *                                                              *
c     ****************************************************************
c
c   /usage/
c
c       call
c              k4ptdi(f, im, jm, iadj,  x0, y0, hx, hy, x, y, ans)
c
c     f is a 2-dimensional table of some function with 2 arguments.
c     f containes the function values at (x0,y0), (x0+hx, y0+hy),...
c     (x0+(im-1)*hx, y0+(jm-1)*hy).
c     iadj is the adjustable dimension.
c     ans gets the value of the funtion at (x,y)
c
c
c
      subroutine k4ptdi(f, im, jm, iadj, x0, y0, hx, hy, x, y, ans)
      dimension f(iadj,jm)
c
      a=(x-x0)/hx
      b=(y-y0)/hy
      i=a
      j=b
      i=min0(max0(i,0)+1,im-1)
      j=min0(max0(j,0)+1,jm-1)
      p=a+1.-i
      q=b+1.-j
      p1=1.-p
      q1=1.-q
      ans=( f(i,j)*p1 + f(i+1,j)*p ) * q1 +
     *                  ( f(i,j+1)*p1 + f(i+1,j+1)*p ) * q
      return
      end
c             get theta and fai of direction cos. in rad
       subroutine mudtoa(vx, vy, vz, teta, fai)
           parameter (pi=3.141592, Todeg=180./pi)
           real*8 vx, vy, vz
           if(vz .gt. 1.d0) then
              teta=0.
           else
              teta=acos(vz)
           endif
           if(abs(teta) .lt. 1.e-4) then
               fai=0.
           else
               fai=atan2(vy, vx)
           endif
       end
