#!/bin/bash
work=Work
if [ $#  -lt  5 ] || [ $# -gt 7 ]; then
    echo "Usage: ./testBremSamp.sh  media events E1 E2 step [LPMeffect func]"
    echo "media: such as Fe BGO Air ..."
    echo "events: # of events (samplings) for ehac energy"
    echo "E1 E2: kinetic energy of electron; form E1 to at least E2"
    echo "step:  log10 step of energy"
    echo "LPMeffect: t or f for LPM effect; default is t"
    echo "func:  Brems func by Tsai-->1; by Moch & Kotz-->3(default is 1)"
    exit
fi

media=$1; nevent=$2; E1=$3; E2=$4; step=$5;
if [ $# -ge 6 ]; then
    LPMeffect=$6
    if [ $# -eq 7 ]; then
	func=$7
    else
	func=1
    fi
else
    LPMeffect="t"
    func=1 
fi
# echo input: $media $nevent $E1 $E2 $step

nbin=`awk  'END {nbin=int(log(E2/E1)/log(10.)/step)+1;print nbin}'   E1=$E1 E2=$E2 step=$step /dev/null`
#echo nbin is $nbin
#exit
Ek=$E1

rm -f $work/brems*.png
make -f BrSamp.mk
make -f DrawBremsFunc${func}.mk
for f in $(seq 1 $nbin); do
  echo ${f}-th energy=$Ek 
#  echo $nevent $Ek $media $LPMeffect  |  ./a.out  | awk '{print $1}' | histo -l 1.e-5 0.01 $nevent > $work/brems${f}.hist
  echo 1 $media $Ek $LPMeffect | ./drawbrems${func}.out > $work/brems.func
#   get total normalization const. ( 1/(total rob/r.l))
  Nc=`awk '{print $4; exit}' $work/brems.func` 
  echo "Nc =" $Nc
  ANc=`awk '{print $5; exit}' $work/brems.func` 
  echo "ANc =" $ANc
#   output bremas.func is Nc*ds/dx  ( prob/r.l)
#     dN/dx/N= ds/dx/tprob
#     trpob/N * dN/dx = ds/dx
#    Nc*tprob/N * dN/dx = Nc*ds/dx = output above 
#     ANc = tprob  

  Ncc=`echo  $ANc $Nc  $nevent | awk '{print $3/$1/$2}'`   
echo "Ncc=" $Ncc

  echo $nevent $Ek $media $LPMeffect  |time  ./a.out  | awk '{print $1}' | histo -l 1.e-5 0.01 $Ncc  > $work/brems.hist
#  echo 5 $media $Ek $LPMeffect | ./drawbrem${func}.out > $work/brems${f}.func


  echo "Ek=${Ek}" > $work/gnuplot.com

  cat brems.gp >> $work/gnuplot.com

  echo  set output  \"$work/brems${f}.png\" >>$work/gnuplot.com
  echo  rep  >>$work/gnuplot.com

  gnuplot $work/gnuplot.com

  Ek=`awk 'END {Ek=Ek*10.**step;print Ek}' Ek=$Ek step=$step /dev/null`
done
